/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.navigation.History;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogPanel
extends JBPanel
implements DataProvider {
    @NotNull
    private final VcsLogManager myManager;
    @NotNull
    private final VcsLogUiEx myUi;

    public VcsLogPanel(@NotNull VcsLogManager manager, @NotNull VcsLogUiEx logUi2) {
        if (manager == null) {
            VcsLogPanel.$$$reportNull$$$0(0);
        }
        if (logUi2 == null) {
            VcsLogPanel.$$$reportNull$$$0(1);
        }
        super((LayoutManager)new BorderLayout());
        this.myManager = manager;
        this.myUi = logUi2;
        this.add(this.myUi.getMainComponent(), "Center");
    }

    @NotNull
    public VcsLogUiEx getUi() {
        VcsLogUiEx vcsLogUiEx = this.myUi;
        if (vcsLogUiEx == null) {
            VcsLogPanel.$$$reportNull$$$0(2);
        }
        return vcsLogUiEx;
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            VcsLogPanel.$$$reportNull$$$0(3);
        }
        if (VcsLogInternalDataKeys.LOG_MANAGER.is(dataId)) {
            return this.myManager;
        }
        if (VcsLogDataKeys.VCS_LOG.is(dataId)) {
            return this.myUi.getVcsLog();
        }
        if (VcsLogDataKeys.VCS_LOG_UI.is(dataId)) {
            return this.myUi;
        }
        if (VcsLogDataKeys.VCS_LOG_DATA_PROVIDER.is(dataId) || VcsLogInternalDataKeys.LOG_DATA.is(dataId)) {
            return this.myManager.getDataManager();
        }
        if (VcsLogDataKeys.VCS_LOG_COMMIT_SELECTION.is(dataId)) {
            return this.myUi.getTable().getSelection();
        }
        if (VcsDataKeys.VCS_REVISION_NUMBER.is(dataId)) {
            List<CommitId> hashes2 = this.myUi.getTable().getSelection().getCommits();
            if (hashes2.isEmpty()) {
                return null;
            }
            return VcsLogUtil.convertToRevisionNumber(Objects.requireNonNull((CommitId)ContainerUtil.getFirstItem(hashes2)).getHash());
        }
        if (VcsDataKeys.VCS_REVISION_NUMBERS.is(dataId)) {
            List<CommitId> hashes3 = this.myUi.getTable().getSelection().getCommits();
            if (hashes3.size() > 1000) {
                return null;
            }
            return ContainerUtil.map(hashes3, commitId2 -> VcsLogUtil.convertToRevisionNumber(commitId2.getHash())).toArray(new VcsRevisionNumber[0]);
        }
        if (VcsDataKeys.VCS_COMMIT_SUBJECTS.is(dataId)) {
            List<VcsCommitMetadata> metadata = this.myUi.getTable().getSelection().getCachedMetadata();
            if (metadata.size() > 1000) {
                return null;
            }
            return ContainerUtil.map2Array(metadata, String.class, data2 -> data2.getSubject());
        }
        if (PlatformCoreDataKeys.HELP_ID.is(dataId)) {
            return this.myUi.getHelpId();
        }
        if (History.KEY.is(dataId)) {
            return this.myUi.getNavigationHistory();
        }
        return null;
    }

    @NotNull
    public static List<VcsLogUiEx> getLogUis(@NotNull JComponent c) {
        if (c == null) {
            VcsLogPanel.$$$reportNull$$$0(4);
        }
        HashSet panels = new HashSet();
        VcsLogPanel.collectLogPanelInstances(c, panels);
        List list = ContainerUtil.map(panels, VcsLogPanel::getUi);
        if (list == null) {
            VcsLogPanel.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static void collectLogPanelInstances(@NotNull JComponent component2, @NotNull Set<? super VcsLogPanel> result2) {
        if (component2 == null) {
            VcsLogPanel.$$$reportNull$$$0(6);
        }
        if (result2 == null) {
            VcsLogPanel.$$$reportNull$$$0(7);
        }
        if (component2 instanceof VcsLogPanel) {
            result2.add((VcsLogPanel)((Object)component2));
            return;
        }
        for (Component childComponent : component2.getComponents()) {
            if (!(childComponent instanceof JComponent)) continue;
            VcsLogPanel.collectLogPanelInstances((JComponent)childComponent, result2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logUi";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/VcsLogPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/VcsLogPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUi";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogUis";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLogUis";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectLogPanelInstances";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 5 -> new IllegalStateException(string2);
        };
    }
}

