/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsScopeKt;
import com.intellij.openapi.vcs.telemetry.VcsTelemetrySpan;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.diagnostic.telemetry.helpers.TraceKt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataProvider;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcs.log.data.CommitDetailsGetter;
import com.intellij.vcs.log.data.ContainingBranchesGetter;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.DataPackChangeListener;
import com.intellij.vcs.log.data.EmptyIndex;
import com.intellij.vcs.log.data.InMemoryStorage;
import com.intellij.vcs.log.data.MiniDetailsGetter;
import com.intellij.vcs.log.data.SingleTaskController;
import com.intellij.vcs.log.data.TopCommitsCache;
import com.intellij.vcs.log.data.VcsLogProgress;
import com.intellij.vcs.log.data.VcsLogRefresherImpl;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.VcsLogStorageImpl;
import com.intellij.vcs.log.data.VcsLogUserResolver;
import com.intellij.vcs.log.data.VcsLogUserResolverBase;
import com.intellij.vcs.log.data.VcsUserRegistryImpl;
import com.intellij.vcs.log.data.index.IndexDiagnosticRunner;
import com.intellij.vcs.log.data.index.SqliteVcsLogStorageBackend;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.data.index.VcsLogModifiableIndex;
import com.intellij.vcs.log.data.index.VcsLogPersistentIndex;
import com.intellij.vcs.log.impl.VcsLogCachesInvalidator;
import com.intellij.vcs.log.impl.VcsLogErrorHandler;
import com.intellij.vcs.log.impl.VcsLogSharedSettings;
import com.intellij.vcs.log.util.PersistentUtil;
import io.opentelemetry.api.trace.Span;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class VcsLogData
implements Disposable,
VcsLogDataProvider {
    private static final Logger LOG = Logger.getInstance(VcsLogData.class);
    public static final int RECENT_COMMITS_COUNT = Registry.intValue((String)"vcs.log.recent.commits.count");
    public static final VcsLogProgress.ProgressKey DATA_PACK_REFRESH = new VcsLogProgress.ProgressKey("data pack");
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> myLogProviders;
    @NotNull
    private final MiniDetailsGetter myMiniDetailsGetter;
    @NotNull
    private final CommitDetailsGetter myDetailsGetter;
    @NotNull
    private final CheckedDisposable myDisposableFlag;
    private final Map<VirtualFile, VcsUser> myCurrentUser;
    @NotNull
    private final TopCommitsCache myTopCommitsDetailsCache;
    @NotNull
    private final VcsUserRegistryImpl myUserRegistry;
    @NotNull
    private final VcsLogUserResolver myUserResolver;
    @NotNull
    private final VcsLogStorage myStorage;
    @NotNull
    private final ContainingBranchesGetter myContainingBranchesGetter;
    @NotNull
    private final VcsLogRefresherImpl myRefresher;
    @NotNull
    private final List<DataPackChangeListener> myDataPackChangeListeners;
    @NotNull
    private final VcsLogErrorHandler myErrorHandler;
    @NotNull
    private final VcsLogModifiableIndex myIndex;
    @NotNull
    private final IndexDiagnosticRunner myIndexDiagnosticRunner;
    @NotNull
    private final Object myLock;
    @NotNull
    private State myState;
    @Nullable
    private SingleTaskController.SingleTask myInitialization;

    public VcsLogData(@NotNull Project project2, @NotNull Map<VirtualFile, VcsLogProvider> logProviders, @NotNull VcsLogErrorHandler errorHandler2, @NotNull Disposable parentDisposable) {
        if (project2 == null) {
            VcsLogData.$$$reportNull$$$0(0);
        }
        if (logProviders == null) {
            VcsLogData.$$$reportNull$$$0(1);
        }
        if (errorHandler2 == null) {
            VcsLogData.$$$reportNull$$$0(2);
        }
        if (parentDisposable == null) {
            VcsLogData.$$$reportNull$$$0(3);
        }
        this.myDisposableFlag = Disposer.newCheckedDisposable();
        this.myCurrentUser = new ConcurrentHashMap<VirtualFile, VcsUser>();
        this.myDataPackChangeListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myLock = new Object();
        this.myState = State.CREATED;
        this.myInitialization = null;
        this.myProject = project2;
        this.myLogProviders = logProviders;
        this.myUserRegistry = (VcsUserRegistryImpl)project2.getService(VcsUserRegistry.class);
        this.myErrorHandler = errorHandler2;
        VcsLogProgress progress = new VcsLogProgress(this);
        if (VcsLogCachesInvalidator.getInstance().isValid()) {
            this.myStorage = this.createStorage();
            this.myIndex = this.createIndex(logProviders, progress);
        } else {
            LOG.error("Could not delete caches at " + PersistentUtil.LOG_CACHE);
            this.myErrorHandler.displayMessage(VcsLogBundle.message("vcs.log.fatal.error.message", PersistentUtil.LOG_CACHE, ApplicationNamesInfo.getInstance().getFullProductName()));
            this.myStorage = new InMemoryStorage();
            this.myIndex = new EmptyIndex();
        }
        this.myTopCommitsDetailsCache = new TopCommitsCache(this.myStorage);
        this.myMiniDetailsGetter = new MiniDetailsGetter(this.myProject, this.myStorage, logProviders, this.myTopCommitsDetailsCache, this.myIndex, this);
        this.myDetailsGetter = new CommitDetailsGetter(this.myStorage, logProviders, this);
        this.myRefresher = new VcsLogRefresherImpl(this.myProject, this.myStorage, this.myLogProviders, this.myUserRegistry, this.myIndex, progress, this.myTopCommitsDetailsCache, this::fireDataPackChangeEvent, RECENT_COMMITS_COUNT);
        Disposer.register((Disposable)this, (Disposable)this.myRefresher);
        this.myContainingBranchesGetter = new ContainingBranchesGetter(this, this);
        this.myUserResolver = new MyVcsLogUserResolver();
        this.myIndexDiagnosticRunner = new IndexDiagnosticRunner(this.myIndex, this.myStorage, this.myLogProviders.keySet(), (Function0<? extends DataPack>)((Function0)this::getDataPack), this.myDetailsGetter, this.myErrorHandler, this);
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        Disposer.register((Disposable)this, () -> {
            Object object = this.myLock;
            synchronized (object) {
                if (this.myInitialization != null) {
                    this.myInitialization.cancel();
                }
            }
        });
        Disposer.register((Disposable)this, (Disposable)this.myDisposableFlag);
    }

    @NotNull
    private VcsLogStorage createStorage() {
        try {
            if (Registry.is((String)"vcs.log.index.sqlite.storage", (boolean)false)) {
                return new SqliteVcsLogStorageBackend(this.myProject, this.myLogProviders, this.myErrorHandler, this);
            }
            return new VcsLogStorageImpl(this.myProject, this.myLogProviders, this.myErrorHandler, this);
        }
        catch (IOException e) {
            LOG.error("Falling back to in-memory hashes", (Throwable)e);
            return new InMemoryStorage();
        }
    }

    @NotNull
    private VcsLogModifiableIndex createIndex(@NotNull Map<VirtualFile, VcsLogProvider> logProviders, @NotNull VcsLogProgress progress) {
        if (logProviders == null) {
            VcsLogData.$$$reportNull$$$0(4);
        }
        if (progress == null) {
            VcsLogData.$$$reportNull$$$0(5);
        }
        if (!VcsLogSharedSettings.isIndexSwitchedOn(this.myProject)) {
            LOG.info("Vcs log index is turned off for project " + this.myProject.getName());
            return new EmptyIndex();
        }
        VcsLogPersistentIndex index = VcsLogPersistentIndex.create(this.myProject, this.myStorage, logProviders, progress, this.myErrorHandler, this);
        if (index == null) {
            LOG.error("Cannot create vcs log index for project " + this.myProject.getName());
            return new EmptyIndex();
        }
        VcsLogPersistentIndex vcsLogPersistentIndex = index;
        if (vcsLogPersistentIndex == null) {
            VcsLogData.$$$reportNull$$$0(6);
        }
        return vcsLogPersistentIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myState.equals((Object)State.CREATED)) {
                this.myState = State.INITIALIZED;
                final Span span = TelemetryManager.getInstance().getTracer(VcsScopeKt.VcsScope).spanBuilder(VcsTelemetrySpan.LogData.Initialize.getName()).startSpan();
                Task.Backgroundable backgroundable = new Task.Backgroundable(this.myProject, VcsLogBundle.message("vcs.log.initial.loading.process", new Object[0]), false){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        TraceKt.runSpanWithScope((Span)span, () -> {
                            indicator.setIndeterminate(true);
                            VcsLogData.this.resetState();
                            VcsLogData.this.readCurrentUser();
                            VcsLogData.this.myRefresher.readFirstBlock();
                            VcsLogData.this.fireDataPackChangeEvent(VcsLogData.this.myRefresher.getCurrentDataPack());
                        });
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onCancel() {
                        Object object = VcsLogData.this.myLock;
                        synchronized (object) {
                            if (VcsLogData.this.myState.equals((Object)State.INITIALIZED)) {
                                VcsLogData.this.myState = State.CREATED;
                                VcsLogData.this.myInitialization = null;
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onThrowable(@NotNull Throwable error) {
                        if (error == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        Object object = VcsLogData.this.myLock;
                        synchronized (object) {
                            LOG.error(error);
                            if (VcsLogData.this.myState.equals((Object)State.INITIALIZED)) {
                                VcsLogData.this.myState = State.CREATED;
                                VcsLogData.this.myInitialization = null;
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onSuccess() {
                        Object object = VcsLogData.this.myLock;
                        synchronized (object) {
                            if (VcsLogData.this.myState.equals((Object)State.INITIALIZED)) {
                                VcsLogData.this.myInitialization = null;
                            }
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "indicator";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "error";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/vcs/log/data/VcsLogData$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "run";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onThrowable";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                CoreProgressManager manager = (CoreProgressManager)ProgressManager.getInstance();
                ProgressIndicator indicator = this.myRefresher.getProgress().createProgressIndicator(DATA_PACK_REFRESH);
                Future future2 = manager.runProcessWithProgressAsynchronously(backgroundable, indicator, null);
                this.myInitialization = new SingleTaskController.SingleTaskImpl(future2, indicator);
            }
        }
    }

    private void readCurrentUser() {
        Span span = TelemetryManager.getInstance().getTracer(VcsScopeKt.VcsScope).spanBuilder(VcsTelemetrySpan.LogData.ReadCurrentUser.getName()).startSpan();
        for (Map.Entry<VirtualFile, VcsLogProvider> entry2 : this.myLogProviders.entrySet()) {
            VirtualFile root = entry2.getKey();
            try {
                VcsUser me = entry2.getValue().getCurrentUser(root);
                if (me != null) {
                    this.myCurrentUser.put(root, me);
                    continue;
                }
                LOG.info("Username not configured for root " + root);
            }
            catch (VcsException e) {
                LOG.warn("Couldn't read the username from root " + root, (Throwable)e);
            }
        }
        span.end();
    }

    private void fireDataPackChangeEvent(@NotNull DataPack dataPack) {
        if (dataPack == null) {
            VcsLogData.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            for (DataPackChangeListener listener2 : this.myDataPackChangeListeners) {
                listener2.onDataPackChange(dataPack);
            }
        }, o -> this.myDisposableFlag.isDisposed());
        this.myIndexDiagnosticRunner.onDataPackChange();
    }

    public void addDataPackChangeListener(@NotNull DataPackChangeListener listener2) {
        if (listener2 == null) {
            VcsLogData.$$$reportNull$$$0(8);
        }
        this.myDataPackChangeListeners.add(listener2);
    }

    public void removeDataPackChangeListener(@NotNull DataPackChangeListener listener2) {
        if (listener2 == null) {
            VcsLogData.$$$reportNull$$$0(9);
        }
        this.myDataPackChangeListeners.remove(listener2);
    }

    @NotNull
    public DataPack getDataPack() {
        DataPack dataPack = this.myRefresher.getCurrentDataPack();
        if (dataPack == null) {
            VcsLogData.$$$reportNull$$$0(10);
        }
        return dataPack;
    }

    @Override
    @Nullable
    public CommitId getCommitId(int commitIndex) {
        return this.myStorage.getCommitId(commitIndex);
    }

    @Override
    public int getCommitIndex(@NotNull Hash hash2, @NotNull VirtualFile root) {
        if (hash2 == null) {
            VcsLogData.$$$reportNull$$$0(11);
        }
        if (root == null) {
            VcsLogData.$$$reportNull$$$0(12);
        }
        return this.myStorage.getCommitIndex(hash2, root);
    }

    @NotNull
    public VcsLogStorage getStorage() {
        VcsLogStorage vcsLogStorage = this.myStorage;
        if (vcsLogStorage == null) {
            VcsLogData.$$$reportNull$$$0(13);
        }
        return vcsLogStorage;
    }

    private void resetState() {
        this.myTopCommitsDetailsCache.clear();
    }

    @NotNull
    public Set<VcsUser> getAllUsers() {
        Set<VcsUser> set = this.myUserRegistry.getUsers();
        if (set == null) {
            VcsLogData.$$$reportNull$$$0(14);
        }
        return set;
    }

    @NotNull
    public Map<VirtualFile, VcsUser> getCurrentUser() {
        Map<VirtualFile, VcsUser> map2 = this.myCurrentUser;
        if (map2 == null) {
            VcsLogData.$$$reportNull$$$0(15);
        }
        return map2;
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            VcsLogData.$$$reportNull$$$0(16);
        }
        return project2;
    }

    @NotNull
    public Collection<VirtualFile> getRoots() {
        Set<VirtualFile> set = this.myLogProviders.keySet();
        if (set == null) {
            VcsLogData.$$$reportNull$$$0(17);
        }
        return set;
    }

    @NotNull
    public Map<VirtualFile, VcsLogProvider> getLogProviders() {
        Map<VirtualFile, VcsLogProvider> map2 = this.myLogProviders;
        if (map2 == null) {
            VcsLogData.$$$reportNull$$$0(18);
        }
        return map2;
    }

    @NotNull
    public ContainingBranchesGetter getContainingBranchesGetter() {
        ContainingBranchesGetter containingBranchesGetter = this.myContainingBranchesGetter;
        if (containingBranchesGetter == null) {
            VcsLogData.$$$reportNull$$$0(19);
        }
        return containingBranchesGetter;
    }

    public void refresh(@NotNull Collection<VirtualFile> roots) {
        if (roots == null) {
            VcsLogData.$$$reportNull$$$0(20);
        }
        this.initialize();
        this.myRefresher.refresh(roots);
    }

    @NotNull
    public CommitDetailsGetter getCommitDetailsGetter() {
        CommitDetailsGetter commitDetailsGetter = this.myDetailsGetter;
        if (commitDetailsGetter == null) {
            VcsLogData.$$$reportNull$$$0(21);
        }
        return commitDetailsGetter;
    }

    @NotNull
    public MiniDetailsGetter getMiniDetailsGetter() {
        MiniDetailsGetter miniDetailsGetter = this.myMiniDetailsGetter;
        if (miniDetailsGetter == null) {
            VcsLogData.$$$reportNull$$$0(22);
        }
        return miniDetailsGetter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        SingleTaskController.SingleTask initialization;
        Object object = this.myLock;
        synchronized (object) {
            initialization = this.myInitialization;
            this.myInitialization = null;
            this.myState = State.DISPOSED;
        }
        if (initialization != null) {
            initialization.cancel();
            try {
                initialization.waitFor(1L, TimeUnit.MINUTES);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                LOG.warn((Throwable)e);
            }
        }
        this.resetState();
    }

    @NotNull
    public VcsLogProvider getLogProvider(@NotNull VirtualFile root) {
        if (root == null) {
            VcsLogData.$$$reportNull$$$0(23);
        }
        VcsLogProvider vcsLogProvider = this.myLogProviders.get(root);
        if (vcsLogProvider == null) {
            VcsLogData.$$$reportNull$$$0(24);
        }
        return vcsLogProvider;
    }

    @NotNull
    public VcsUserRegistryImpl getUserRegistry() {
        VcsUserRegistryImpl vcsUserRegistryImpl = this.myUserRegistry;
        if (vcsUserRegistryImpl == null) {
            VcsLogData.$$$reportNull$$$0(25);
        }
        return vcsUserRegistryImpl;
    }

    @NotNull
    public VcsLogUserResolver getUserNameResolver() {
        VcsLogUserResolver vcsLogUserResolver = this.myUserResolver;
        if (vcsLogUserResolver == null) {
            VcsLogData.$$$reportNull$$$0(26);
        }
        return vcsLogUserResolver;
    }

    @NotNull
    public VcsLogProgress getProgress() {
        VcsLogProgress vcsLogProgress = this.myRefresher.getProgress();
        if (vcsLogProgress == null) {
            VcsLogData.$$$reportNull$$$0(27);
        }
        return vcsLogProgress;
    }

    @NotNull
    public TopCommitsCache getTopCommitsCache() {
        TopCommitsCache topCommitsCache = this.myTopCommitsDetailsCache;
        if (topCommitsCache == null) {
            VcsLogData.$$$reportNull$$$0(28);
        }
        return topCommitsCache;
    }

    @NotNull
    public VcsLogIndex getIndex() {
        VcsLogModifiableIndex vcsLogModifiableIndex = this.getModifiableIndex();
        if (vcsLogModifiableIndex == null) {
            VcsLogData.$$$reportNull$$$0(29);
        }
        return vcsLogModifiableIndex;
    }

    @TestOnly
    @NotNull
    VcsLogModifiableIndex getModifiableIndex() {
        VcsLogModifiableIndex vcsLogModifiableIndex = this.myIndex;
        if (vcsLogModifiableIndex == null) {
            VcsLogData.$$$reportNull$$$0(30);
        }
        return vcsLogModifiableIndex;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 10, 13, 14, 15, 16, 17, 18, 19, 21, 22, 24, 25, 26, 27, 28, 29, 30 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logProviders";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 6: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/VcsLogData";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPack";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 12: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/VcsLogData";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createIndex";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataPack";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorage";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllUsers";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentUser";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogProviders";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingBranchesGetter";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitDetailsGetter";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getMiniDetailsGetter";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogProvider";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserRegistry";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserNameResolver";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getProgress";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopCommitsCache";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndex";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiableIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createIndex";
                break;
            }
            case 6: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fireDataPackChangeEvent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addDataPackChangeListener";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeDataPackChangeListener";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCommitIndex";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "refresh";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getLogProvider";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 6, 10, 13, 14, 15, 16, 17, 18, 19, 21, 22, 24, 25, 26, 27, 28, 29, 30 -> new IllegalStateException(string2);
        };
    }

    private static enum State {
        CREATED,
        INITIALIZED,
        DISPOSED;

    }

    private class MyVcsLogUserResolver
    extends VcsLogUserResolverBase
    implements Disposable {
        @NotNull
        private final DataPackChangeListener myListener = newDataPack -> this.clearCache();

        MyVcsLogUserResolver() {
            VcsLogData.this.addDataPackChangeListener(this.myListener);
            Disposer.register((Disposable)VcsLogData.this, (Disposable)this);
        }

        @Override
        @NotNull
        public Map<VirtualFile, VcsUser> getCurrentUsers() {
            Map<VirtualFile, VcsUser> map2 = VcsLogData.this.getCurrentUser();
            if (map2 == null) {
                MyVcsLogUserResolver.$$$reportNull$$$0(0);
            }
            return map2;
        }

        @Override
        @NotNull
        public Set<VcsUser> getAllUsers() {
            Set<VcsUser> set = VcsLogData.this.getAllUsers();
            if (set == null) {
                MyVcsLogUserResolver.$$$reportNull$$$0(1);
            }
            return set;
        }

        public void dispose() {
            VcsLogData.this.removeDataPackChangeListener(this.myListener);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/vcs/log/data/VcsLogData$MyVcsLogUserResolver";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCurrentUsers";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllUsers";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

