/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.grazie.dictionary;

import ai.grazie.spell.lists.WordList;
import com.intellij.spellchecker.dictionary.Dictionary;
import com.intellij.spellchecker.grazie.dictionary.EditableAggregatedWordList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nJ\u0016\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\tJ\u000e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\tJ\u0006\u0010\u001b\u001a\u00020\u0012R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/intellij/spellchecker/grazie/dictionary/EditableWordListAdapter;", "", "()V", "aggregator", "Lcom/intellij/spellchecker/grazie/dictionary/EditableAggregatedWordList;", "getAggregator", "()Lcom/intellij/spellchecker/grazie/dictionary/EditableAggregatedWordList;", "dictionaries", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/spellchecker/dictionary/Dictionary;", "getDictionaries", "()Ljava/util/concurrent/ConcurrentHashMap;", "names", "", "getNames", "()Ljava/util/Set;", "addDictionary", "", "dictionary", "addList", "name", "list", "Lai/grazie/spell/lists/WordList;", "containsSource", "", "removeSource", "reset", "intellij.spellchecker"})
public abstract class EditableWordListAdapter {
    @NotNull
    private final ConcurrentHashMap<String, Dictionary> dictionaries = new ConcurrentHashMap();
    @NotNull
    private final EditableAggregatedWordList aggregator = new EditableAggregatedWordList();

    @NotNull
    protected final ConcurrentHashMap<String, Dictionary> getDictionaries() {
        return this.dictionaries;
    }

    @NotNull
    protected final EditableAggregatedWordList getAggregator() {
        return this.aggregator;
    }

    @NotNull
    public final Set<String> getNames() {
        Set<String> set = this.aggregator.getKeys();
        Set set2 = this.dictionaries.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"dictionaries.keys");
        return SetsKt.plus(set, (Iterable)set2);
    }

    public final void addDictionary(@NotNull Dictionary dictionary) {
        Intrinsics.checkNotNullParameter((Object)dictionary, (String)"dictionary");
        Map map2 = this.dictionaries;
        String string2 = dictionary.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"dictionary.name");
        map2.put(string2, dictionary);
    }

    public final void addList(@NotNull String name, @NotNull WordList list) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        this.aggregator.addList(name, list);
    }

    public final boolean containsSource(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.dictionaries.containsKey(name) || this.aggregator.containsList(name);
    }

    public final void removeSource(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.dictionaries.remove(name);
        this.aggregator.removeList(name);
    }

    public final void reset() {
        this.dictionaries.clear();
        this.aggregator.clear();
    }
}

