/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.roots;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.VcsRootError;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.configurable.VcsMappingConfigurable;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.roots.VcsRootErrorsFinder;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class VcsRootProblemNotifier {
    private static final Logger LOG = Logger.getInstance(VcsRootProblemNotifier.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsConfiguration mySettings;
    @NotNull
    private final ProjectLevelVcsManagerImpl myVcsManager;
    @NotNull
    private final ChangeListManager myChangeListManager;
    @NotNull
    private final ProjectFileIndex myProjectFileIndex;
    @NotNull
    private final Set<String> myReportedUnregisteredRoots;
    @Nullable
    private Notification myNotification;
    @NotNull
    private final Object NOTIFICATION_LOCK;
    @NotNull
    private final Function<VcsRootError, String> ROOT_TO_PRESENTABLE;

    public static VcsRootProblemNotifier createInstance(@NotNull Project project2) {
        if (project2 == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(0);
        }
        return new VcsRootProblemNotifier(project2);
    }

    private VcsRootProblemNotifier(@NotNull Project project2) {
        if (project2 == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(1);
        }
        this.NOTIFICATION_LOCK = new Object();
        this.ROOT_TO_PRESENTABLE = rootError -> this.getPresentableMapping(rootError.getMapping());
        this.myProject = project2;
        this.mySettings = VcsConfiguration.getInstance(this.myProject);
        this.myChangeListManager = ChangeListManager.getInstance(project2);
        this.myProjectFileIndex = ProjectFileIndex.getInstance((Project)this.myProject);
        this.myVcsManager = ProjectLevelVcsManagerImpl.getInstanceImpl(project2);
        this.myReportedUnregisteredRoots = new HashSet<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rescanAndNotifyIfNeeded() {
        NotificationAction[] notificationActions;
        String description2;
        String title2;
        Collection<VcsRootError> errors = this.scan();
        if (errors.isEmpty()) {
            Object object = this.NOTIFICATION_LOCK;
            synchronized (object) {
                this.expireNotification();
            }
            return;
        }
        ProjectLevelVcsManagerEx.MAPPING_DETECTION_LOG.debug("Following errors detected: " + errors);
        List<VcsRootError> importantUnregisteredRoots = this.getImportantUnregisteredMappings(errors);
        Collection<VcsRootError> invalidRoots = VcsRootProblemNotifier.getInvalidRoots(errors);
        if (Registry.is((String)"vcs.root.auto.add") && !this.areThereExplicitlyIgnoredRoots(errors)) {
            VcsRootError rootError2;
            if (invalidRoots.isEmpty() && importantUnregisteredRoots.isEmpty()) {
                return;
            }
            LOG.info("Auto-registered following mappings: " + importantUnregisteredRoots);
            this.addMappings(importantUnregisteredRoots, true);
            if (invalidRoots.isEmpty() && importantUnregisteredRoots.size() == 1 && FileUtil.pathsEqual((String)(rootError2 = Objects.requireNonNull((VcsRootError)ContainerUtil.getFirstItem(importantUnregisteredRoots))).getMapping().getDirectory(), (String)this.myProject.getBasePath())) {
                return;
            }
            if (invalidRoots.isEmpty() && !Registry.is((String)"vcs.root.auto.add.nofity")) {
                return;
            }
            title2 = VcsRootProblemNotifier.makeTitle(importantUnregisteredRoots, invalidRoots, true);
            description2 = this.makeDescription(importantUnregisteredRoots, invalidRoots);
            notificationActions = new NotificationAction[]{this.getConfigureNotificationAction()};
        } else {
            List unregRootPaths = ContainerUtil.map(importantUnregisteredRoots, rootError -> rootError.getMapping().getDirectory());
            if (invalidRoots.isEmpty() && (importantUnregisteredRoots.isEmpty() || this.myReportedUnregisteredRoots.containsAll(unregRootPaths))) {
                return;
            }
            this.myReportedUnregisteredRoots.addAll(unregRootPaths);
            title2 = VcsRootProblemNotifier.makeTitle(importantUnregisteredRoots, invalidRoots, false);
            description2 = this.makeDescription(importantUnregisteredRoots, invalidRoots);
            NotificationAction enableIntegration = NotificationAction.create(VcsBundle.messagePointer("action.NotificationAction.VcsRootProblemNotifier.text.enable.integration", new Object[0]), (event, notification) -> this.addMappings(importantUnregisteredRoots, false));
            NotificationAction ignoreAction = NotificationAction.create(VcsBundle.messagePointer("action.NotificationAction.VcsRootProblemNotifier.text.ignore", new Object[0]), (event, notification) -> {
                this.mySettings.addIgnoredUnregisteredRoots(ContainerUtil.map((Collection)importantUnregisteredRoots, rootError -> rootError.getMapping().getDirectory()));
                notification.expire();
            });
            notificationActions = new NotificationAction[]{enableIntegration, this.getConfigureNotificationAction(), ignoreAction};
        }
        ProgressManager.checkCanceled();
        Object object = this.NOTIFICATION_LOCK;
        synchronized (object) {
            this.expireNotification();
            VcsNotifier notifier = VcsNotifier.getInstance(this.myProject);
            this.myNotification = invalidRoots.isEmpty() ? notifier.notifyMinorInfo("vcs.roots.registered", title2, description2, notificationActions) : notifier.notifyError("vcs.roots.invalid", title2, description2, this.getConfigureNotificationAction());
        }
    }

    @NotNull
    private NotificationAction getConfigureNotificationAction() {
        NotificationAction notificationAction = NotificationAction.create(VcsBundle.messagePointer("action.NotificationAction.VcsRootProblemNotifier.text.configure", new Object[0]), (event, notification) -> {
            if (!this.myProject.isDisposed()) {
                ShowSettingsUtil.getInstance().showSettingsDialog(this.myProject, VcsMappingConfigurable.class);
                BackgroundTaskUtil.executeOnPooledThread((Disposable)this.myProject, () -> {
                    Collection<VcsRootError> errorsAfterPossibleFix = new VcsRootProblemNotifier(this.myProject).scan();
                    if (errorsAfterPossibleFix.isEmpty() && !notification.isExpired()) {
                        notification.expire();
                    }
                });
            }
        });
        if (notificationAction == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(2);
        }
        return notificationAction;
    }

    private void addMappings(Collection<? extends VcsRootError> importantUnregisteredRoots, boolean silently) {
        List<VcsDirectoryMapping> mappings = this.myVcsManager.getDirectoryMappings();
        for (VcsRootError vcsRootError : importantUnregisteredRoots) {
            mappings = VcsUtil.addMapping(mappings, vcsRootError.getMapping());
        }
        if (silently) {
            this.myVcsManager.setAutoDirectoryMappings(mappings);
        } else {
            this.myVcsManager.setDirectoryMappings(mappings);
        }
    }

    private boolean isUnderOrAboveProjectDir(@NotNull VcsDirectoryMapping mapping) {
        if (mapping == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(3);
        }
        String projectDir = Objects.requireNonNull(this.myProject.getBasePath());
        return mapping.isDefaultMapping() || FileUtil.isAncestor((String)projectDir, (String)mapping.getDirectory(), (boolean)false) || FileUtil.isAncestor((String)mapping.getDirectory(), (String)projectDir, (boolean)false);
    }

    private boolean isIgnoredOrExcludedPath(@NotNull VcsDirectoryMapping mapping) {
        if (mapping == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(4);
        }
        if (mapping.isDefaultMapping()) {
            return false;
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(mapping.getDirectory());
        return file != null && (this.myChangeListManager.isIgnoredFile(file) || (Boolean)ReadAction.compute(() -> this.myProjectFileIndex.isExcluded(file)) != false);
    }

    private boolean isExplicitlyIgnoredPath(@NotNull VcsDirectoryMapping mapping) {
        if (mapping == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(5);
        }
        if (mapping.isDefaultMapping()) {
            return false;
        }
        return this.mySettings.isIgnoredUnregisteredRoot(mapping.getDirectory());
    }

    private boolean conflictsWithExistingMapping(@NotNull VcsDirectoryMapping mapping) {
        if (mapping == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(6);
        }
        if (mapping.isDefaultMapping()) {
            return false;
        }
        return ContainerUtil.exists(this.myVcsManager.getDirectoryMappings(), it -> Objects.equals(mapping.getDirectory(), it.getDirectory()));
    }

    private void expireNotification() {
        if (this.myNotification != null) {
            Notification notification = this.myNotification;
            ApplicationManager.getApplication().invokeLater(() -> ((Notification)notification).expire());
            this.myNotification = null;
        }
    }

    @NotNull
    private Collection<VcsRootError> scan() {
        Collection<VcsRootError> collection = new VcsRootErrorsFinder(this.myProject).find();
        if (collection == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(7);
        }
        return collection;
    }

    @NotNull
    @NlsContexts.NotificationContent
    private String makeDescription(@NotNull Collection<? extends VcsRootError> unregisteredRoots, @NotNull Collection<? extends VcsRootError> invalidRoots) {
        if (unregisteredRoots == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(8);
        }
        if (invalidRoots == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(9);
        }
        @Nls StringBuilder description2 = new StringBuilder();
        if (!invalidRoots.isEmpty()) {
            if (invalidRoots.size() == 1) {
                VcsRootError rootError = invalidRoots.iterator().next();
                String vcsName = rootError.getMapping().getVcs();
                description2.append(this.getInvalidRootDescriptionItem(rootError, vcsName));
            } else {
                description2.append(VcsBundle.message("roots.the.following.directories.are.registered.as.vcs.roots.but.they.are.not", new Object[0])).append("<br/>").append(this.joinRootsForPresentation(invalidRoots));
            }
            description2.append("<br/>");
        }
        if (!unregisteredRoots.isEmpty()) {
            if (unregisteredRoots.size() == 1) {
                VcsRootError unregisteredRoot = unregisteredRoots.iterator().next();
                description2.append((String)this.ROOT_TO_PRESENTABLE.fun((Object)unregisteredRoot));
            } else {
                description2.append(this.joinRootsForPresentation(unregisteredRoots));
            }
        }
        String string2 = description2.toString();
        if (string2 == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(10);
        }
        return string2;
    }

    @VisibleForTesting
    @NlsContexts.NotificationContent
    @NotNull
    String getInvalidRootDescriptionItem(@NotNull VcsRootError rootError, @NotNull String vcsName) {
        if (rootError == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(11);
        }
        if (vcsName == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(12);
        }
        String string2 = VcsBundle.message("roots.notification.content.directory.registered.as.root.but.no.repositories.were.found.there", this.ROOT_TO_PRESENTABLE.fun((Object)rootError), vcsName);
        if (string2 == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(13);
        }
        return string2;
    }

    @NotNull
    private String joinRootsForPresentation(@NotNull Collection<? extends VcsRootError> errors) {
        if (errors == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(14);
        }
        List sortedRoots2 = ContainerUtil.sorted(errors, (root1, root2) -> {
            if (root1.getMapping().isDefaultMapping()) {
                return -1;
            }
            if (root2.getMapping().isDefaultMapping()) {
                return 1;
            }
            return root1.getMapping().getDirectory().compareTo(root2.getMapping().getDirectory());
        });
        String string2 = StringUtil.join((Collection)sortedRoots2, this.ROOT_TO_PRESENTABLE, (String)"<br/>");
        if (string2 == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(15);
        }
        return string2;
    }

    @NotNull
    @NlsContexts.NotificationTitle
    private static String makeTitle(@NotNull Collection<? extends VcsRootError> unregisteredRoots, @NotNull Collection<? extends VcsRootError> invalidRoots, boolean rootsAlreadyAdded) {
        String title2;
        if (unregisteredRoots == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(16);
        }
        if (invalidRoots == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(17);
        }
        if (unregisteredRoots.isEmpty()) {
            title2 = VcsBundle.message("roots.notification.title.invalid.vcs.root.choice.mapping.mappings", invalidRoots.size());
        } else if (invalidRoots.isEmpty()) {
            String vcs = VcsRootProblemNotifier.getVcsName(unregisteredRoots);
            title2 = rootsAlreadyAdded ? VcsBundle.message("roots.notification.title.vcs.name.integration.enabled", vcs) : VcsBundle.message("notification.title.vcs.name.repository.repositories.found", vcs, unregisteredRoots.size());
        } else {
            title2 = VcsBundle.message("roots.notification.title.vcs.root.configuration.problems", new Object[0]);
        }
        String string2 = title2;
        if (string2 == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(18);
        }
        return string2;
    }

    private static String getVcsName(Collection<? extends VcsRootError> roots) {
        String result2 = null;
        for (VcsRootError vcsRootError : roots) {
            String vcsName = vcsRootError.getMapping().getVcs();
            if (result2 == null) {
                result2 = vcsName;
                continue;
            }
            if (result2.equals(vcsName)) continue;
            return VcsBundle.message("vcs.generic.name", new Object[0]);
        }
        return result2;
    }

    @NotNull
    private List<VcsRootError> getImportantUnregisteredMappings(@NotNull Collection<? extends VcsRootError> errors) {
        if (errors == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(19);
        }
        List list = ContainerUtil.filter(errors, error -> {
            VcsDirectoryMapping mapping = error.getMapping();
            return error.getType() == VcsRootError.Type.UNREGISTERED_ROOT && this.isUnderOrAboveProjectDir(mapping) && !this.isIgnoredOrExcludedPath(mapping) && !this.isExplicitlyIgnoredPath(mapping) && !this.conflictsWithExistingMapping(mapping);
        });
        if (list == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(20);
        }
        return list;
    }

    private boolean areThereExplicitlyIgnoredRoots(Collection<? extends VcsRootError> allErrors) {
        return ContainerUtil.exists(allErrors, it -> it.getType() == VcsRootError.Type.UNREGISTERED_ROOT && this.isExplicitlyIgnoredPath(it.getMapping()));
    }

    @NotNull
    private static Collection<VcsRootError> getInvalidRoots(@NotNull Collection<? extends VcsRootError> errors) {
        if (errors == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(21);
        }
        List list = ContainerUtil.filter(errors, error -> error.getType() == VcsRootError.Type.EXTRA_MAPPING);
        if (list == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(22);
        }
        return list;
    }

    @VisibleForTesting
    @NotNull
    String getPresentableMapping(@NotNull VcsDirectoryMapping directoryMapping) {
        if (directoryMapping == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(23);
        }
        if (directoryMapping.isDefaultMapping()) {
            String string2 = directoryMapping.toString();
            if (string2 == null) {
                VcsRootProblemNotifier.$$$reportNull$$$0(24);
            }
            return string2;
        }
        String string3 = this.getPresentableMapping(directoryMapping.getDirectory());
        if (string3 == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(25);
        }
        return string3;
    }

    @VisibleForTesting
    @NotNull
    String getPresentableMapping(@NotNull String mapping) {
        if (mapping == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(26);
        }
        FilePath filePath = VcsUtil.getFilePath(mapping);
        String presentablePath = VcsUtil.getPresentablePath(this.myProject, filePath, false, false);
        String string2 = StringUtil.escapeXmlEntities((String)presentablePath);
        if (string2 == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(27);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 7, 10, 13, 15, 18, 20, 22, 24, 25, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unregisteredRoots";
                break;
            }
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invalidRoots";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootError";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsName";
                break;
            }
            case 14: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryMapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigureNotificationAction";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "scan";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "makeDescription";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvalidRootDescriptionItem";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "joinRootsForPresentation";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "makeTitle";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportantUnregisteredMappings";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvalidRoots";
                break;
            }
            case 24: 
            case 25: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableMapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isUnderOrAboveProjectDir";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredOrExcludedPath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isExplicitlyIgnoredPath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "conflictsWithExistingMapping";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "makeDescription";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getInvalidRootDescriptionItem";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "joinRootsForPresentation";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "makeTitle";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getImportantUnregisteredMappings";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getInvalidRoots";
                break;
            }
            case 23: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableMapping";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 7, 10, 13, 15, 18, 20, 22, 24, 25, 27 -> new IllegalStateException(string2);
        };
    }
}

