/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.ex.FileSystemTreeImpl;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.FilePathIconProvider;
import com.intellij.openapi.vcs.impl.RepositoryBrowserPanel;
import com.intellij.openapi.vcs.impl.VcsVirtualFileContentRevision;
import com.intellij.openapi.vcs.vfs.AbstractVcsVirtualFile;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.PlatformIcons;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 !2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001!B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00120\u001eJ\u0006\u0010\u001f\u001a\u00020 R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\""}, d2={"Lcom/intellij/openapi/vcs/impl/RepositoryBrowserPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vcs/vfs/AbstractVcsVirtualFile;", "localRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/vfs/AbstractVcsVirtualFile;Lcom/intellij/openapi/vfs/VirtualFile;)V", "fileSystemTree", "Lcom/intellij/openapi/fileChooser/ex/FileSystemTreeImpl;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRoot", "()Lcom/intellij/openapi/vcs/vfs/AbstractVcsVirtualFile;", "createChangeVsLocal", "Lcom/intellij/openapi/vcs/changes/Change;", "file", "Lcom/intellij/openapi/vcs/vfs/VcsVirtualFile;", "dispose", "", "getData", "", "dataId", "", "getLocalFilePath", "Lcom/intellij/openapi/vcs/FilePath;", "getSelectionAsChanges", "", "hasSelectedFiles", "", "Companion", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nRepositoryBrowser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RepositoryBrowser.kt\ncom/intellij/openapi/vcs/impl/RepositoryBrowserPanel\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,205:1\n3792#2:206\n4307#2,2:207\n12744#2,2:215\n4098#2,11:217\n1549#3:209\n1620#3,3:210\n1549#3:228\n1620#3,3:229\n37#4,2:213\n*S KotlinDebug\n*F\n+ 1 RepositoryBrowser.kt\ncom/intellij/openapi/vcs/impl/RepositoryBrowserPanel\n*L\n134#1:206\n134#1:207,2\n146#1:215,2\n150#1:217,11\n135#1:209\n135#1:210,3\n151#1:228\n151#1:229,3\n136#1:213,2\n*E\n"})
public final class RepositoryBrowserPanel
extends JPanel
implements DataProvider,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final AbstractVcsVirtualFile root;
    @NotNull
    private final VirtualFile localRoot;
    @NotNull
    private final FileSystemTreeImpl fileSystemTree;
    @NotNull
    private static final DataKey<RepositoryBrowserPanel> REPOSITORY_BROWSER_DATA_KEY;

    public RepositoryBrowserPanel(@NotNull Project project2, @NotNull AbstractVcsVirtualFile root, @NotNull VirtualFile localRoot) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)root), (String)"root");
        Intrinsics.checkNotNullParameter((Object)localRoot, (String)"localRoot");
        super(new BorderLayout());
        this.project = project2;
        this.root = root;
        this.localRoot = localRoot;
        FileChooserDescriptor fileChooserDescriptor2 = new FileChooserDescriptor(this){
            final /* synthetic */ RepositoryBrowserPanel this$0;
            {
                this.this$0 = $receiver;
                super(true, false, false, false, false, true);
            }

            @NotNull
            public List<VirtualFile> getRoots() {
                return CollectionsKt.listOf((Object)((Object)this.this$0.getRoot()));
            }

            @Nullable
            public Icon getIcon(@NotNull VirtualFile file) {
                FilePath localPath;
                Icon icon2;
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                if (file.isDirectory()) {
                    return PlatformIcons.FOLDER_ICON;
                }
                if (file instanceof VcsVirtualFile && (icon2 = (Icon)FilePathIconProvider.EP_NAME.computeSafeIfAny(arg_0 -> fileChooserDescriptor.1.getIcon$lambda$0(localPath = RepositoryBrowserPanel.access$getLocalFilePath(this.this$0, (VcsVirtualFile)file), this.this$0, arg_0))) != null) {
                    return icon2;
                }
                return FileTypeManager.getInstance().getFileTypeByFileName(file.getNameSequence()).getIcon();
            }

            private static final Icon getIcon$lambda$0(FilePath $localPath, RepositoryBrowserPanel this$0, FilePathIconProvider it) {
                Intrinsics.checkNotNullParameter((Object)$localPath, (String)"$localPath");
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                return it.getIcon($localPath, this$0.getProject());
            }
        };
        Project project3 = this.project;
        this.fileSystemTree = new FileSystemTreeImpl(fileChooserDescriptor2, project3){};
        this.fileSystemTree.addOkAction(() -> RepositoryBrowserPanel._init_$lambda$0(this));
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add(ActionManager.getInstance().getAction("EditSource"));
        actionGroup.add(ActionManager.getInstance().getAction("Vcs.ShowDiffWithLocal"));
        this.fileSystemTree.registerMouseListener((ActionGroup)actionGroup);
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)(this.fileSystemTree).getTree(), (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"createScrollPane(fileSystemTree.tree, true)");
        JScrollPane scrollPane = jScrollPane;
        this.add((Component)scrollPane, "Center");
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final AbstractVcsVirtualFile getRoot() {
        return this.root;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object getData(@NotNull String dataId) {
        Serializable serializable;
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            serializable = (Serializable)this.fileSystemTree.getSelectedFiles();
        } else if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            void $this$mapTo$iv$iv;
            Iterable $this$filterTo$iv$iv;
            VirtualFile[] virtualFileArray = this.fileSystemTree.getSelectedFiles();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"fileSystemTree.selectedFiles");
            Object[] $this$filter$iv = virtualFileArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (VirtualFile element$iv$iv : $this$filterTo$iv$iv) {
                VirtualFile it = element$iv$iv;
                boolean bl = false;
                if (!(!it.isDirectory())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VirtualFile element$iv$iv;
                element$iv$iv = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new OpenFileDescriptor(this.project, (VirtualFile)it));
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            serializable = (Serializable)thisCollection$iv.toArray(new OpenFileDescriptor[0]);
        } else {
            serializable = REPOSITORY_BROWSER_DATA_KEY.is(dataId) ? (Serializable)this : null;
        }
        return serializable;
    }

    public void dispose() {
        Disposer.dispose((Disposable)((Disposable)this.fileSystemTree));
    }

    public final boolean hasSelectedFiles() {
        boolean bl;
        block1: {
            VirtualFile[] virtualFileArray = this.fileSystemTree.getSelectedFiles();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"fileSystemTree.selectedFiles");
            Object[] $this$any$iv = virtualFileArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl2 = false;
                if (!(it instanceof VcsVirtualFile)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Change> getSelectionAsChanges() {
        void $this$mapTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        VirtualFile[] virtualFileArray = this.fileSystemTree.getSelectedFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"fileSystemTree.selectedFiles");
        Object[] $this$filterIsInstance$iv = virtualFileArray;
        boolean $i$f$filterIsInstance = false;
        Object[] objectArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (VcsVirtualFile element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof VcsVirtualFile)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VcsVirtualFile element$iv$iv;
            element$iv$iv = (VcsVirtualFile)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.createChangeVsLocal((VcsVirtualFile)it));
        }
        return (List)destination$iv$iv;
    }

    private final Change createChangeVsLocal(VcsVirtualFile file) {
        VcsVirtualFileContentRevision repoRevision = new VcsVirtualFileContentRevision(file);
        FilePath localPath = this.getLocalFilePath(file);
        CurrentContentRevision localRevision = new CurrentContentRevision(localPath);
        return new Change(repoRevision, localRevision);
    }

    private final FilePath getLocalFilePath(VcsVirtualFile file) {
        File localFile = new File(this.localRoot.getPath(), file.getPath());
        FilePath filePath = VcsUtil.getFilePath(localFile);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(localFile)");
        return filePath;
    }

    private static final void _init_$lambda$0(RepositoryBrowserPanel this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        VirtualFile[] virtualFileArray = (this$0.fileSystemTree).getSelectedFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"fileSystemTree.selectedFiles");
        for (VirtualFile file : virtualFileArray) {
            FileEditorManager.getInstance((Project)this$0.project).openFile(file, true);
        }
    }

    public static final /* synthetic */ FilePath access$getLocalFilePath(RepositoryBrowserPanel $this, VcsVirtualFile file) {
        return $this.getLocalFilePath(file);
    }

    static {
        DataKey dataKey = DataKey.create((String)"com.intellij.openapi.vcs.impl.RepositoryBrowserPanel");
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"create<RepositoryBrowser\u2026.RepositoryBrowserPanel\")");
        REPOSITORY_BROWSER_DATA_KEY = dataKey;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/vcs/impl/RepositoryBrowserPanel$Companion;", "", "()V", "REPOSITORY_BROWSER_DATA_KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lcom/intellij/openapi/vcs/impl/RepositoryBrowserPanel;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getREPOSITORY_BROWSER_DATA_KEY", "()Lcom/intellij/openapi/actionSystem/DataKey;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<RepositoryBrowserPanel> getREPOSITORY_BROWSER_DATA_KEY() {
            return REPOSITORY_BROWSER_DATA_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

