/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.VcsBaseContentProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsImplUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LineStatusTrackerBaseContentUtil {
    private static final Logger LOG = Logger.getInstance(LineStatusTrackerBaseContentUtil.class);

    @Nullable
    private static VcsBaseContentProvider findProviderFor(@NotNull Project project2, @NotNull VirtualFile file) {
        if (project2 == null) {
            LineStatusTrackerBaseContentUtil.$$$reportNull$$$0(0);
        }
        if (file == null) {
            LineStatusTrackerBaseContentUtil.$$$reportNull$$$0(1);
        }
        return (VcsBaseContentProvider)VcsBaseContentProvider.EP_NAME.findFirstSafe((AreaInstance)project2, it -> it.isSupported(file));
    }

    public static boolean isSupported(@NotNull Project project2, @NotNull VirtualFile file) {
        if (project2 == null) {
            LineStatusTrackerBaseContentUtil.$$$reportNull$$$0(2);
        }
        if (file == null) {
            LineStatusTrackerBaseContentUtil.$$$reportNull$$$0(3);
        }
        return LineStatusTrackerBaseContentUtil.isHandledByVcs(project2, file) || LineStatusTrackerBaseContentUtil.findProviderFor(project2, file) != null;
    }

    public static boolean isTracked(@NotNull Project project2, @NotNull VirtualFile file) {
        FileStatus status;
        if (project2 == null) {
            LineStatusTrackerBaseContentUtil.$$$reportNull$$$0(4);
        }
        if (file == null) {
            LineStatusTrackerBaseContentUtil.$$$reportNull$$$0(5);
        }
        return (status = FileStatusManager.getInstance((Project)project2).getStatus(file)) != FileStatus.ADDED && status != FileStatus.DELETED && status != FileStatus.UNKNOWN && status != FileStatus.IGNORED;
    }

    private static boolean isHandledByVcs(@NotNull Project project2, @NotNull VirtualFile file) {
        if (project2 == null) {
            LineStatusTrackerBaseContentUtil.$$$reportNull$$$0(6);
        }
        if (file == null) {
            LineStatusTrackerBaseContentUtil.$$$reportNull$$$0(7);
        }
        return file.isInLocalFileSystem() && ProjectLevelVcsManager.getInstance(project2).getVcsFor(file) != null;
    }

    @Nullable
    public static VcsBaseContentProvider.BaseContent getBaseRevision(@NotNull Project project2, @NotNull VirtualFile file) {
        if (project2 == null) {
            LineStatusTrackerBaseContentUtil.$$$reportNull$$$0(8);
        }
        if (file == null) {
            LineStatusTrackerBaseContentUtil.$$$reportNull$$$0(9);
        }
        if (!LineStatusTrackerBaseContentUtil.isHandledByVcs(project2, file)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("File is not under VCS: %s", file));
            }
            return LineStatusTrackerBaseContentUtil.createFromProvider(project2, file);
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance(project2);
        Change change = changeListManager.getChange(file);
        if (change != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Content by Change %s: %s", change, file));
            }
            return LineStatusTrackerBaseContentUtil.createFromLocalChange(project2, change);
        }
        FileStatus status = changeListManager.getStatus(file);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("File status is %s: %s", status, file));
        }
        if (status == FileStatus.HIJACKED) {
            return LineStatusTrackerBaseContentUtil.createForHijacked(project2, file);
        }
        if (status == FileStatus.NOT_CHANGED && FileDocumentManager.getInstance().isFileModified(file)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Document is modified: %s", file));
            }
            return LineStatusTrackerBaseContentUtil.createForModifiedDocument(project2, file);
        }
        return null;
    }

    @Nullable
    private static VcsBaseContentProvider.BaseContent createFromProvider(@NotNull Project project2, @NotNull VirtualFile file) {
        VcsBaseContentProvider provider;
        if (project2 == null) {
            LineStatusTrackerBaseContentUtil.$$$reportNull$$$0(10);
        }
        if (file == null) {
            LineStatusTrackerBaseContentUtil.$$$reportNull$$$0(11);
        }
        if ((provider = LineStatusTrackerBaseContentUtil.findProviderFor(project2, file)) == null) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Content by provider %s: %s", provider, file));
        }
        return provider.getBaseRevision(file);
    }

    @Nullable
    private static VcsBaseContentProvider.BaseContent createFromLocalChange(@NotNull Project project2, @NotNull Change change) {
        ContentRevision beforeRevision;
        if (project2 == null) {
            LineStatusTrackerBaseContentUtil.$$$reportNull$$$0(12);
        }
        if (change == null) {
            LineStatusTrackerBaseContentUtil.$$$reportNull$$$0(13);
        }
        if ((beforeRevision = change.getBeforeRevision()) == null) {
            return null;
        }
        return LineStatusTrackerBaseContentUtil.createBaseContent(project2, beforeRevision);
    }

    @Nullable
    private static VcsBaseContentProvider.BaseContent createForHijacked(@NotNull Project project2, @NotNull VirtualFile file) {
        AbstractVcs vcs;
        if (project2 == null) {
            LineStatusTrackerBaseContentUtil.$$$reportNull$$$0(14);
        }
        if (file == null) {
            LineStatusTrackerBaseContentUtil.$$$reportNull$$$0(15);
        }
        if ((vcs = ProjectLevelVcsManager.getInstance(project2).getVcsFor(file)) == null) {
            return null;
        }
        DiffProvider diffProvider = vcs.getDiffProvider();
        if (diffProvider == null) {
            return null;
        }
        VcsRevisionNumber currentRevision = diffProvider.getCurrentRevision(file);
        if (currentRevision == null) {
            return null;
        }
        return new HijackedBaseContent(project2, diffProvider, file, currentRevision);
    }

    @Nullable
    private static VcsBaseContentProvider.BaseContent createForModifiedDocument(@NotNull Project project2, @NotNull VirtualFile file) {
        AbstractVcs vcs;
        if (project2 == null) {
            LineStatusTrackerBaseContentUtil.$$$reportNull$$$0(16);
        }
        if (file == null) {
            LineStatusTrackerBaseContentUtil.$$$reportNull$$$0(17);
        }
        if ((vcs = ProjectLevelVcsManager.getInstance(project2).getVcsFor(file)) == null) {
            return null;
        }
        DiffProvider diffProvider = vcs.getDiffProvider();
        ChangeProvider cp = vcs.getChangeProvider();
        if (diffProvider == null || cp == null) {
            return null;
        }
        if (!cp.isModifiedDocumentTrackingRequired()) {
            return null;
        }
        ContentRevision beforeRevision = diffProvider.createCurrentFileContent(file);
        if (beforeRevision == null) {
            return null;
        }
        return LineStatusTrackerBaseContentUtil.createBaseContent(project2, beforeRevision);
    }

    @NotNull
    public static VcsBaseContentProvider.BaseContent createBaseContent(@NotNull Project project2, @NotNull ContentRevision contentRevision) {
        if (project2 == null) {
            LineStatusTrackerBaseContentUtil.$$$reportNull$$$0(18);
        }
        if (contentRevision == null) {
            LineStatusTrackerBaseContentUtil.$$$reportNull$$$0(19);
        }
        return new BaseContentImpl(project2, contentRevision);
    }

    @Nullable
    private static String loadContentRevision(@Nullable Project project2, @NotNull ContentRevision contentRevision) {
        if (contentRevision == null) {
            LineStatusTrackerBaseContentUtil.$$$reportNull$$$0(20);
        }
        try {
            if (contentRevision instanceof ByteBackedContentRevision) {
                byte[] revisionContent = ((ByteBackedContentRevision)contentRevision).getContentAsBytes();
                FilePath filePath = contentRevision.getFile();
                if (revisionContent != null) {
                    return VcsImplUtil.loadTextFromBytes(project2, revisionContent, filePath);
                }
                return null;
            }
            return contentRevision.getContent();
        }
        catch (VcsException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Throwable)ex);
            }
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRevision";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/impl/LineStatusTrackerBaseContentUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findProviderFor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupported";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isTracked";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isHandledByVcs";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getBaseRevision";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "createFromProvider";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "createFromLocalChange";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "createForHijacked";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "createForModifiedDocument";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "createBaseContent";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "loadContentRevision";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class HijackedBaseContent
    implements VcsBaseContentProvider.BaseContent {
        @Nullable
        private final Project myProject;
        @NotNull
        private final DiffProvider myDiffProvider;
        @NotNull
        private final VirtualFile myFile;
        @NotNull
        private final VcsRevisionNumber myRevision;

        HijackedBaseContent(@Nullable Project project2, @NotNull DiffProvider diffProvider, @NotNull VirtualFile file, @NotNull VcsRevisionNumber revision) {
            if (diffProvider == null) {
                HijackedBaseContent.$$$reportNull$$$0(0);
            }
            if (file == null) {
                HijackedBaseContent.$$$reportNull$$$0(1);
            }
            if (revision == null) {
                HijackedBaseContent.$$$reportNull$$$0(2);
            }
            this.myProject = project2;
            this.myDiffProvider = diffProvider;
            this.myFile = file;
            this.myRevision = revision;
        }

        @Override
        @NotNull
        public VcsRevisionNumber getRevisionNumber() {
            VcsRevisionNumber vcsRevisionNumber = this.myRevision;
            if (vcsRevisionNumber == null) {
                HijackedBaseContent.$$$reportNull$$$0(3);
            }
            return vcsRevisionNumber;
        }

        @Override
        @Nullable
        public String loadContent() {
            ContentRevision contentRevision = this.myDiffProvider.createFileContent(this.myRevision, this.myFile);
            if (contentRevision == null) {
                return null;
            }
            return LineStatusTrackerBaseContentUtil.loadContentRevision(this.myProject, contentRevision);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "diffProvider";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revision";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/impl/LineStatusTrackerBaseContentUtil$HijackedBaseContent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/impl/LineStatusTrackerBaseContentUtil$HijackedBaseContent";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRevisionNumber";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 3 -> new IllegalStateException(string2);
            };
        }
    }

    private static class BaseContentImpl
    implements VcsBaseContentProvider.BaseContent {
        @NotNull
        private final Project myProject;
        @NotNull
        private final ContentRevision myContentRevision;

        BaseContentImpl(@NotNull Project project2, @NotNull ContentRevision contentRevision) {
            if (project2 == null) {
                BaseContentImpl.$$$reportNull$$$0(0);
            }
            if (contentRevision == null) {
                BaseContentImpl.$$$reportNull$$$0(1);
            }
            this.myProject = project2;
            this.myContentRevision = contentRevision;
        }

        @Override
        @NotNull
        public VcsRevisionNumber getRevisionNumber() {
            VcsRevisionNumber vcsRevisionNumber = this.myContentRevision.getRevisionNumber();
            if (vcsRevisionNumber == null) {
                BaseContentImpl.$$$reportNull$$$0(2);
            }
            return vcsRevisionNumber;
        }

        @Override
        @Nullable
        public String loadContent() {
            return LineStatusTrackerBaseContentUtil.loadContentRevision(this.myProject, this.myContentRevision);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentRevision";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/impl/LineStatusTrackerBaseContentUtil$BaseContentImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/impl/LineStatusTrackerBaseContentUtil$BaseContentImpl";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRevisionNumber";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }
}

