/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ToolWindowEmptyStateAction;
import com.intellij.ide.impl.TrustedProjects;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ui.VcsToolWindowEmptyStateKt;
import com.intellij.openapi.vcs.changes.ui.VcsToolWindowFactory;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.util.ui.StatusText;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0014R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/ChangeViewToolWindowFactory;", "Lcom/intellij/openapi/vcs/changes/ui/VcsToolWindowFactory;", "()V", "shouldShowWithoutActiveVcs", "Lcom/intellij/openapi/util/registry/RegistryValue;", "Lorg/jetbrains/annotations/NotNull;", "createToolWindowContent", "", "project", "Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "init", "window", "isAvailable", "", "setEmptyState", "state", "Lcom/intellij/util/ui/StatusText;", "showInStripeWithoutActiveVcs", "updateState", "intellij.platform.vcs.impl"})
final class ChangeViewToolWindowFactory
extends VcsToolWindowFactory {
    @NotNull
    private final RegistryValue shouldShowWithoutActiveVcs;

    public ChangeViewToolWindowFactory() {
        RegistryValue registryValue = Registry.get((String)"vcs.empty.toolwindow.show");
        Intrinsics.checkNotNullExpressionValue((Object)registryValue, (String)"get(\"vcs.empty.toolwindow.show\")");
        this.shouldShowWithoutActiveVcs = registryValue;
    }

    @Override
    public void init(@NotNull ToolWindow window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        super.init(window);
        AnAction anAction = ActionManager.getInstance().getAction("LocalChangesView.GearActions");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        window.setAdditionalGearActions((ActionGroup)anAction);
    }

    @Override
    protected void setEmptyState(@NotNull Project project2, @NotNull StatusText state) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        VcsToolWindowEmptyStateKt.setChangesViewEmptyState(state, project2);
    }

    @Override
    public void createToolWindowContent(@NotNull Project project2, @NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        super.createToolWindowContent(project2, toolWindow);
        if (toolWindow.getContentManager().isEmpty()) {
            ToolWindowEmptyStateAction.rebuildContentUi((ToolWindow)toolWindow);
        }
    }

    @Override
    protected void updateState(@NotNull ToolWindow toolWindow) {
        String string2;
        String string3;
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        super.updateState(toolWindow);
        if (!this.shouldShowWithoutActiveVcs.asBoolean()) {
            Project project2 = toolWindow.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"toolWindow.project");
            toolWindow.setShowStripeButton(this.showInStripeWithoutActiveVcs(project2));
        }
        AbstractVcs[] abstractVcsArray = ProjectLevelVcsManager.getInstance(toolWindow.getProject()).getAllActiveVcss();
        Intrinsics.checkNotNullExpressionValue((Object)abstractVcsArray, (String)"getInstance(toolWindow.project).allActiveVcss");
        AbstractVcs abstractVcs = (AbstractVcs)ArraysKt.singleOrNull((Object[])abstractVcsArray);
        String string4 = string3 = abstractVcs != null ? abstractVcs.getDisplayName() : null;
        if (string3 == null) {
            String string5 = IdeBundle.message((String)"toolwindow.stripe.Version_Control", (Object[])new Object[0]);
            string2 = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(\"toolwindow.stripe.Version_Control\")");
        } else {
            string2 = string3;
        }
        toolWindow.setStripeTitle(string2);
    }

    @Override
    public boolean isAvailable(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return TrustedProjects.isTrusted((Project)project2);
    }

    private final boolean showInStripeWithoutActiveVcs(Project project2) {
        return this.shouldShowWithoutActiveVcs.asBoolean() || ProjectLevelVcsManager.getInstance(project2).hasAnyMappings();
    }
}

