/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ImportIntoShelfAction
extends DumbAwareAction {
    public ImportIntoShelfAction() {
        super(VcsBundle.messagePointer("action.ImportIntoShelfAction.text", new Object[0]), VcsBundle.messagePointer("action.ImportIntoShelfAction.description", new Object[0]), null);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ImportIntoShelfAction.$$$reportNull$$$0(0);
        }
        Project project2 = e.getProject();
        e.getPresentation().setEnabled(project2 != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ImportIntoShelfAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            ImportIntoShelfAction.$$$reportNull$$$0(2);
        }
        if ((project2 = e.getProject()) == null) {
            return;
        }
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, true, false, false, false, true);
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)project2, null, files2 -> {
            String message2;
            int toImport;
            ShelveChangesManager shelveChangesManager;
            ArrayList patchTypeFiles;
            ProgressManager pm = ProgressManager.getInstance();
            boolean filesFound = (Boolean)pm.runProcessWithProgressSynchronously(() -> ImportIntoShelfAction.lambda$actionPerformed$0(patchTypeFiles = new ArrayList(), shelveChangesManager = ShelveChangesManager.getInstance(project2), files2), VcsBundle.message("looking.for.patch.files", new Object[0]), true, project2);
            if (!filesFound || patchTypeFiles.isEmpty()) {
                return;
            }
            if (!patchTypeFiles.equals(files2) && 1 == (toImport = Messages.showYesNoDialog((Project)project2, (String)(message2 = patchTypeFiles.size() == 1 ? VcsBundle.message("shelve.import.one.patch.file.prompt", ((VirtualFile)patchTypeFiles.get(0)).getPath()) : VcsBundle.message("shelve.import.patches.prompt", patchTypeFiles.size())), (String)VcsBundle.message("import.patches", new Object[0]), (Icon)Messages.getQuestionIcon()))) {
                return;
            }
            pm.runProcessWithProgressSynchronously(() -> {
                ArrayList exceptions2 = new ArrayList();
                List<ShelvedChangeList> lists = shelveChangesManager.importChangeLists(patchTypeFiles, e1 -> exceptions2.add(e1));
                if (!lists.isEmpty()) {
                    ShelvedChangesViewManager.getInstance(project2).activateView(lists.get(lists.size() - 1));
                }
                if (!exceptions2.isEmpty()) {
                    AbstractVcsHelper.getInstance(project2).showErrors(exceptions2, VcsBundle.message("patch.import.to.shelf.tab", new Object[0]));
                }
                if (lists.isEmpty() && exceptions2.isEmpty()) {
                    VcsBalloonProblemNotifier.showOverChangesView(project2, VcsBundle.message("patch.import.no.patches.found.warning", new Object[0]), MessageType.WARNING, new NamedRunnable[0]);
                }
            }, VcsBundle.message("import.patches.into.shelf", new Object[0]), true, project2);
        });
    }

    private static /* synthetic */ Boolean lambda$actionPerformed$0(List patchTypeFiles, ShelveChangesManager shelveChangesManager, List files2) throws RuntimeException {
        return patchTypeFiles.addAll(shelveChangesManager.gatherPatchFiles(files2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ImportIntoShelfAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ImportIntoShelfAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }
}

