/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0004J\u000e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0010J\u0006\u0010\u0019\u001a\u00020\u001aR\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/openapi/vcs/changes/DirtBuilder;", "", "()V", "<set-?>", "", "isEverythingDirty", "()Z", "scopesByVcs", "", "Lcom/intellij/openapi/vcs/AbstractVcs;", "Lcom/intellij/openapi/vcs/changes/VcsDirtyScopeImpl;", "addDirtyFiles", "vcsRoot", "Lcom/intellij/openapi/vcs/VcsRoot;", "files", "", "Lcom/intellij/openapi/vcs/FilePath;", "dirs", "buildScopes", "", "project", "Lcom/intellij/openapi/project/Project;", "isEmpty", "isFileDirty", "filePath", "markEverythingDirty", "", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nDirtBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirtBuilder.kt\ncom/intellij/openapi/vcs/changes/DirtBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n1549#2:65\n1620#2,3:66\n1747#2,3:69\n*S KotlinDebug\n*F\n+ 1 DirtBuilder.kt\ncom/intellij/openapi/vcs/changes/DirtBuilder\n*L\n60#1:65\n60#1:66,3\n63#1:69,3\n*E\n"})
public final class DirtBuilder {
    @NotNull
    private final Map<AbstractVcs, VcsDirtyScopeImpl> scopesByVcs = new LinkedHashMap();
    private boolean isEverythingDirty;

    public final boolean isEverythingDirty() {
        return this.isEverythingDirty;
    }

    public final boolean isEmpty() {
        return !this.isEverythingDirty && this.scopesByVcs.isEmpty();
    }

    public final void markEverythingDirty() {
        this.isEverythingDirty = true;
        this.scopesByVcs.clear();
    }

    public final boolean addDirtyFiles(@NotNull VcsRoot vcsRoot, @NotNull Collection<? extends FilePath> files2, @NotNull Collection<? extends FilePath> dirs) {
        Intrinsics.checkNotNullParameter((Object)vcsRoot, (String)"vcsRoot");
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Intrinsics.checkNotNullParameter(dirs, (String)"dirs");
        if (this.isEverythingDirty) {
            return true;
        }
        AbstractVcs vcs = vcsRoot.getVcs();
        VirtualFile virtualFile = vcsRoot.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"vcsRoot.path");
        VirtualFile root = virtualFile;
        if (vcs != null) {
            VcsDirtyScopeImpl vcsDirtyScopeImpl = this.scopesByVcs.computeIfAbsent(vcs, arg_0 -> DirtBuilder.addDirtyFiles$lambda$0((Function1)new Function1<AbstractVcs, VcsDirtyScopeImpl>(this){
                final /* synthetic */ DirtBuilder this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final VcsDirtyScopeImpl invoke(@NotNull AbstractVcs it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return new VcsDirtyScopeImpl(it, this.this$0.isEverythingDirty());
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)vcsDirtyScopeImpl, (String)"fun addDirtyFiles(vcsRoo\u2026pesByVcs.isNotEmpty()\n  }");
            VcsDirtyScopeImpl scope2 = vcsDirtyScopeImpl;
            for (FilePath filePath : files2) {
                scope2.addDirtyPathFast(root, filePath, false);
            }
            for (FilePath filePath : dirs) {
                scope2.addDirtyPathFast(root, filePath, true);
            }
        }
        return !this.scopesByVcs.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<VcsDirtyScopeImpl> buildScopes(@NotNull Project project2) {
        void $this$mapTo$iv$iv;
        VcsDirtyScopeImpl scope2;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Collection<VcsDirtyScopeImpl> scopes = null;
        if (this.isEverythingDirty) {
            Map allScopes = new LinkedHashMap();
            VcsRoot[] vcsRootArray = ProjectLevelVcsManager.getInstance(project2).getAllVcsRoots();
            Intrinsics.checkNotNullExpressionValue((Object)vcsRootArray, (String)"getInstance(project).allVcsRoots");
            for (VcsRoot root : vcsRootArray) {
                VirtualFile path2;
                AbstractVcs vcs = root.getVcs();
                Intrinsics.checkNotNullExpressionValue((Object)root.getPath(), (String)"root.path");
                if (vcs == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)allScopes.computeIfAbsent(vcs, arg_0 -> DirtBuilder.buildScopes$lambda$1((Function1)new Function1<AbstractVcs, VcsDirtyScopeImpl>(this){
                    final /* synthetic */ DirtBuilder this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final VcsDirtyScopeImpl invoke(@NotNull AbstractVcs it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return new VcsDirtyScopeImpl(it, this.this$0.isEverythingDirty());
                    }
                }, arg_0)), (String)"fun buildScopes(project:\u2026pes.map { it.pack() }\n  }");
                scope2.addDirtyPathFast(path2, VcsUtil.getFilePath(path2), true);
            }
            scopes = allScopes.values();
        } else {
            scopes = this.scopesByVcs.values();
        }
        Iterable $this$map$iv = scopes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            scope2 = (VcsDirtyScopeImpl)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.pack());
        }
        return (List)destination$iv$iv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isFileDirty(@NotNull FilePath filePath) {
        VcsDirtyScopeImpl it;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        if (this.isEverythingDirty) return true;
        Iterable $this$any$iv = this.scopesByVcs.values();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (VcsDirtyScopeImpl)element$iv;
            boolean bl = false;
        } while (!it.belongsTo(filePath));
        return true;
    }

    private static final VcsDirtyScopeImpl addDirtyFiles$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (VcsDirtyScopeImpl)$tmp0.invoke(p0);
    }

    private static final VcsDirtyScopeImpl buildScopes$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (VcsDirtyScopeImpl)$tmp0.invoke(p0);
    }
}

