/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilesProcessorWithNotificationImpl;
import com.intellij.openapi.vcs.ProjectConfigurationFilesProcessorImplKt;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.VcsIgnoreManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.vcsUtil.VcsImplUtil;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0018\u0010\t\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0004\u0012\u00020\r0\n\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010%\u001a\u00020\r2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u001c\u0010'\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020\f0)2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\f0)J\u0006\u0010*\u001a\u00020\rJ\u001a\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010\f2\u0006\u0010.\u001a\u00020\fH\u0002J\b\u0010/\u001a\u00020\bH\u0016J\b\u00100\u001a\u00020\bH\u0016J\u0010\u00101\u001a\u00020\r2\u0006\u00102\u001a\u00020,H\u0016J\u000e\u00103\u001a\u0004\u0018\u00010\f*\u00020\u0004H\u0002R \u0010\t\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0016\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0011R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0011R\u0014\u0010\u001d\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0011R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0011R\u0016\u0010!\u001a\n \u0016*\u0004\u0018\u00010\"0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\u00020\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0011\u00a8\u00064"}, d2={"Lcom/intellij/openapi/vcs/ProjectConfigurationFilesProcessorImpl;", "Lcom/intellij/openapi/vcs/FilesProcessorWithNotificationImpl;", "Lcom/intellij/openapi/vcs/changes/ChangeListListener;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "vcsName", "", "addChosenFiles", "Lkotlin/Function1;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "askedBeforeProperty", "getAskedBeforeProperty", "()Ljava/lang/String;", "doForCurrentProjectProperty", "getDoForCurrentProjectProperty", "fileSystem", "Lcom/intellij/openapi/vfs/LocalFileSystem;", "kotlin.jvm.PlatformType", "forCurrentProjectActionText", "getForCurrentProjectActionText", "foundProjectConfigurationFiles", "Ljava/util/concurrent/atomic/AtomicBoolean;", "muteActionText", "getMuteActionText", "notificationDisplayId", "getNotificationDisplayId", "showActionText", "getShowActionText", "vcsIgnoreManager", "Lcom/intellij/openapi/vcs/changes/VcsIgnoreManager;", "viewFilesDialogTitle", "getViewFilesDialogTitle", "doActionOnChosenFiles", "files", "doFilterFiles", "filterNotProjectConfigurationFiles", "", "install", "isProjectConfigurationFile", "", "configDir", "file", "notificationMessage", "notificationTitle", "unchangedFileStatusChanged", "upToDate", "getProjectConfigDir", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nProjectConfigurationFilesProcessorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectConfigurationFilesProcessorImpl.kt\ncom/intellij/openapi/vcs/ProjectConfigurationFilesProcessorImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,128:1\n1#2:129\n*E\n"})
public final class ProjectConfigurationFilesProcessorImpl
extends FilesProcessorWithNotificationImpl
implements ChangeListListener {
    @NotNull
    private final Disposable parentDisposable;
    @NotNull
    private final String vcsName;
    @NotNull
    private final Function1<Collection<? extends VirtualFile>, Unit> addChosenFiles;
    @NotNull
    private final AtomicBoolean foundProjectConfigurationFiles;
    private final LocalFileSystem fileSystem;
    private final VcsIgnoreManager vcsIgnoreManager;
    @NotNull
    private final String notificationDisplayId;
    @NotNull
    private final String askedBeforeProperty;
    @NotNull
    private final String doForCurrentProjectProperty;
    @NotNull
    private final String showActionText;
    @NotNull
    private final String forCurrentProjectActionText;
    @NotNull
    private final String muteActionText;
    @NotNull
    private final String viewFilesDialogTitle;

    public ProjectConfigurationFilesProcessorImpl(@NotNull Project project2, @NotNull Disposable parentDisposable, @NotNull String vcsName, @NotNull Function1<? super Collection<? extends VirtualFile>, Unit> addChosenFiles) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)vcsName, (String)"vcsName");
        Intrinsics.checkNotNullParameter(addChosenFiles, (String)"addChosenFiles");
        super(project2, parentDisposable);
        this.parentDisposable = parentDisposable;
        this.vcsName = vcsName;
        this.addChosenFiles = addChosenFiles;
        this.foundProjectConfigurationFiles = new AtomicBoolean();
        this.fileSystem = LocalFileSystem.getInstance();
        this.vcsIgnoreManager = VcsIgnoreManager.getInstance(project2);
        this.notificationDisplayId = "project.configuration.files.added.notification";
        this.askedBeforeProperty = "ASKED_SHARE_PROJECT_CONFIGURATION_FILES";
        this.doForCurrentProjectProperty = "SHARE_PROJECT_CONFIGURATION_FILES";
        String string2 = VcsBundle.message("project.configuration.files.add.notification.action.view", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"project.configu\u2026otification.action.view\")");
        this.showActionText = string2;
        String string3 = VcsBundle.message("project.configuration.files.add.notification.action.add", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"project.configu\u2026notification.action.add\")");
        this.forCurrentProjectActionText = string3;
        String string4 = VcsBundle.message("project.configuration.files.add.notification.action.mute", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"project.configu\u2026otification.action.mute\")");
        this.muteActionText = string4;
        Object[] objectArray = new Object[]{this.vcsName};
        String string5 = VcsBundle.message("project.configuration.files.view.dialog.title", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(\"project.configu\u2026w.dialog.title\", vcsName)");
        this.viewFilesDialogTitle = string5;
    }

    public final void install() {
        ActionsKt.runReadAction((Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ProjectConfigurationFilesProcessorImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                if (!this.this$0.getProject().isDisposed()) {
                    MessageBusConnection messageBusConnection = this.this$0.getProject().getMessageBus().connect(ProjectConfigurationFilesProcessorImpl.access$getParentDisposable$p(this.this$0));
                    Topic<ChangeListListener> topic = ChangeListListener.TOPIC;
                    Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
                    messageBusConnection.subscribe(topic, (Object)this.this$0);
                }
            }
        }));
    }

    @NotNull
    public final List<VirtualFile> filterNotProjectConfigurationFiles(@NotNull List<? extends VirtualFile> files2) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Collection<VirtualFile> projectConfigurationFiles = this.doFilterFiles((Collection<? extends VirtualFile>)files2);
        if (!projectConfigurationFiles.isEmpty() && this.foundProjectConfigurationFiles.compareAndSet(false, true)) {
            Object[] objectArray = new Object[]{projectConfigurationFiles};
            ProjectConfigurationFilesProcessorImplKt.access$getLOG$p().debug("Found new project configuration files ", objectArray);
        }
        return CollectionsKt.minus((Iterable)files2, (Iterable)projectConfigurationFiles);
    }

    @Override
    public void unchangedFileStatusChanged(boolean upToDate) {
        if (!upToDate) {
            return;
        }
        if (this.foundProjectConfigurationFiles.compareAndSet(true, false)) {
            List<VirtualFile> list = ChangeListManagerImpl.getInstanceImpl(this.getProject()).getUnversionedFiles();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getInstanceImpl(project).unversionedFiles");
            Collection<VirtualFile> unversionedProjectConfigurationFiles = this.doFilterFiles((Collection<? extends VirtualFile>)list);
            if (!unversionedProjectConfigurationFiles.isEmpty()) {
                this.setForCurrentProject(VcsImplUtil.isProjectSharedInVcs(this.getProject()));
                this.processFiles(CollectionsKt.toList((Iterable)unversionedProjectConfigurationFiles));
            }
        }
    }

    @Override
    @NotNull
    public Collection<VirtualFile> doFilterFiles(@NotNull Collection<? extends VirtualFile> files2) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        VirtualFile projectConfigDir = this.getProjectConfigDir(this.getProject());
        Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)files2), (Function1)((Function1)new Function1<VirtualFile, Boolean>(this, projectConfigDir){
            final /* synthetic */ ProjectConfigurationFilesProcessorImpl this$0;
            final /* synthetic */ VirtualFile $projectConfigDir;
            {
                this.this$0 = $receiver;
                this.$projectConfigDir = $projectConfigDir;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull VirtualFile it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return ProjectConfigurationFilesProcessorImplKt.access$getConfigurationFilesExtensionsOutsideStoreDirectory$p().contains(it.getExtension()) || ProjectConfigurationFilesProcessorImpl.access$isProjectConfigurationFile(this.this$0, this.$projectConfigDir, it);
            }
        }));
        VcsIgnoreManager vcsIgnoreManager = this.vcsIgnoreManager;
        Intrinsics.checkNotNullExpressionValue((Object)vcsIgnoreManager, (String)"vcsIgnoreManager");
        return SequencesKt.toSet((Sequence)SequencesKt.filterNot((Sequence)sequence, (Function1)((Function1)new Function1<VirtualFile, Boolean>((Object)vcsIgnoreManager){

            @NotNull
            public final Boolean invoke(@NotNull VirtualFile p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((VcsIgnoreManager)this.receiver).isPotentiallyIgnoredFile(p0);
            }
        })));
    }

    @Override
    public void doActionOnChosenFiles(@NotNull Collection<? extends VirtualFile> files2) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        this.addChosenFiles.invoke(files2);
    }

    @Override
    @NotNull
    public String getNotificationDisplayId() {
        return this.notificationDisplayId;
    }

    @Override
    @NotNull
    public String getAskedBeforeProperty() {
        return this.askedBeforeProperty;
    }

    @Override
    @NotNull
    public String getDoForCurrentProjectProperty() {
        return this.doForCurrentProjectProperty;
    }

    @Override
    @NotNull
    public String notificationTitle() {
        return "";
    }

    @Override
    @NotNull
    public String notificationMessage() {
        Object[] objectArray = new Object[]{this.vcsName};
        String string2 = VcsBundle.message("project.configuration.files.add.notification.message", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"project.configu\u2026cation.message\", vcsName)");
        return string2;
    }

    @Override
    @NotNull
    public String getShowActionText() {
        return this.showActionText;
    }

    @Override
    @NotNull
    public String getForCurrentProjectActionText() {
        return this.forCurrentProjectActionText;
    }

    @Override
    @NotNull
    public String getMuteActionText() {
        return this.muteActionText;
    }

    @Override
    @NotNull
    protected String getViewFilesDialogTitle() {
        return this.viewFilesDialogTitle;
    }

    private final boolean isProjectConfigurationFile(VirtualFile configDir, VirtualFile file) {
        return configDir != null && VfsUtilCore.isAncestor((VirtualFile)configDir, (VirtualFile)file, (boolean)true);
    }

    private final VirtualFile getProjectConfigDir(Project $this$getProjectConfigDir) {
        VirtualFile projectConfigDir;
        if (!ProjectKt.isDirectoryBased((Project)$this$getProjectConfigDir) || $this$getProjectConfigDir.isDefault()) {
            return null;
        }
        Path path2 = ProjectKt.getStateStore((Project)$this$getProjectConfigDir).getDirectoryStorePath();
        if (path2 != null) {
            Path path3 = path2;
            LocalFileSystem localFileSystem = this.fileSystem;
            Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"fileSystem");
            LocalFileSystem localFileSystem2 = localFileSystem;
            Path p0 = path3;
            boolean bl = false;
            v2 = localFileSystem2.findFileByNioFile(p0);
        } else {
            v2 = projectConfigDir = null;
        }
        if (projectConfigDir == null) {
            ProjectConfigurationFilesProcessorImplKt.access$getLOG$p().warn("Cannot find project config directory for non-default and non-directory based project " + $this$getProjectConfigDir.getName());
        }
        return projectConfigDir;
    }

    public static final /* synthetic */ Disposable access$getParentDisposable$p(ProjectConfigurationFilesProcessorImpl $this) {
        return $this.parentDisposable;
    }

    public static final /* synthetic */ boolean access$isProjectConfigurationFile(ProjectConfigurationFilesProcessorImpl $this, VirtualFile configDir, VirtualFile file) {
        return $this.isProjectConfigurationFile(configDir, file);
    }
}

