/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.documentation.mdn;

import com.intellij.documentation.mdn.MdnApiStatus;
import com.intellij.documentation.mdn.MdnDocumentation;
import com.intellij.documentation.mdn.MdnDocumentationKt;
import com.intellij.documentation.mdn.MdnJavaScriptRuntime;
import com.intellij.documentation.mdn.MdnRawSymbolDocumentation;
import com.intellij.documentation.mdn.MdnSymbolDocumentation;
import com.intellij.documentation.mdn.MdnSymbolDocumentationAdapter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.webSymbols.WebSymbolApiStatus;
import com.intellij.xml.psi.XmlPsiBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J%\u0010\u0019\u001a\u00070\u0003\u00a2\u0006\u0002\b\u001c2\u0006\u0010\u001a\u001a\u00020\u001b2\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001eH\u0016J\f\u0010 \u001a\u00020\u0003*\u00020\u0003H\u0002R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR \u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000f\u00a8\u0006!"}, d2={"Lcom/intellij/documentation/mdn/MdnSymbolDocumentationAdapter;", "Lcom/intellij/documentation/mdn/MdnSymbolDocumentation;", "name", "", "source", "Lcom/intellij/documentation/mdn/MdnDocumentation;", "doc", "Lcom/intellij/documentation/mdn/MdnRawSymbolDocumentation;", "(Ljava/lang/String;Lcom/intellij/documentation/mdn/MdnDocumentation;Lcom/intellij/documentation/mdn/MdnRawSymbolDocumentation;)V", "apiStatus", "Lcom/intellij/webSymbols/WebSymbolApiStatus;", "getApiStatus", "()Lcom/intellij/webSymbols/WebSymbolApiStatus;", "description", "getDescription", "()Ljava/lang/String;", "footnote", "getFootnote", "getName", "sections", "", "getSections", "()Ljava/util/Map;", "url", "getUrl", "getDocumentation", "withDefinition", "", "Lcom/intellij/openapi/util/NlsSafe;", "additionalSectionsContent", "Ljava/util/function/Consumer;", "Ljava/lang/StringBuilder;", "fixUrls", "intellij.xml.psi.impl"})
@SourceDebugExtension(value={"SMAP\nMdnDocumentation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MdnDocumentation.kt\ncom/intellij/documentation/mdn/MdnSymbolDocumentationAdapter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,638:1\n1#2:639\n1855#3,2:640\n125#4:642\n152#4,3:643\n*S KotlinDebug\n*F\n+ 1 MdnDocumentation.kt\ncom/intellij/documentation/mdn/MdnSymbolDocumentationAdapter\n*L\n216#1:640,2\n234#1:642\n234#1:643,3\n*E\n"})
public final class MdnSymbolDocumentationAdapter
implements MdnSymbolDocumentation {
    @NotNull
    private final String name;
    @NotNull
    private final MdnDocumentation source;
    @NotNull
    private final MdnRawSymbolDocumentation doc;

    public MdnSymbolDocumentationAdapter(@NotNull String name, @NotNull MdnDocumentation source2, @NotNull MdnRawSymbolDocumentation doc) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        this.name = name;
        this.source = source2;
        this.doc = doc;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getUrl() {
        String string2;
        String string3 = this.doc.getUrl();
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            string2 = MdnDocumentationKt.access$fixMdnUrls(it, this.source.getLang());
        } else {
            string2 = null;
        }
        return string2;
    }

    @Override
    @NotNull
    public WebSymbolApiStatus getApiStatus() {
        Set<MdnApiStatus> set;
        block4: {
            block3: {
                set = this.doc.getStatus();
                if (set == null) break block3;
                Set<MdnApiStatus> it = set;
                boolean bl = false;
                WebSymbolApiStatus webSymbolApiStatus = it.contains((Object)MdnApiStatus.Obsolete) ? (WebSymbolApiStatus)WebSymbolApiStatus.Obsolete : (it.contains((Object)MdnApiStatus.Deprecated) ? (WebSymbolApiStatus)WebSymbolApiStatus.Deprecated : (it.contains((Object)MdnApiStatus.Experimental) ? (WebSymbolApiStatus)WebSymbolApiStatus.Experimental : null));
                set = webSymbolApiStatus;
                if (webSymbolApiStatus != null) break block4;
            }
            set = WebSymbolApiStatus.Stable;
        }
        return set;
    }

    @Override
    @NotNull
    public String getDescription() {
        String string2 = this.doc.getDoc();
        if (string2 == null) {
            string2 = "";
        }
        String string3 = StringUtil.capitalize((String)string2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"capitalize(doc.doc ?: \"\")");
        return this.fixUrls(string3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, String> getSections() {
        void $this$mapTo$iv$iv;
        Sequence $i$f$forEach2;
        Object element$iv;
        Object object;
        Iterable<MdnApiStatus> $this$forEach$iv;
        Map result2 = MapsKt.toMutableMap(this.doc.getSections());
        if (this.doc.getCompatibility() != null) {
            Map<String, Map<MdnJavaScriptRuntime, String>> map2 = this.doc.getCompatibility();
            Intrinsics.checkNotNull(map2);
            $this$forEach$iv = map2.entrySet();
            boolean $i$f$forEach2 = false;
            object = $this$forEach$iv.iterator();
            while (object.hasNext()) {
                Object object2;
                String string2;
                Object object3;
                element$iv = object.next();
                Map.Entry entry2 = (Map.Entry)element$iv;
                boolean bl = false;
                String id = (String)entry2.getKey();
                Map map3 = (Map)entry2.getValue();
                String actualId = Intrinsics.areEqual((Object)id, (Object)"default_context") ? "browser_compatibility" : id;
                String bundleKey = "mdn.documentation.section.compat." + actualId;
                if (StringsKt.startsWith$default((String)actualId, (String)"support_of_", (boolean)false, (int)2, null) && !XmlPsiBundle.hasKey(bundleKey)) {
                    object3 = new Object[1];
                    Intrinsics.checkNotNullExpressionValue((Object)actualId.substring(11), (String)"this as java.lang.String).substring(startIndex)");
                    String string3 = XmlPsiBundle.message("mdn.documentation.section.compat.support_of", object3);
                    string2 = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"{\n            XmlPsiBund\u2026of_\".length))\n          }");
                } else {
                    String string4 = XmlPsiBundle.message(bundleKey, new Object[0]);
                    string2 = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"{\n            XmlPsiBund\u2026ge(bundleKey)\n          }");
                }
                String sectionName = string2;
                Map map4 = result2;
                object3 = CollectionsKt.joinToString$default((Iterable)map3.entrySet(), (CharSequence)", ", null, null, (int)0, null, (Function1)sections.1.1.INSTANCE, (int)30, null);
                if (StringsKt.isBlank((CharSequence)object3)) {
                    boolean bl2 = false;
                    String string5 = XmlPsiBundle.message("mdn.documentation.section.compat.supported_by.none", new Object[0]);
                    object2 = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(\"mdn.documentati\u2026ompat.supported_by.none\")");
                } else {
                    object2 = object3;
                }
                object3 = object2;
                map4.put(sectionName, object3);
            }
        }
        if (($this$forEach$iv = this.doc.getStatus()) != null && ($i$f$forEach2 = CollectionsKt.asSequence((Iterable)$this$forEach$iv)) != null && (object = SequencesKt.filter((Sequence)$i$f$forEach2, (Function1)sections.2.INSTANCE)) != null && (element$iv = SequencesKt.map((Sequence)object, (Function1)sections.3.INSTANCE)) != null) {
            MapsKt.toMap(element$iv, (Map)result2);
        }
        Map $this$map$iv = result2;
        boolean $i$f$map = false;
        object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry3 = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String key2 = (String)entry3.getKey();
            String value2 = (String)entry3.getValue();
            collection.add(new Pair((Object)this.fixUrls(key2), (Object)this.fixUrls(value2)));
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    @Override
    @NotNull
    public String getFootnote() {
        return this.fixUrls("By <a href='" + this.doc.getUrl() + "/contributors.txt'>Mozilla Contributors</a>, <a href='https://creativecommons.org/licenses/by-sa/2.5/'>CC BY-SA 2.5</a>");
    }

    @Override
    @NotNull
    public String getDocumentation(boolean withDefinition) {
        return this.getDocumentation(withDefinition, null);
    }

    @Override
    @NotNull
    public String getDocumentation(boolean withDefinition, @Nullable Consumer<StringBuilder> additionalSectionsContent) {
        return MdnDocumentationKt.access$buildDoc(this, withDefinition, additionalSectionsContent);
    }

    private final String fixUrls(String $this$fixUrls) {
        CharSequence charSequence = $this$fixUrls;
        Regex regex = new Regex("<a[ \n\t]+href=[ \t]*['\"]#([^'\"]*)['\"]");
        String string2 = this.doc.getUrl();
        if (string2 == null) {
            string2 = "";
        }
        String string3 = "<a href=\"" + Regex.Companion.escapeReplacement(string2) + "#$1\"";
        return MdnDocumentationKt.access$fixMdnUrls(regex.replace(charSequence, string3), this.source.getLang());
    }
}

