/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.AbstractCoverageProjectViewNodeDecorator;
import com.intellij.coverage.CoverageAnnotator;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;

final class CoverageProjectViewDirectoryNodeDecorator
extends AbstractCoverageProjectViewNodeDecorator {
    CoverageProjectViewDirectoryNodeDecorator() {
    }

    public void decorate(ProjectViewNode node, PresentationData data2) {
        CoverageAnnotator coverageAnnotator;
        Project project2 = node.getProject();
        if (project2 == null) {
            return;
        }
        CoverageDataManager manager = this.getCoverageDataManager(project2);
        if (manager == null) {
            return;
        }
        CoverageSuitesBundle currentSuite = manager.getCurrentSuitesBundle();
        CoverageAnnotator coverageAnnotator2 = coverageAnnotator = currentSuite == null ? null : currentSuite.getAnnotator(project2);
        if (coverageAnnotator == null) {
            return;
        }
        Object value2 = node.getValue();
        PsiElement element = null;
        if (value2 instanceof PsiElement) {
            element = (PsiElement)value2;
        } else if (value2 instanceof SmartPsiElementPointer) {
            element = ((SmartPsiElementPointer)value2).getElement();
        }
        String informationString = null;
        if (element instanceof PsiDirectory) {
            informationString = coverageAnnotator.getDirCoverageInformationString((PsiDirectory)element, currentSuite, manager);
        } else if (element instanceof PsiFile) {
            informationString = coverageAnnotator.getFileCoverageInformationString((PsiFile)element, currentSuite, manager);
        }
        if (informationString != null) {
            data2.setLocationString(informationString);
        }
    }
}

