/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.auth.services;

import com.intellij.collaboration.auth.credentials.Credentials;
import com.intellij.collaboration.auth.services.OAuthCredentialsAcquirer;
import com.intellij.collaboration.auth.services.OAuthRequest;
import com.intellij.collaboration.auth.services.OAuthService;
import com.intellij.ide.BrowserUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rH\u0016J*\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00140\u0013H\u0016J\u0016\u0010\u0015\u001a\u00020\u00162\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rH\u0014J \u0010\u0017\u001a\u0004\u0018\u00010\u0011*\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00140\u0013H\u0002J\u001a\u0010\u0018\u001a\u00020\u0016*\b\u0012\u0004\u0012\u00028\u00000\u00072\u0006\u0010\u0019\u001a\u00020\u0011H\u0002R\"\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00070\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Lcom/intellij/collaboration/auth/services/OAuthServiceBase;", "T", "Lcom/intellij/collaboration/auth/credentials/Credentials;", "Lcom/intellij/collaboration/auth/services/OAuthService;", "()V", "currentRequest", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/collaboration/auth/services/OAuthServiceBase$OAuthRequestWithResult;", "getCurrentRequest", "()Ljava/util/concurrent/atomic/AtomicReference;", "authorize", "Ljava/util/concurrent/CompletableFuture;", "request", "Lcom/intellij/collaboration/auth/services/OAuthRequest;", "handleServerCallback", "", "path", "", "parameters", "", "", "startAuthorization", "", "getAuthorizationCode", "processCode", "code", "OAuthRequestWithResult", "intellij.platform.collaborationTools.auth"})
public abstract class OAuthServiceBase<T extends Credentials>
implements OAuthService<T> {
    @NotNull
    private final AtomicReference<OAuthRequestWithResult<T>> currentRequest = new AtomicReference();

    @NotNull
    protected final AtomicReference<OAuthRequestWithResult<T>> getCurrentRequest() {
        return this.currentRequest;
    }

    @Override
    @NotNull
    public CompletableFuture<T> authorize(@NotNull OAuthRequest<T> request) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        if (!this.currentRequest.compareAndSet(null, new OAuthRequestWithResult<T>(request, new CompletableFuture()))) {
            OAuthRequestWithResult<T> oAuthRequestWithResult = this.currentRequest.get();
            Intrinsics.checkNotNull(oAuthRequestWithResult);
            return oAuthRequestWithResult.getResult();
        }
        OAuthRequestWithResult<T> oAuthRequestWithResult = this.currentRequest.get();
        Intrinsics.checkNotNull(oAuthRequestWithResult);
        CompletableFuture<T> result2 = oAuthRequestWithResult.getResult();
        result2.whenComplete((arg_0, arg_1) -> OAuthServiceBase.authorize$lambda$0((Function2)new Function2<T, Throwable, Unit>(this){
            final /* synthetic */ OAuthServiceBase<T> this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(T t, Throwable throwable) {
                this.this$0.getCurrentRequest().set(null);
            }
        }, arg_0, arg_1));
        this.startAuthorization(request);
        return result2;
    }

    private final String getAuthorizationCode(Map<String, ? extends List<String>> $this$getAuthorizationCode) {
        List<String> list = $this$getAuthorizationCode.get("code");
        return list != null ? (String)CollectionsKt.firstOrNull(list) : null;
    }

    @Override
    public boolean handleServerCallback(@NotNull String path2, @NotNull Map<String, ? extends List<String>> parameters) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        OAuthRequestWithResult<T> oAuthRequestWithResult = this.currentRequest.get();
        if (oAuthRequestWithResult == null) {
            return false;
        }
        OAuthRequestWithResult<T> request = oAuthRequestWithResult;
        if (!Intrinsics.areEqual((Object)path2, (Object)request.getRequest().getAuthorizationCodeUrl().getPath())) {
            return false;
        }
        String code = this.getAuthorizationCode(parameters);
        if (code == null) {
            List<String> list = parameters.get("error");
            String error = list != null ? (String)CollectionsKt.firstOrNull(list) : null;
            List<String> list2 = parameters.get("error_description");
            String error_description = list2 != null ? (String)CollectionsKt.firstOrNull(list2) : null;
            CompletableFuture<T> completableFuture = request.getResult();
            String string2 = error_description;
            if (string2 == null && (string2 = error) == null) {
                string2 = "Unknown error";
            }
            completableFuture.completeExceptionally(new RuntimeException(string2));
            return false;
        }
        this.processCode(request, code);
        CompletableFuture<T> result2 = request.getResult();
        return result2.isDone() && !result2.isCancelled() && !result2.isCompletedExceptionally();
    }

    protected void startAuthorization(@NotNull OAuthRequest<T> request) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        String string2 = request.getAuthUrlWithParameters().toExternalForm();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"request.authUrlWithParameters.toExternalForm()");
        String authUrl = string2;
        BrowserUtil.browse((String)authUrl);
    }

    private final void processCode(OAuthRequestWithResult<T> $this$processCode, String code) {
        try {
            OAuthCredentialsAcquirer.AcquireCredentialsResult<T> acquireResult = $this$processCode.getRequest().getCredentialsAcquirer().acquireCredentials(code);
            if (acquireResult instanceof OAuthCredentialsAcquirer.AcquireCredentialsResult.Success) {
                $this$processCode.getResult().complete(((OAuthCredentialsAcquirer.AcquireCredentialsResult.Success)acquireResult).getCredentials());
            } else if (acquireResult instanceof OAuthCredentialsAcquirer.AcquireCredentialsResult.Error) {
                $this$processCode.getResult().completeExceptionally(new RuntimeException(((OAuthCredentialsAcquirer.AcquireCredentialsResult.Error)acquireResult).getDescription()));
            }
        }
        catch (Exception e) {
            $this$processCode.getResult().completeExceptionally(e);
        }
    }

    private static final void authorize$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0084\b\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u00020\u0003B!\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007H\u00c6\u0003J/\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/intellij/collaboration/auth/services/OAuthServiceBase$OAuthRequestWithResult;", "T", "Lcom/intellij/collaboration/auth/credentials/Credentials;", "", "request", "Lcom/intellij/collaboration/auth/services/OAuthRequest;", "result", "Ljava/util/concurrent/CompletableFuture;", "(Lcom/intellij/collaboration/auth/services/OAuthRequest;Ljava/util/concurrent/CompletableFuture;)V", "getRequest", "()Lcom/intellij/collaboration/auth/services/OAuthRequest;", "getResult", "()Ljava/util/concurrent/CompletableFuture;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.collaborationTools.auth"})
    protected static final class OAuthRequestWithResult<T extends Credentials> {
        @NotNull
        private final OAuthRequest<T> request;
        @NotNull
        private final CompletableFuture<T> result;

        public OAuthRequestWithResult(@NotNull OAuthRequest<T> request, @NotNull CompletableFuture<T> result2) {
            Intrinsics.checkNotNullParameter(request, (String)"request");
            Intrinsics.checkNotNullParameter(result2, (String)"result");
            this.request = request;
            this.result = result2;
        }

        @NotNull
        public final OAuthRequest<T> getRequest() {
            return this.request;
        }

        @NotNull
        public final CompletableFuture<T> getResult() {
            return this.result;
        }

        @NotNull
        public final OAuthRequest<T> component1() {
            return this.request;
        }

        @NotNull
        public final CompletableFuture<T> component2() {
            return this.result;
        }

        @NotNull
        public final OAuthRequestWithResult<T> copy(@NotNull OAuthRequest<T> request, @NotNull CompletableFuture<T> result2) {
            Intrinsics.checkNotNullParameter(request, (String)"request");
            Intrinsics.checkNotNullParameter(result2, (String)"result");
            return new OAuthRequestWithResult<T>(request, result2);
        }

        public static /* synthetic */ OAuthRequestWithResult copy$default(OAuthRequestWithResult oAuthRequestWithResult, OAuthRequest oAuthRequest, CompletableFuture completableFuture, int n, Object object) {
            if ((n & 1) != 0) {
                oAuthRequest = oAuthRequestWithResult.request;
            }
            if ((n & 2) != 0) {
                completableFuture = oAuthRequestWithResult.result;
            }
            return oAuthRequestWithResult.copy(oAuthRequest, completableFuture);
        }

        @NotNull
        public String toString() {
            return "OAuthRequestWithResult(request=" + this.request + ", result=" + this.result + ")";
        }

        public int hashCode() {
            int result2 = this.request.hashCode();
            result2 = result2 * 31 + this.result.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OAuthRequestWithResult)) {
                return false;
            }
            OAuthRequestWithResult oAuthRequestWithResult = (OAuthRequestWithResult)other;
            if (!Intrinsics.areEqual(this.request, oAuthRequestWithResult.request)) {
                return false;
            }
            return Intrinsics.areEqual(this.result, oAuthRequestWithResult.result);
        }
    }
}

