/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.analysis.XmlAnalysisBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class XmlChangeAttributeValueIntentionFix
implements LocalQuickFix,
IntentionAction,
PriorityAction {
    private final String myNewAttributeValue;
    private PriorityAction.Priority myPriority;

    public XmlChangeAttributeValueIntentionFix(String newAttributeValue) {
        this.myNewAttributeValue = newAttributeValue;
        this.myPriority = PriorityAction.Priority.NORMAL;
    }

    @NotNull
    public String getName() {
        String string2 = XmlAnalysisBundle.message("xml.quickfix.change.attribute.value", this.myNewAttributeValue);
        if (string2 == null) {
            XmlChangeAttributeValueIntentionFix.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string2 = this.myNewAttributeValue != null ? this.getName() : this.getFamilyName();
        if (string2 == null) {
            XmlChangeAttributeValueIntentionFix.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @NotNull
    public String getFamilyName() {
        String string2 = XmlAnalysisBundle.message("xml.quickfix.change.attribute.value.family", new Object[0]);
        if (string2 == null) {
            XmlChangeAttributeValueIntentionFix.$$$reportNull$$$0(2);
        }
        return string2;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file) {
        if (project2 == null) {
            XmlChangeAttributeValueIntentionFix.$$$reportNull$$$0(3);
        }
        return XmlChangeAttributeValueIntentionFix.getAttribute(editor, file) != null;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project2 == null) {
            XmlChangeAttributeValueIntentionFix.$$$reportNull$$$0(4);
        }
        this.changeAttributeValue(XmlChangeAttributeValueIntentionFix.getAttribute(editor, file), editor);
    }

    public boolean startInWriteAction() {
        return true;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        if (project2 == null) {
            XmlChangeAttributeValueIntentionFix.$$$reportNull$$$0(5);
        }
        if (descriptor == null) {
            XmlChangeAttributeValueIntentionFix.$$$reportNull$$$0(6);
        }
        PsiElement e = descriptor.getPsiElement();
        this.changeAttributeValue(e, null);
    }

    protected void changeAttributeValue(PsiElement e, Editor editor) {
        XmlAttribute attr = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)e, XmlAttribute.class, (boolean)false);
        if (attr == null) {
            return;
        }
        attr.setValue(this.myNewAttributeValue);
        XmlAttributeValue valueElement = attr.getValueElement();
        if (editor != null && valueElement != null) {
            editor.getCaretModel().moveToOffset(valueElement.getValueTextRange().getStartOffset());
        }
    }

    public void setPriority(PriorityAction.Priority value2) {
        this.myPriority = value2;
    }

    @NotNull
    public PriorityAction.Priority getPriority() {
        PriorityAction.Priority priority2 = this.myPriority;
        if (priority2 == null) {
            XmlChangeAttributeValueIntentionFix.$$$reportNull$$$0(7);
        }
        return priority2;
    }

    private static XmlAttribute getAttribute(Editor editor, PsiFile file) {
        int offset = editor.getCaretModel().getOffset();
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(offset), XmlAttribute.class);
        if (attribute == null) {
            attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(offset - 1), XmlAttribute.class);
        }
        return attribute;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/XmlChangeAttributeValueIntentionFix";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/XmlChangeAttributeValueIntentionFix";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPriority";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 3, 4, 5, 6 -> new IllegalArgumentException(string2);
        };
    }
}

