/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.DataEnumerator;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SimpleStringPersistentEnumerator
implements DataEnumerator<String> {
    @NotNull
    private final Path myFile;
    private final Charset charset;
    @NotNull
    private final Object2IntMap<String> myInvertedState;
    @NotNull
    private final Int2ObjectMap<String> myForwardState;

    public SimpleStringPersistentEnumerator(@NotNull Path file2) {
        if (file2 == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(0);
        }
        this(file2, Charset.defaultCharset());
    }

    public SimpleStringPersistentEnumerator(@NotNull Path file2, @NotNull Charset charset) {
        if (file2 == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(1);
        }
        if (charset == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(2);
        }
        this.myFile = file2;
        this.charset = charset;
        Pair<Object2IntMap<String>, Int2ObjectMap<String>> pair = SimpleStringPersistentEnumerator.readStorageFromDisk(file2, charset);
        this.myInvertedState = (Object2IntMap)pair.getFirst();
        this.myForwardState = (Int2ObjectMap)pair.getSecond();
    }

    @NotNull
    public Path getFile() {
        Path path = this.myFile;
        if (path == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(3);
        }
        return path;
    }

    @Override
    public synchronized int enumerate(@Nullable String value) {
        int id = this.myInvertedState.getInt(value);
        if (id != this.myInvertedState.defaultReturnValue()) {
            return id;
        }
        if (value != null && StringUtil.containsLineBreak(value)) {
            throw new IllegalArgumentException("SimpleStringPersistentEnumerator doesn't support multi-line strings: [" + value + "]");
        }
        id = this.myForwardState.size() + 1;
        this.myInvertedState.put(value, id);
        this.myForwardState.put(id, value);
        SimpleStringPersistentEnumerator.writeStorageToDisk(this.myForwardState, this.myFile, this.charset);
        return id;
    }

    @NotNull
    public synchronized Collection<String> entries() {
        return new ArrayList<String>(this.myInvertedState.keySet());
    }

    @NotNull
    public synchronized Map<String, Integer> getInvertedState() {
        Map<String, Integer> map2 = Collections.unmodifiableMap(this.myInvertedState);
        if (map2 == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(4);
        }
        return map2;
    }

    @Override
    @Nullable
    public synchronized String valueOf(int idx) {
        return (String)this.myForwardState.get(idx);
    }

    public synchronized void forceDiskSync() {
        SimpleStringPersistentEnumerator.writeStorageToDisk(this.myForwardState, this.myFile, this.charset);
    }

    public synchronized boolean isEmpty() {
        return this.myInvertedState.isEmpty();
    }

    public synchronized int getSize() {
        return this.myInvertedState.size();
    }

    @NotNull
    public String dumpToString() {
        String string2 = this.myInvertedState.object2IntEntrySet().stream().sorted(Comparator.comparing(e -> e.getIntValue())).map(e -> (String)e.getKey() + "->" + e.getIntValue()).collect(Collectors.joining("\n"));
        if (string2 == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(5);
        }
        return string2;
    }

    @NotNull
    private static Pair<Object2IntMap<String>, Int2ObjectMap<String>> readStorageFromDisk(@NotNull Path file2, Charset charset) {
        Pair pair;
        if (file2 == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(6);
        }
        try {
            Object2IntOpenHashMap<String> nameToIdRegistry = new Object2IntOpenHashMap<String>();
            Int2ObjectOpenHashMap<String> idToNameRegistry = new Int2ObjectOpenHashMap<String>();
            List<String> lines = Files.readAllLines(file2, charset);
            for (int i = 0; i < lines.size(); ++i) {
                String name = lines.get(i);
                int id = i + 1;
                nameToIdRegistry.put(name, id);
                idToNameRegistry.put(id, name);
            }
            pair = Pair.create(nameToIdRegistry, idToNameRegistry);
        }
        catch (IOException e) {
            SimpleStringPersistentEnumerator.writeStorageToDisk(Int2ObjectMaps.emptyMap(), file2, charset);
            Pair pair2 = Pair.create(new Object2IntOpenHashMap(), new Int2ObjectOpenHashMap());
            if (pair2 == null) {
                SimpleStringPersistentEnumerator.$$$reportNull$$$0(8);
            }
            return pair2;
        }
        if (pair == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(7);
        }
        return pair;
    }

    private static void writeStorageToDisk(@NotNull Int2ObjectMap<String> forwardIndex, @NotNull Path file2, Charset charset) {
        if (forwardIndex == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(9);
        }
        if (file2 == null) {
            SimpleStringPersistentEnumerator.$$$reportNull$$$0(10);
        }
        try {
            String[] names = new String[forwardIndex.size()];
            ObjectIterator<Int2ObjectMap.Entry<String>> iterator2 = Int2ObjectMaps.fastIterator(forwardIndex);
            while (iterator2.hasNext()) {
                Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iterator2.next();
                names[entry.getIntKey() - 1] = (String)entry.getValue();
            }
            Files.createDirectories(file2.getParent(), new FileAttribute[0]);
            Files.write(file2, Arrays.asList(names), charset, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Can't store enumerator to " + file2, e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/SimpleStringPersistentEnumerator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forwardIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/SimpleStringPersistentEnumerator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvertedState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpToString";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "readStorageFromDisk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readStorageFromDisk";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "writeStorageToDisk";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

