/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.schema;

import com.intellij.codeInsight.navigation.actions.GotoDeclarationHandler;
import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.JsonSchemaGotoDeclarationSuppressor;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaResolver;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.schema.YamlJsonPsiWalker;

public class YamlJsonSchemaGotoDeclarationHandler
implements GotoDeclarationHandler {
    public PsiElement @Nullable [] getGotoDeclarationTargets(@Nullable PsiElement sourceElement, int offset, Editor editor) {
        PsiElement target;
        boolean shouldSuppressNavigation = ContainerUtil.exists((Iterable)JsonSchemaGotoDeclarationSuppressor.EP_NAME.getExtensionList(), it -> it.shouldSuppressGtd(sourceElement));
        if (shouldSuppressNavigation) {
            return null;
        }
        IElementType elementType = PsiUtilCore.getElementType((PsiElement)sourceElement);
        if (elementType != YAMLTokenTypes.SCALAR_KEY) {
            return null;
        }
        YAMLKeyValue literal = (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)sourceElement, YAMLKeyValue.class);
        if (literal == null || literal.getKey() != sourceElement || !ArrayUtil.isEmpty((Object[])literal.getReferences())) {
            return null;
        }
        JsonSchemaService service = JsonSchemaService.Impl.get((Project)literal.getProject());
        PsiFile containingFile = literal.getContainingFile();
        VirtualFile file = containingFile.getVirtualFile();
        if (file == null || !service.isApplicableToFile(file)) {
            return null;
        }
        JsonPointerPosition steps = YamlJsonPsiWalker.INSTANCE.findPosition((PsiElement)literal, true);
        if (steps == null) {
            return null;
        }
        JsonSchemaObject schemaObject = service.getSchemaObject(containingFile);
        if (schemaObject != null && (target = new JsonSchemaResolver(sourceElement.getProject(), schemaObject, steps).findNavigationTarget((PsiElement)literal.getValue())) != null) {
            return new PsiElement[]{target};
        }
        return null;
    }
}

