/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.xxh3;

import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.xxh3.Access;
import org.jetbrains.xxh3.ByteArrayAccess;
import org.jetbrains.xxh3.CharSequenceAccess;
import org.jetbrains.xxh3.InputStreamAccess;
import org.jetbrains.xxh3.Xxh3Impl;

@ApiStatus.Internal
@ApiStatus.Experimental
public final class Xxh3 {
    public static long hash(byte @NotNull [] input) {
        if (input == null) {
            Xxh3.$$$reportNull$$$0(0);
        }
        return Xxh3Impl.hash(input, ByteArrayAccess.INSTANCE, 0, input.length, 0L);
    }

    public static long hash(@NotNull InputStream inputStream, int length) {
        if (inputStream == null) {
            Xxh3.$$$reportNull$$$0(1);
        }
        return Xxh3Impl.hash(inputStream, new InputStreamAccess(length), 0, length, 0L);
    }

    public static long hash(byte @NotNull [] input, int offset, int length) {
        if (input == null) {
            Xxh3.$$$reportNull$$$0(2);
        }
        return Xxh3Impl.hash(input, ByteArrayAccess.INSTANCE, offset, length, 0L);
    }

    public static long hash(@NotNull ByteBuffer input) {
        if (input == null) {
            Xxh3.$$$reportNull$$$0(3);
        }
        return Xxh3.hash(input, input.position(), input.remaining());
    }

    public static long hash(@NotNull ByteBuffer input, int offset, int length) {
        if (input == null) {
            Xxh3.$$$reportNull$$$0(4);
        }
        if (input.hasArray()) {
            return Xxh3Impl.hash(input.array(), ByteArrayAccess.INSTANCE, input.arrayOffset() + offset, length, 0L);
        }
        return Xxh3Impl.hash(input, ByteBufferAccess.INSTANCE, offset, length, 0L);
    }

    public static long hash(@NotNull String input) {
        if (input == null) {
            Xxh3.$$$reportNull$$$0(5);
        }
        byte[] data = input.getBytes(StandardCharsets.UTF_8);
        return Xxh3Impl.hash(data, ByteArrayAccess.INSTANCE, 0, data.length, 0L);
    }

    public static long hashUnencodedChars(@NotNull CharSequence input) {
        if (input == null) {
            Xxh3.$$$reportNull$$$0(6);
        }
        return Xxh3Impl.hash(input, CharSequenceAccess.INSTANCE, 0, input.length() * 2, 0L);
    }

    public static long hashLongs(long @NotNull [] input) {
        if (input == null) {
            Xxh3.$$$reportNull$$$0(7);
        }
        return Xxh3.hashLongs(input, 0L);
    }

    public static long hashLongs(long @NotNull [] input, long seed) {
        if (input == null) {
            Xxh3.$$$reportNull$$$0(8);
        }
        return Xxh3Impl.hash(input, LongArrayAccessForLongs.INSTANCE, 0, input.length * 8, seed);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/xxh3/Xxh3";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "hash";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "hashUnencodedChars";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "hashLongs";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class ByteBufferAccess
    implements Access<ByteBuffer> {
        private static final VarHandle LONG_HANDLE = MethodHandles.byteBufferViewVarHandle(long[].class, ByteOrder.LITTLE_ENDIAN);
        private static final VarHandle INT_HANDLE = MethodHandles.byteBufferViewVarHandle(int[].class, ByteOrder.LITTLE_ENDIAN);
        @NotNull
        private static final Access<ByteBuffer> INSTANCE = new ByteBufferAccess();

        private ByteBufferAccess() {
        }

        @Override
        public long i64(ByteBuffer input, int offset) {
            return LONG_HANDLE.get(input, offset);
        }

        @Override
        public int i32(ByteBuffer input, int offset) {
            return INT_HANDLE.get(input, offset);
        }

        @Override
        public int i8(ByteBuffer input, int offset) {
            return input.get(offset);
        }
    }

    private static final class LongArrayAccessForLongs
    implements Access<long[]> {
        private static final LongArrayAccessForLongs INSTANCE = new LongArrayAccessForLongs();

        private LongArrayAccessForLongs() {
        }

        @Override
        public long i64(long[] input, int offset) {
            return input[offset >> 3];
        }

        @Override
        public int i32(long[] input, int offset) {
            long v = input[offset >> 3];
            return (offset & 7) == 0 ? (int)(v >> 32) : (int)v;
        }

        @Override
        public int i8(long[] input, int offset) {
            throw new UnsupportedOperationException();
        }
    }
}

