/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.r.inlays.table.paging;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.ui.ComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.visualization.r.VisualizationBundle;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.dataframe.DataFrame;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.DataFrameTableModel;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.PagingTableModel;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020#H\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u0012\u0010'\u001a\u00020#2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0002J\b\u0010(\u001a\u00020#H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001dX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001dX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001dX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/table/paging/TablePaginator;", "Ljavax/swing/JPanel;", "()V", "currentPage", "Ljavax/swing/JTextField;", "currentPageChanging", "", "label", "Ljavax/swing/JLabel;", "getLabel", "()Ljavax/swing/JLabel;", "rowsNumber", "Lcom/intellij/openapi/ui/ComboBox;", "", "kotlin.jvm.PlatformType", "value", "Ljavax/swing/JTable;", "table", "getTable", "()Ljavax/swing/JTable;", "setTable", "(Ljavax/swing/JTable;)V", "tableModel", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/table/PagingTableModel;", "getTableModel", "()Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/table/PagingTableModel;", "setTableModel", "(Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/table/PagingTableModel;)V", "toFirst", "Lcom/intellij/openapi/actionSystem/impl/ActionButton;", "toLast", "toNext", "toPrevious", "totalPages", "cleanUp", "", "createActionButtons", "getDataFrame", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/dataframe/DataFrame;", "setUp", "updateInfo", "intellij.notebooks.visualization"})
public final class TablePaginator
extends JPanel {
    @NotNull
    private final ComboBox<Integer> rowsNumber;
    private ActionButton toFirst;
    private ActionButton toPrevious;
    private ActionButton toNext;
    private ActionButton toLast;
    @NotNull
    private JTextField currentPage;
    @NotNull
    private final JLabel totalPages;
    private boolean currentPageChanging;
    @NotNull
    private final JLabel label;
    @Nullable
    private JTable table;
    @Nullable
    private PagingTableModel tableModel;

    public TablePaginator() {
        super(new BorderLayout());
        JComponent editorComponent;
        Object[] objectArray = new Integer[]{10, 15, 30, 100};
        this.rowsNumber = new ComboBox(objectArray);
        this.currentPage = new JTextField();
        this.totalPages = new JLabel();
        this.label = new JLabel();
        this.createActionButtons();
        this.currentPage.getDocument().addDocumentListener(new DocumentListener(){

            private final int currentPageIndex() {
                String string = currentPage.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"currentPage.text");
                Integer index = StringsKt.toIntOrNull((String)string);
                if (index == null) {
                    PagingTableModel pagingTableModel = this.getTableModel();
                    Intrinsics.checkNotNull((Object)pagingTableModel);
                    return pagingTableModel.getPageOffset();
                }
                return index;
            }

            private final void updatePageOffset() {
                if (currentPageChanging) {
                    return;
                }
                PagingTableModel pagingTableModel = this.getTableModel();
                if (pagingTableModel != null) {
                    pagingTableModel.setPageOffset(this.currentPageIndex() - 1);
                }
                JLabel jLabel = this.getLabel();
                Object[] objectArray = new Object[3];
                PagingTableModel pagingTableModel2 = this.getTableModel();
                Intrinsics.checkNotNull((Object)pagingTableModel2);
                int n = pagingTableModel2.getPageOffset();
                PagingTableModel pagingTableModel3 = this.getTableModel();
                Intrinsics.checkNotNull((Object)pagingTableModel3);
                objectArray[0] = n * pagingTableModel3.getPageSize() + 1;
                PagingTableModel pagingTableModel4 = this.getTableModel();
                Intrinsics.checkNotNull((Object)pagingTableModel4);
                int n2 = pagingTableModel4.getPageOffset();
                PagingTableModel pagingTableModel5 = this.getTableModel();
                Intrinsics.checkNotNull((Object)pagingTableModel5);
                int n3 = n2 * pagingTableModel5.getPageSize();
                PagingTableModel pagingTableModel6 = this.getTableModel();
                Intrinsics.checkNotNull((Object)pagingTableModel6);
                objectArray[1] = n3 + pagingTableModel6.getRowCount();
                PagingTableModel pagingTableModel7 = this.getTableModel();
                Intrinsics.checkNotNull((Object)pagingTableModel7);
                objectArray[2] = pagingTableModel7.getRealRowCount();
                jLabel.setText(VisualizationBundle.INSTANCE.message("paginator.displaying", objectArray));
            }

            @Override
            public void changedUpdate(@Nullable DocumentEvent e) {
                this.updatePageOffset();
            }

            @Override
            public void insertUpdate(@Nullable DocumentEvent e) {
                this.updatePageOffset();
            }

            @Override
            public void removeUpdate(@Nullable DocumentEvent e) {
                this.updatePageOffset();
            }
        });
        this.rowsNumber.setEditable(true);
        Component component = this.rowsNumber.getEditor().getEditorComponent();
        JComponent jComponent = editorComponent = component instanceof JComponent ? (JComponent)component : null;
        if (jComponent != null) {
            jComponent.putClientProperty("AuxEditorComponent", true);
        }
        this.rowsNumber.addActionListener(arg_0 -> TablePaginator._init_$lambda$0(this, arg_0));
        JPanel rightPanel = new JPanel();
        rightPanel.add((Component)this.rowsNumber);
        this.add((Component)rightPanel, "After");
        JPanel panel = new JPanel(new FlowLayout(0));
        ActionButton actionButton = this.toFirst;
        if (actionButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"toFirst");
            actionButton = null;
        }
        panel.add((Component)actionButton);
        ActionButton actionButton2 = this.toPrevious;
        if (actionButton2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"toPrevious");
            actionButton2 = null;
        }
        panel.add((Component)actionButton2);
        panel.add(new JToolBar.Separator());
        panel.add(new JLabel(VisualizationBundle.INSTANCE.message("paginator.label.page", new Object[0])));
        this.currentPage.putClientProperty("AuxEditorComponent", true);
        panel.add(this.currentPage);
        panel.add(this.totalPages);
        panel.add(new JToolBar.Separator());
        ActionButton actionButton3 = this.toNext;
        if (actionButton3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"toNext");
            actionButton3 = null;
        }
        panel.add((Component)actionButton3);
        ActionButton actionButton4 = this.toLast;
        if (actionButton4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"toLast");
            actionButton4 = null;
        }
        panel.add((Component)actionButton4);
        panel.add(new JToolBar.Separator());
        panel.add(this.label);
        this.add((Component)panel, "Before");
    }

    @NotNull
    public final JLabel getLabel() {
        return this.label;
    }

    @Nullable
    public final JTable getTable() {
        return this.table;
    }

    public final void setTable(@Nullable JTable value) {
        if (Intrinsics.areEqual((Object)this.table, (Object)value)) {
            return;
        }
        this.cleanUp();
        this.setUp(value);
        this.table = value;
    }

    @Nullable
    public final PagingTableModel getTableModel() {
        return this.tableModel;
    }

    public final void setTableModel(@Nullable PagingTableModel pagingTableModel) {
        this.tableModel = pagingTableModel;
    }

    private final void cleanUp() {
        int i;
        if (this.table == null) {
            return;
        }
        if (this.getParent() != null) {
            Container capturedParent = this.getParent();
            capturedParent.remove(this);
            capturedParent.revalidate();
        }
        int n = 0;
        JTable jTable = this.table;
        Intrinsics.checkNotNull((Object)jTable);
        int n2 = jTable.getColumnCount();
        int[] nArray = new int[n2];
        while (n < n2) {
            int n3 = n++;
            nArray[n3] = 75;
        }
        int[] columnWidths = nArray;
        JTable jTable2 = this.table;
        Intrinsics.checkNotNull((Object)jTable2);
        n2 = jTable2.getColumnCount();
        for (i = 0; i < n2; ++i) {
            JTable jTable3 = this.table;
            Intrinsics.checkNotNull((Object)jTable3);
            columnWidths[i] = jTable3.getColumnModel().getColumn(i).getWidth();
        }
        JTable jTable4 = this.table;
        Intrinsics.checkNotNull((Object)jTable4);
        JTable jTable5 = this.table;
        Intrinsics.checkNotNull((Object)jTable5);
        jTable4.setModel(new DataFrameTableModel(this.getDataFrame(jTable5)));
        JTable jTable6 = this.table;
        Intrinsics.checkNotNull((Object)jTable6);
        n2 = jTable6.getColumnCount();
        for (i = 0; i < n2; ++i) {
            JTable jTable7 = this.table;
            Intrinsics.checkNotNull((Object)jTable7);
            jTable7.getColumnModel().getColumn(i).setPreferredWidth(columnWidths[i]);
        }
    }

    private final DataFrame getDataFrame(JTable table) {
        DataFrame dataFrame;
        if (table.getModel() instanceof DataFrameTableModel) {
            TableModel tableModel = table.getModel();
            Intrinsics.checkNotNull((Object)tableModel, (String)"null cannot be cast to non-null type org.jetbrains.plugins.notebooks.visualization.r.inlays.table.DataFrameTableModel");
            dataFrame = ((DataFrameTableModel)tableModel).getDataFrame();
        } else {
            TableModel tableModel = table.getModel();
            Intrinsics.checkNotNull((Object)tableModel, (String)"null cannot be cast to non-null type org.jetbrains.plugins.notebooks.visualization.r.inlays.table.PagingTableModel");
            dataFrame = ((PagingTableModel)tableModel).getDataFrame();
        }
        return dataFrame;
    }

    private final void setUp(JTable table) {
        if (table == null) {
            return;
        }
        Container container = table.getParent();
        Container container2 = container != null && (container = container.getParent()) != null ? container.getParent() : null;
        JPanel jPanel = container2 instanceof JPanel ? (JPanel)container2 : null;
        if (jPanel == null) {
            return;
        }
        JPanel parentPanel = jPanel;
        parentPanel.add((Component)this, "Last");
        parentPanel.revalidate();
        if (table.getModel() instanceof PagingTableModel) {
            TableModel tableModel = table.getModel();
            Intrinsics.checkNotNull((Object)tableModel, (String)"null cannot be cast to non-null type org.jetbrains.plugins.notebooks.visualization.r.inlays.table.PagingTableModel");
            this.tableModel = (PagingTableModel)tableModel;
        } else {
            int i;
            this.tableModel = new PagingTableModel(this.getDataFrame(table));
            int n = 0;
            int n2 = table.getColumnCount();
            int[] nArray = new int[n2];
            while (n < n2) {
                int n3 = n++;
                nArray[n3] = 75;
            }
            int[] columnWidths = nArray;
            n2 = table.getColumnCount();
            for (i = 0; i < n2; ++i) {
                columnWidths[i] = table.getColumnModel().getColumn(i).getWidth();
            }
            table.setModel(this.tableModel);
            n2 = table.getColumnCount();
            for (i = 0; i < n2; ++i) {
                table.getColumnModel().getColumn(i).setPreferredWidth(columnWidths[i]);
            }
            PagingTableModel pagingTableModel = this.tableModel;
            Intrinsics.checkNotNull((Object)pagingTableModel);
            Object object = this.rowsNumber.getSelectedItem();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
            pagingTableModel.setPageSize((Integer)object);
        }
        if (table.getRowSorter() != null) {
            table.getRowSorter().addRowSorterListener(arg_0 -> TablePaginator.setUp$lambda$1(table, this, arg_0));
        }
        this.updateInfo();
    }

    private final void updateInfo() {
        this.currentPageChanging = true;
        Object[] objectArray = new Object[3];
        PagingTableModel pagingTableModel = this.tableModel;
        Intrinsics.checkNotNull((Object)pagingTableModel);
        int n = pagingTableModel.getPageOffset();
        PagingTableModel pagingTableModel2 = this.tableModel;
        Intrinsics.checkNotNull((Object)pagingTableModel2);
        objectArray[0] = n * pagingTableModel2.getPageSize() + 1;
        PagingTableModel pagingTableModel3 = this.tableModel;
        Intrinsics.checkNotNull((Object)pagingTableModel3);
        int n2 = pagingTableModel3.getPageOffset();
        PagingTableModel pagingTableModel4 = this.tableModel;
        Intrinsics.checkNotNull((Object)pagingTableModel4);
        int n3 = n2 * pagingTableModel4.getPageSize();
        PagingTableModel pagingTableModel5 = this.tableModel;
        Intrinsics.checkNotNull((Object)pagingTableModel5);
        objectArray[1] = n3 + pagingTableModel5.getRowCount();
        PagingTableModel pagingTableModel6 = this.tableModel;
        Intrinsics.checkNotNull((Object)pagingTableModel6);
        objectArray[2] = pagingTableModel6.getRealRowCount();
        this.label.setText(VisualizationBundle.INSTANCE.message("paginator.displaying", objectArray));
        PagingTableModel pagingTableModel7 = this.tableModel;
        Intrinsics.checkNotNull((Object)pagingTableModel7);
        this.currentPage.setText(String.valueOf(pagingTableModel7.getPageOffset() + 1));
        objectArray = new Object[1];
        PagingTableModel pagingTableModel8 = this.tableModel;
        Intrinsics.checkNotNull((Object)pagingTableModel8);
        objectArray[0] = String.valueOf(pagingTableModel8.getPageCount());
        this.totalPages.setText(VisualizationBundle.INSTANCE.message("paginator.of", objectArray));
        this.currentPageChanging = false;
    }

    private final void createActionButtons() {
        String string = VisualizationBundle.INSTANCE.message("paginator.first.page.text", new Object[0]);
        String string2 = VisualizationBundle.INSTANCE.message("paginator.first.page.description", new Object[0]);
        Icon icon = AllIcons.Actions.Play_first;
        AnAction action2 = new AnAction(this, string, string2, icon){
            final /* synthetic */ TablePaginator this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                PagingTableModel pagingTableModel = this.this$0.getTableModel();
                Intrinsics.checkNotNull((Object)pagingTableModel);
                pagingTableModel.setPageOffset(0);
                TablePaginator.access$updateInfo(this.this$0);
            }
        };
        this.toFirst = new ActionButton(action2, action2.getTemplatePresentation(), "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        string = VisualizationBundle.INSTANCE.message("paginator.previous.page.text", new Object[0]);
        string2 = VisualizationBundle.INSTANCE.message("paginator.previous.page.description", new Object[0]);
        icon = AllIcons.Actions.Play_back;
        action2 = new AnAction(this, string, string2, icon){
            final /* synthetic */ TablePaginator this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                PagingTableModel pagingTableModel = this.this$0.getTableModel();
                Intrinsics.checkNotNull((Object)pagingTableModel);
                PagingTableModel pagingTableModel2 = pagingTableModel;
                int n = pagingTableModel2.getPageOffset();
                pagingTableModel2.setPageOffset(n + -1);
                TablePaginator.access$updateInfo(this.this$0);
            }
        };
        this.toPrevious = new ActionButton(action2, (action2).getTemplatePresentation(), "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        string = VisualizationBundle.INSTANCE.message("paginator.next.page.text", new Object[0]);
        string2 = VisualizationBundle.INSTANCE.message("paginator.next.page.description", new Object[0]);
        icon = AllIcons.Actions.Play_forward;
        action2 = new AnAction(this, string, string2, icon){
            final /* synthetic */ TablePaginator this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                PagingTableModel pagingTableModel = this.this$0.getTableModel();
                Intrinsics.checkNotNull((Object)pagingTableModel);
                PagingTableModel pagingTableModel2 = pagingTableModel;
                int n = pagingTableModel2.getPageOffset();
                pagingTableModel2.setPageOffset(n + 1);
                TablePaginator.access$updateInfo(this.this$0);
            }
        };
        this.toNext = new ActionButton(action2, (action2).getTemplatePresentation(), "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        string = VisualizationBundle.INSTANCE.message("paginator.last.page.text", new Object[0]);
        string2 = VisualizationBundle.INSTANCE.message("paginator.last.page.description", new Object[0]);
        icon = AllIcons.Actions.Play_last;
        action2 = new AnAction(this, string, string2, icon){
            final /* synthetic */ TablePaginator this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                PagingTableModel pagingTableModel = this.this$0.getTableModel();
                Intrinsics.checkNotNull((Object)pagingTableModel);
                PagingTableModel pagingTableModel2 = this.this$0.getTableModel();
                Intrinsics.checkNotNull((Object)pagingTableModel2);
                pagingTableModel.setPageOffset(pagingTableModel2.getPageCount() - 1);
                TablePaginator.access$updateInfo(this.this$0);
            }
        };
        this.toLast = new ActionButton(action2, (action2).getTemplatePresentation(), "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
    }

    private static final void _init_$lambda$0(TablePaginator this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.rowsNumber.getSelectedItem() instanceof Integer) {
            PagingTableModel pagingTableModel = this$0.tableModel;
            if (pagingTableModel != null) {
                Object object = this$0.rowsNumber.getSelectedItem();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                pagingTableModel.setPageSize((Integer)object);
            }
            this$0.updateInfo();
        }
    }

    private static final void setUp$lambda$1(JTable $table, TablePaginator this$0, RowSorterEvent e) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (e.getType() == RowSorterEvent.Type.SORT_ORDER_CHANGED) {
            int sortColumn = -1;
            boolean sortDescending = false;
            RowSorter<? extends TableModel> rowSorter = $table.getRowSorter();
            if (rowSorter != null) {
                for (RowSorter.SortKey sortKey : rowSorter.getSortKeys()) {
                    if (sortKey.getSortOrder() == SortOrder.UNSORTED) continue;
                    sortColumn = sortKey.getColumn();
                    boolean bl = sortDescending = sortKey.getSortOrder() == SortOrder.DESCENDING;
                    break;
                }
            }
            if (sortColumn != -1) {
                DataFrame dataFrame = this$0.getDataFrame($table);
                dataFrame.sortBy(dataFrame.get(sortColumn).getName(), sortDescending);
                TableModel tableModel = $table.getModel();
                Intrinsics.checkNotNull((Object)tableModel, (String)"null cannot be cast to non-null type javax.swing.table.AbstractTableModel");
                ((AbstractTableModel)tableModel).fireTableDataChanged();
            }
        }
    }

    public static final /* synthetic */ void access$updateInfo(TablePaginator $this) {
        $this.updateInfo();
    }
}

