/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.parser;

import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.parser.HtmlEntities;

class HtmlHandler {
    private StringBuffer buffer = new StringBuffer();

    HtmlHandler() {
    }

    public String stripHtml(String s) {
        String inner = this.getSubstringUnderHtmlTag(s);
        return (inner == null ? s : this.removeHtmlInfo(inner)).trim();
    }

    private String removeHtmlInfo(String inner) {
        boolean inTag = false;
        boolean inQuoteInTag = false;
        char quoteChar = '\"';
        int entityPos = -1;
        this.buffer.delete(0, this.buffer.length());
        for (char c : inner.toCharArray()) {
            int entityValue;
            int len;
            if (c == '<') {
                inTag = true;
                entityPos = -1;
                continue;
            }
            if (c == '>') {
                inTag = inTag && inQuoteInTag;
                continue;
            }
            if (inTag) {
                if (c != '\"' && c != '\'') continue;
                if (inQuoteInTag) {
                    inQuoteInTag = quoteChar != c;
                    continue;
                }
                inQuoteInTag = true;
                quoteChar = c;
                continue;
            }
            if (c == '&') {
                entityPos = this.buffer.length();
            } else if (c == ';' && entityPos != -1 && (len = this.buffer.length()) > entityPos + 2 && (entityValue = this.getEntityValue(entityPos + 1)) > 0 && entityValue < 65536) {
                this.buffer.delete(entityPos, len);
                c = (char)entityValue;
            }
            this.buffer.append(c);
        }
        return this.buffer.toString();
    }

    private int getEntityValue(int start) {
        if (this.buffer.charAt(start) == '#') {
            char hex = this.buffer.charAt(start);
            try {
                if (hex == 'x' || hex == 'X') {
                    return Integer.valueOf(this.buffer.substring(start + 2), 16);
                }
                return Integer.parseInt(this.buffer.substring(start + 1));
            }
            catch (NumberFormatException nfe) {
                return -1;
            }
        }
        return HtmlEntities.getEntityValue(this.buffer.substring(start));
    }

    private String getSubstringUnderHtmlTag(String s) {
        int l = s.length();
        if (!(l < 6 || s.charAt(0) != '<' || s.charAt(5) != '>' || s.charAt(1) != 'h' && s.charAt(1) != 'H' || s.charAt(2) != 't' && s.charAt(2) != 'T' || s.charAt(3) != 'm' && s.charAt(3) != 'M' || s.charAt(4) != 'l' && s.charAt(4) != 'L')) {
            if (!(l < 13 || s.charAt(l - 1) != '>' || s.charAt(l - 7) != '<' || s.charAt(l - 6) != '/' || s.charAt(l - 5) != 'h' && s.charAt(l - 5) != 'H' || s.charAt(l - 4) != 't' && s.charAt(l - 4) != 'T' || s.charAt(l - 3) != 'm' && s.charAt(l - 3) != 'M' || s.charAt(l - 2) != 'l' && s.charAt(l - 2) != 'L')) {
                l -= 7;
            }
            return s.substring(6, l);
        }
        return null;
    }
}

