/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.IParser;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui.FilterSettings;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui.IFilterEditor;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui.IParserModel;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.parser.DateComparator;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.parser.Parser;

public class ParserModel
implements IParserModel {
    private static final Map<Class<?>, Format> basicFormats = new HashMap();
    private static Comparator<String> strComparator;
    private static Comparator<String> icStrComparator;
    private final Map<Class<?>, Format> formats = new HashMap();
    private final Map<Class<?>, Comparator> comparators = new HashMap();
    private boolean ignoreCase;
    private final PropertyChangeSupport propertiesHandler = new PropertyChangeSupport(this);
    private static final Comparator DEFAULT_COMPARATOR;

    public ParserModel() {
        this.ignoreCase = !FilterSettings.ignoreCase;
        this.setIgnoreCase(!this.ignoreCase);
        this.setFormat(Date.class, ParserModel.getBasicFormat(Date.class));
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener2) {
        this.propertiesHandler.addPropertyChangeListener(listener2);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener2) {
        this.propertiesHandler.removePropertyChangeListener(listener2);
    }

    @Override
    public IParser createParser(IFilterEditor editor) {
        boolean ignoreCase = editor.isIgnoreCase();
        Class<?> cl = editor.getModelClass();
        Format fmt = cl == String.class ? null : editor.getFormat();
        Comparator cmp = fmt == null ? null : editor.getComparator();
        return this.createParser(fmt, cmp, this.getStringComparator(ignoreCase), ignoreCase, editor.getModelIndex());
    }

    protected IParser createParser(Format fmt, Comparator cmp, Comparator stringCmp, boolean ignoreCase, int modelIndex) {
        return new Parser(fmt, cmp, stringCmp, ignoreCase, modelIndex);
    }

    @Override
    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    public void setIgnoreCase(boolean set) {
        if (set != this.ignoreCase) {
            this.ignoreCase = set;
            this.propertiesHandler.firePropertyChange("ignoreCase", !set, set);
            this.setComparator(String.class, this.getStringComparator(set));
        }
    }

    public final Format getFormat(Class cl) {
        Format ret = this.formats.get(cl);
        if (ret == null) {
            if (cl.isEnum()) {
                ret = new EnumTypeFormat(cl);
                this.formats.put(cl, ret);
            } else {
                ret = ParserModel.getBasicFormat(cl);
            }
        }
        return ret;
    }

    @Override
    public final void setFormat(Class<?> cl, Format fmt) {
        Format old = this.formats.put(cl, fmt);
        if (old != fmt) {
            Comparator cmp;
            this.propertiesHandler.firePropertyChange("format", null, cl);
            if (Date.class.isAssignableFrom(cl) && fmt != null && ((cmp = this.getComparator(cl)) == null || cmp instanceof DateComparator)) {
                this.setComparator(cl, DateComparator.getDateComparator(fmt));
            }
        }
    }

    @Override
    public Comparator getComparator(Class<?> cl) {
        Comparator<Object> ret = this.comparators.get(cl);
        if (ret == null) {
            ret = cl == String.class ? this.getStringComparator(this.ignoreCase) : (Comparable.class.isAssignableFrom(cl) ? Comparator.naturalOrder() : DEFAULT_COMPARATOR);
        }
        return ret;
    }

    @Override
    public void setComparator(Class<?> cl, Comparator cmp) {
        if (cl == String.class) {
            if (cmp == null) {
                cmp = this.getStringComparator(this.ignoreCase);
            } else {
                this.setIgnoreCase(cmp.compare("a", "A") == 0);
            }
        } else if (cmp == null) {
            cmp = this.getComparator(cl);
        }
        if (cmp != this.comparators.put(cl, cmp)) {
            this.propertiesHandler.firePropertyChange("comparator", null, cl);
        }
    }

    @Override
    public Comparator<String> getStringComparator(boolean noCase) {
        return ParserModel.stringComparator(noCase);
    }

    public static Comparator<String> stringComparator(boolean ignoreCase) {
        if (ignoreCase) {
            if (icStrComparator == null) {
                icStrComparator = String.CASE_INSENSITIVE_ORDER;
            }
            return icStrComparator;
        }
        if (strComparator == null) {
            strComparator = Comparator.naturalOrder();
        }
        return strComparator;
    }

    private static Format getBasicFormat(Class<?> cl) {
        Format fmt = basicFormats.get(cl);
        if (fmt == null) {
            if (cl == String.class) {
                fmt = new StringTypeFormat();
            } else if (cl == Boolean.class) {
                fmt = new BooleanTypeFormat();
            } else if (cl == Integer.class) {
                fmt = new IntegerTypeFormat();
            } else if (cl == Long.class) {
                fmt = new LongTypeFormat();
            } else if (cl == Short.class) {
                fmt = new ShortTypeFormat();
            } else if (cl == Float.class) {
                fmt = new FloatTypeFormat();
            } else if (cl == Double.class) {
                fmt = new DoubleTypeFormat();
            } else if (cl == Byte.class) {
                fmt = new ByteTypeFormat();
            } else if (cl == Character.class) {
                fmt = new CharacterTypeFormat();
            } else if (cl == Date.class) {
                fmt = ParserModel.getDefaultDateFormat();
            }
            if (fmt != null) {
                basicFormats.put(cl, fmt);
            }
        }
        return fmt;
    }

    private static DateFormat getDefaultDateFormat() {
        String definition = FilterSettings.dateFormat;
        if (definition != null) {
            try {
                return new SimpleDateFormat(definition);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return DateFormat.getDateInstance(3);
    }

    static {
        DEFAULT_COMPARATOR = (o1, o2) -> {
            int ret = o1.toString().compareTo(o2.toString());
            if (ret == 0 && !o1.equals(o2) && (ret = o1.hashCode() - o2.hashCode()) == 0) {
                ret = System.identityHashCode(o1) - System.identityHashCode(o2);
            }
            return ret;
        };
    }

    public static class EnumTypeFormat
    extends TypeFormat {
        private static final long serialVersionUID = -7238741018044298862L;
        private Class<? extends Enum> enumClass;

        public EnumTypeFormat(Class<? extends Enum> enumClass) {
            this.enumClass = enumClass;
        }

        @Override
        public Object parseObject(String text) throws ParseException {
            try {
                return Enum.valueOf(this.enumClass, text);
            }
            catch (Exception ex) {
                throw new ParseException(text, 0);
            }
        }
    }

    public static class StringTypeFormat
    extends TypeFormat {
        private static final long serialVersionUID = 1641138429288273113L;

        @Override
        public Object parseObject(String source) {
            return source;
        }
    }

    public static class BooleanTypeFormat
    extends TypeFormat {
        private static final long serialVersionUID = -6014041038273288651L;

        @Override
        public Object parseObject(String text) {
            return Boolean.valueOf(text);
        }
    }

    public static class IntegerTypeFormat
    extends TypeFormat {
        private static final long serialVersionUID = 314115124294512565L;

        @Override
        public Object parseObject(String text) throws ParseException {
            try {
                return Integer.valueOf(text);
            }
            catch (NumberFormatException nfe) {
                throw new ParseException(text, 0);
            }
        }
    }

    public static class LongTypeFormat
    extends TypeFormat {
        private static final long serialVersionUID = 1165105738539025608L;

        @Override
        public Object parseObject(String text) throws ParseException {
            try {
                return Long.valueOf(text);
            }
            catch (NumberFormatException nfe) {
                throw new ParseException(text, 0);
            }
        }
    }

    public static class ShortTypeFormat
    extends TypeFormat {
        private static final long serialVersionUID = -2237230150685513628L;

        @Override
        public Object parseObject(String text) throws ParseException {
            try {
                return Short.valueOf(text);
            }
            catch (NumberFormatException nfe) {
                throw new ParseException(text, 0);
            }
        }
    }

    public static class FloatTypeFormat
    extends TypeFormat {
        private static final long serialVersionUID = 945229095107692481L;

        @Override
        public Object parseObject(String text) throws ParseException {
            try {
                return Float.valueOf(text);
            }
            catch (NumberFormatException nfe) {
                throw new ParseException(text, 0);
            }
        }
    }

    public static class DoubleTypeFormat
    extends TypeFormat {
        private static final long serialVersionUID = -6081024614795175063L;

        @Override
        public Object parseObject(String text) throws ParseException {
            try {
                return Double.valueOf(text);
            }
            catch (NumberFormatException nfe) {
                throw new ParseException(text, 0);
            }
        }
    }

    public static class ByteTypeFormat
    extends TypeFormat {
        private static final long serialVersionUID = -8872549512274058519L;

        @Override
        public Object parseObject(String text) throws ParseException {
            try {
                return Byte.valueOf(text);
            }
            catch (NumberFormatException nfe) {
                throw new ParseException(text, 0);
            }
        }
    }

    public static class CharacterTypeFormat
    extends TypeFormat {
        private static final long serialVersionUID = -7238741018044298862L;

        @Override
        public Object parseObject(String text) throws ParseException {
            if (text.length() != 1) {
                throw new ParseException(text, 0);
            }
            return new Character(text.charAt(0));
        }
    }

    static abstract class TypeFormat
    extends Format {
        private static final long serialVersionUID = -6161901343218446716L;

        TypeFormat() {
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            if (obj != null) {
                toAppendTo.append(obj);
            }
            return toAppendTo;
        }

        @Override
        public abstract Object parseObject(String var1) throws ParseException;

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            return null;
        }
    }
}

