/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.r.inlays;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.lang.invoke.MethodHandles;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.InlayDimensions;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.ResizeController;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 %2\u00020\u00012\u00020\u0002:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0013\u001a\u00020\u00142\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0016J\u0014\u0010\u0015\u001a\u00020\u00162\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0016J\u0014\u0010\u0017\u001a\u00020\u00162\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0016J\u0018\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0016H\u0016J\b\u0010\u001b\u001a\u00020\u0014H\u0016J,\u0010\u001c\u001a\u00020\u00142\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0012\u0010#\u001a\u00020\u00142\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005J\u0010\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020 H\u0002R \u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/InlayComponent;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "()V", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "getInlay", "()Lcom/intellij/openapi/editor/Inlay;", "setInlay", "(Lcom/intellij/openapi/editor/Inlay;)V", "value", "", "resizable", "getResizable", "()Z", "setResizable", "(Z)V", "resizeController", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/ResizeController;", "assignInlay", "", "calcHeightInPixels", "", "calcWidthInPixels", "deltaSize", "dx", "dy", "disposeInlay", "paint", "g", "Ljava/awt/Graphics;", "r", "Ljava/awt/Rectangle;", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "updateComponentBounds", "targetRegion", "Companion", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nInlayComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlayComponent.kt\norg/jetbrains/plugins/notebooks/visualization/r/inlays/InlayComponent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,138:1\n1#2:139\n*E\n"})
public class InlayComponent
extends JPanel
implements EditorCustomElementRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Inlay<?> inlay;
    @Nullable
    private ResizeController resizeController;
    @NotNull
    private static final Logger LOG;

    public InlayComponent() {
        super(new BorderLayout());
    }

    @Nullable
    public final Inlay<?> getInlay() {
        return this.inlay;
    }

    public final void setInlay(@Nullable Inlay<?> inlay) {
        this.inlay = inlay;
    }

    @Override
    public void paint(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Composite oldComposite = ((Graphics2D)g).getComposite();
        ((Graphics2D)g).setComposite(AlphaComposite.SrcOver);
        super.paint(g);
        ((Graphics2D)g).setComposite(oldComposite);
    }

    public final boolean getResizable() {
        return this.resizeController != null;
    }

    public final void setResizable(boolean value) {
        if (value && this.resizeController == null) {
            Component component = this;
            Inlay<?> inlay = this.inlay;
            Intrinsics.checkNotNull(inlay);
            Editor editor = inlay.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"inlay!!.editor");
            this.resizeController = new ResizeController(component, editor, (Function2<? super Integer, ? super Integer, Unit>)((Function2)new Function2<Integer, Integer, Unit>((Object)this){

                public final void invoke(int p0, int p1) {
                    ((InlayComponent)this.receiver).deltaSize(p0, p1);
                }
            }));
            this.addMouseMotionListener(this.resizeController);
            this.addMouseListener(this.resizeController);
        } else if (!value && this.resizeController != null) {
            this.removeMouseListener(this.resizeController);
            this.removeMouseMotionListener(this.resizeController);
            this.resizeController = null;
        }
    }

    public void paint(@NotNull Inlay<?> inlay, @NotNull Graphics g, @NotNull Rectangle r, @NotNull TextAttributes textAttributes) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
        this.updateComponentBounds(inlay);
    }

    public final void updateComponentBounds(@NotNull Inlay<?> inlay) {
        block0: {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            Rectangle rectangle = inlay.getBounds();
            if (rectangle == null) break block0;
            Rectangle it = rectangle;
            boolean bl = false;
            this.updateComponentBounds(it);
        }
    }

    public int calcWidthInPixels(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        Editor editor = inlay.getEditor();
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        return InlayDimensions.INSTANCE.calculateInlayWidth((EditorEx)((EditorImpl)editor));
    }

    public int calcHeightInPixels(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        return this.getSize().height;
    }

    public void deltaSize(int dx, int dy) {
        if (dx == 0 && dy == 0) {
            return;
        }
        this.setSize(new Dimension(this.getSize().width + dx, this.getSize().height + dy));
        Inlay<?> inlay = this.inlay;
        if (inlay != null) {
            inlay.update();
        }
        this.revalidate();
        this.repaint();
    }

    public void assignInlay(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        this.inlay = inlay;
        inlay.update();
    }

    private final void updateComponentBounds(Rectangle targetRegion) {
        if (Intrinsics.areEqual((Object)this.getBounds(), (Object)targetRegion)) {
            return;
        }
        this.setBounds(targetRegion);
        this.revalidate();
        this.repaint();
    }

    public void disposeInlay() {
        if (this.inlay == null) {
            return;
        }
        Inlay<?> inlay = this.inlay;
        Intrinsics.checkNotNull(inlay);
        Disposer.dispose((Disposable)((Disposable)inlay));
        this.inlay = null;
    }

    static {
        Logger logger = Logger.getInstance(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(MethodHandles.lookup().lookupClass())");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/InlayComponent$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.notebooks.visualization"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

