/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.plugins.notebooks.visualization.IntervalInfo;
import org.jetbrains.plugins.notebooks.visualization.NotebookCellLines;
import org.jetbrains.plugins.notebooks.visualization.NotebookCellLinesLexer;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001H\u0002\u00a8\u0006\u0007"}, d2={"toIntervalsInfo", "", "Lorg/jetbrains/plugins/notebooks/visualization/IntervalInfo;", "document", "Lcom/intellij/openapi/editor/Document;", "markers", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellLinesLexer$Marker;", "intellij.notebooks.visualization"})
public final class NotebookCellLinesLexerKt {
    private static final List<IntervalInfo> toIntervalsInfo(Document document, List<NotebookCellLinesLexer.Marker> markers) {
        Object object;
        List m = new ArrayList();
        if (markers.isEmpty() || document.getLineNumber(((NotebookCellLinesLexer.Marker)CollectionsKt.first(markers)).getOffset()) != 0) {
            object = m;
            PlainTextLanguage plainTextLanguage = PlainTextLanguage.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)plainTextLanguage, (String)"INSTANCE");
            object.add(new IntervalInfo(0, NotebookCellLines.CellType.RAW, NotebookCellLines.MarkersAtLines.NO, (Language)plainTextLanguage));
        }
        for (NotebookCellLinesLexer.Marker marker : markers) {
            Collection collection = m;
            int n = document.getLineNumber(marker.getOffset());
            NotebookCellLines.CellType cellType = marker.getType();
            Language language = marker.getLanguage();
            Intrinsics.checkNotNull((Object)language);
            collection.add(new IntervalInfo(n, cellType, NotebookCellLines.MarkersAtLines.TOP, language));
        }
        object = m;
        int n = Math.max(document.getLineCount(), 1);
        PlainTextLanguage plainTextLanguage = PlainTextLanguage.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)plainTextLanguage, (String)"INSTANCE");
        object.add(new IntervalInfo(n, NotebookCellLines.CellType.RAW, NotebookCellLines.MarkersAtLines.NO, (Language)plainTextLanguage));
        return m;
    }

    public static final /* synthetic */ List access$toIntervalsInfo(Document document, List markers) {
        return NotebookCellLinesLexerKt.toIntervalsInfo(document, markers);
    }
}

