/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.ui.visualization;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookEditorAppearance;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookLineMarkerRenderer;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookUtilKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/notebooks/ui/visualization/NotebookTextCellBackgroundLineMarkerRenderer;", "Lorg/jetbrains/plugins/notebooks/ui/visualization/NotebookLineMarkerRenderer;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;)V", "paint", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "g", "Ljava/awt/Graphics;", "r", "Ljava/awt/Rectangle;", "intellij.notebooks.ui"})
public final class NotebookTextCellBackgroundLineMarkerRenderer
extends NotebookLineMarkerRenderer {
    @NotNull
    private final RangeHighlighter highlighter;

    public NotebookTextCellBackgroundLineMarkerRenderer(@NotNull RangeHighlighter highlighter) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        super(null, 1, null);
        this.highlighter = highlighter;
    }

    public void paint(@NotNull Editor editor, @NotNull Graphics g, @NotNull Rectangle r) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            EditorImpl cfr_ignored_0 = (EditorImpl)editor;
            IntRange lines = new IntRange(((EditorImpl)editor).getDocument().getLineNumber(this.highlighter.getStartOffset()), ((EditorImpl)editor).getDocument().getLineNumber(this.highlighter.getEndOffset()));
            int top = editor.offsetToXY((int)((EditorImpl)editor).getDocument().getLineStartOffset((int)lines.getFirst())).y;
            int height = editor.offsetToXY((int)((EditorImpl)editor).getDocument().getLineEndOffset((int)lines.getLast())).y + ((EditorImpl)editor).getLineHeight() - top;
            NotebookUtilKt.paintCaretRow((EditorImpl)editor, g, lines);
            NotebookEditorAppearance appearance = NotebookUtilKt.getNotebookAppearance(editor);
            Color color = appearance.getCellStripeColor((EditorImpl)editor, lines);
            if (color == null) break block0;
            Color it = color;
            boolean bl = false;
            NotebookUtilKt.paintCellStripe(appearance, g, r, it, top, height);
        }
    }
}

