/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.core.ec4jwrappers;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.ec4j.core.Resource;
import org.ec4j.core.ResourcePath;
import org.ec4j.core.model.Ec4jPath;
import org.editorconfig.core.ec4jwrappers.NonExistentVirtualFileResource;
import org.editorconfig.core.ec4jwrappers.PathHolderResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0096\u0002J\b\u0010\f\u001a\u00020\tH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\tH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0001H\u0016J\u0010\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lorg/editorconfig/core/ec4jwrappers/VirtualFileResource;", "Lorg/ec4j/core/Resource;", "Lorg/ec4j/core/ResourcePath;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "equals", "", "other", "", "exists", "getParent", "getPath", "Lorg/ec4j/core/model/Ec4jPath;", "hasParent", "hashCode", "", "openRandomReader", "Lorg/ec4j/core/Resource$RandomReader;", "openReader", "Ljava/io/Reader;", "relativize", "resource", "resolve", "name", "", "intellij.editorconfig"})
@SourceDebugExtension(value={"SMAP\nVirtualFileResources.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VirtualFileResources.kt\norg/editorconfig/core/ec4jwrappers/VirtualFileResource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n1#2:74\n*E\n"})
public final class VirtualFileResource
implements Resource,
ResourcePath {
    @NotNull
    private final VirtualFile file;

    public VirtualFileResource(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof VirtualFileResource && Intrinsics.areEqual((Object)this.file, (Object)((VirtualFileResource)other).file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    @Nullable
    public ResourcePath getParent() {
        VirtualFileResource virtualFileResource;
        VirtualFile virtualFile = this.file.getParent();
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            virtualFileResource = new VirtualFileResource(it);
        } else {
            virtualFileResource = null;
        }
        return virtualFileResource;
    }

    @Override
    @NotNull
    public Ec4jPath getPath() {
        Ec4jPath ec4jPath = Ec4jPath.Ec4jPaths.of(this.file.getPath());
        Intrinsics.checkNotNullExpressionValue((Object)ec4jPath, (String)"of(file.path)");
        return ec4jPath;
    }

    @Override
    public boolean hasParent() {
        VirtualFile it = this.file.getParent();
        boolean bl = false;
        return it != null && it.exists();
    }

    @Override
    @NotNull
    public Resource relativize(@NotNull Resource resource) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        if (!(resource instanceof VirtualFileResource)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        String string = FileUtil.getRelativePath((String)this.file.getPath(), (String)((VirtualFileResource)resource).file.getPath(), (char)'/', (boolean)this.file.getFileSystem().isCaseSensitive());
        Intrinsics.checkNotNull((Object)string);
        return new PathHolderResource(string);
    }

    @Override
    @NotNull
    public Resource resolve(@NotNull String name) {
        Resource resource;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String[] stringArray = new String[]{name};
        VirtualFile virtualFile = VfsUtil.findRelativeFile((VirtualFile)this.file, (String[])stringArray);
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            resource = new VirtualFileResource(it);
        } else {
            resource = NonExistentVirtualFileResource.INSTANCE;
        }
        return resource;
    }

    @Override
    @NotNull
    public Resource.RandomReader openRandomReader() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Reader openReader() {
        InputStream inputStream = this.file.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"file.inputStream");
        InputStream inputStream2 = inputStream;
        Charset charset = this.file.getCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"file.charset");
        Charset charset2 = charset;
        Reader reader = new InputStreamReader(inputStream2, charset2);
        int n = 8192;
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
    }
}

