/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene95;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.KnnFieldVectorsWriter;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.codecs.lucene90.IndexedDISI;
import org.apache.lucene.codecs.lucene95.Lucene95HnswVectorsReader;
import org.apache.lucene.codecs.lucene95.OffHeapByteVectorValues;
import org.apache.lucene.codecs.lucene95.OffHeapFloatVectorValues;
import org.apache.lucene.codecs.perfield.PerFieldKnnVectorsFormat;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.DocsWithFieldSet;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.hnsw.HnswGraph;
import org.apache.lucene.util.hnsw.HnswGraphBuilder;
import org.apache.lucene.util.hnsw.NeighborArray;
import org.apache.lucene.util.hnsw.OnHeapHnswGraph;
import org.apache.lucene.util.hnsw.RandomAccessVectorValues;
import org.apache.lucene.util.packed.DirectMonotonicWriter;

public final class Lucene95HnswVectorsWriter
extends KnnVectorsWriter {
    private final SegmentWriteState segmentWriteState;
    private final IndexOutput meta;
    private final IndexOutput vectorData;
    private final IndexOutput vectorIndex;
    private final int M;
    private final int beamWidth;
    private final List<FieldWriter<?>> fields = new ArrayList();
    private boolean finished;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Lucene95HnswVectorsWriter(SegmentWriteState state, int M, int beamWidth) throws IOException {
        this.M = M;
        this.beamWidth = beamWidth;
        this.segmentWriteState = state;
        String metaFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "vem");
        String vectorDataFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "vec");
        String indexDataFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "vex");
        boolean success = false;
        try {
            this.meta = state.directory.createOutput(metaFileName, state.context);
            this.vectorData = state.directory.createOutput(vectorDataFileName, state.context);
            this.vectorIndex = state.directory.createOutput(indexDataFileName, state.context);
            CodecUtil.writeIndexHeader(this.meta, "Lucene95HnswVectorsFormatMeta", 0, state.segmentInfo.getId(), state.segmentSuffix);
            CodecUtil.writeIndexHeader(this.vectorData, "Lucene95HnswVectorsFormatData", 0, state.segmentInfo.getId(), state.segmentSuffix);
            CodecUtil.writeIndexHeader(this.vectorIndex, "Lucene95HnswVectorsFormatIndex", 0, state.segmentInfo.getId(), state.segmentSuffix);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
    }

    @Override
    public KnnFieldVectorsWriter<?> addField(FieldInfo fieldInfo) throws IOException {
        FieldWriter<?> newField = FieldWriter.create(fieldInfo, this.M, this.beamWidth, this.segmentWriteState.infoStream);
        this.fields.add(newField);
        return newField;
    }

    @Override
    public void flush(int maxDoc, Sorter.DocMap sortMap) throws IOException {
        for (FieldWriter<?> field : this.fields) {
            if (sortMap == null) {
                this.writeField(field, maxDoc);
                continue;
            }
            this.writeSortingField(field, maxDoc, sortMap);
        }
    }

    @Override
    public void finish() throws IOException {
        if (this.finished) {
            throw new IllegalStateException("already finished");
        }
        this.finished = true;
        if (this.meta != null) {
            this.meta.writeInt(-1);
            CodecUtil.writeFooter(this.meta);
        }
        if (this.vectorData != null) {
            CodecUtil.writeFooter(this.vectorData);
            CodecUtil.writeFooter(this.vectorIndex);
        }
    }

    @Override
    public long ramBytesUsed() {
        long total = 0L;
        for (FieldWriter<?> field : this.fields) {
            total += field.ramBytesUsed();
        }
        return total;
    }

    private void writeField(FieldWriter<?> fieldData, int maxDoc) throws IOException {
        long vectorDataOffset = this.vectorData.alignFilePointer(4);
        switch (fieldData.fieldInfo.getVectorEncoding()) {
            case BYTE: {
                this.writeByteVectors(fieldData);
                break;
            }
            case FLOAT32: {
                this.writeFloat32Vectors(fieldData);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        long vectorDataLength = this.vectorData.getFilePointer() - vectorDataOffset;
        long vectorIndexOffset = this.vectorIndex.getFilePointer();
        OnHeapHnswGraph graph = fieldData.getGraph();
        int[][] graphLevelNodeOffsets = this.writeGraph(graph);
        long vectorIndexLength = this.vectorIndex.getFilePointer() - vectorIndexOffset;
        this.writeMeta(fieldData.fieldInfo, maxDoc, vectorDataOffset, vectorDataLength, vectorIndexOffset, vectorIndexLength, fieldData.docsWithField, graph, graphLevelNodeOffsets);
    }

    private void writeFloat32Vectors(FieldWriter<?> fieldData) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(fieldData.dim * 4).order(ByteOrder.LITTLE_ENDIAN);
        for (Object v : fieldData.vectors) {
            buffer.asFloatBuffer().put((float[])v);
            this.vectorData.writeBytes(buffer.array(), buffer.array().length);
        }
    }

    private void writeByteVectors(FieldWriter<?> fieldData) throws IOException {
        for (Object v : fieldData.vectors) {
            byte[] vector = (byte[])v;
            this.vectorData.writeBytes(vector, vector.length);
        }
    }

    private void writeSortingField(FieldWriter<?> fieldData, int maxDoc, Sorter.DocMap sortMap) throws IOException {
        long vectorDataOffset;
        int[] docIdOffsets = new int[sortMap.size()];
        int offset = 1;
        DocIdSetIterator iterator = fieldData.docsWithField.iterator();
        int docID = iterator.nextDoc();
        while (docID != Integer.MAX_VALUE) {
            int newDocID = sortMap.oldToNew(docID);
            docIdOffsets[newDocID] = offset++;
            docID = iterator.nextDoc();
        }
        DocsWithFieldSet newDocsWithField = new DocsWithFieldSet();
        int[] ordMap = new int[offset - 1];
        int[] oldOrdMap = new int[offset - 1];
        int ord = 0;
        int doc = 0;
        for (int docIdOffset : docIdOffsets) {
            if (docIdOffset != 0) {
                ordMap[ord] = docIdOffset - 1;
                oldOrdMap[docIdOffset - 1] = ord++;
                newDocsWithField.add(doc);
            }
            ++doc;
        }
        switch (fieldData.fieldInfo.getVectorEncoding()) {
            case BYTE: {
                vectorDataOffset = this.writeSortedByteVectors(fieldData, ordMap);
                break;
            }
            case FLOAT32: {
                vectorDataOffset = this.writeSortedFloat32Vectors(fieldData, ordMap);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        long vectorDataLength = this.vectorData.getFilePointer() - vectorDataOffset;
        long vectorIndexOffset = this.vectorIndex.getFilePointer();
        OnHeapHnswGraph graph = fieldData.getGraph();
        int[][] graphLevelNodeOffsets = graph == null ? new int[][]{} : new int[graph.numLevels()][];
        HnswGraph mockGraph = this.reconstructAndWriteGraph(graph, ordMap, oldOrdMap, graphLevelNodeOffsets);
        long vectorIndexLength = this.vectorIndex.getFilePointer() - vectorIndexOffset;
        this.writeMeta(fieldData.fieldInfo, maxDoc, vectorDataOffset, vectorDataLength, vectorIndexOffset, vectorIndexLength, newDocsWithField, mockGraph, graphLevelNodeOffsets);
    }

    private long writeSortedFloat32Vectors(FieldWriter<?> fieldData, int[] ordMap) throws IOException {
        long vectorDataOffset = this.vectorData.alignFilePointer(4);
        ByteBuffer buffer = ByteBuffer.allocate(fieldData.dim * 4).order(ByteOrder.LITTLE_ENDIAN);
        for (int ordinal : ordMap) {
            float[] vector = (float[])fieldData.vectors.get(ordinal);
            buffer.asFloatBuffer().put(vector);
            this.vectorData.writeBytes(buffer.array(), buffer.array().length);
        }
        return vectorDataOffset;
    }

    private long writeSortedByteVectors(FieldWriter<?> fieldData, int[] ordMap) throws IOException {
        long vectorDataOffset = this.vectorData.alignFilePointer(4);
        for (int ordinal : ordMap) {
            byte[] vector = (byte[])fieldData.vectors.get(ordinal);
            this.vectorData.writeBytes(vector, vector.length);
        }
        return vectorDataOffset;
    }

    private HnswGraph reconstructAndWriteGraph(final OnHeapHnswGraph graph, int[] newToOldMap, int[] oldToNewMap, int[][] levelNodeOffsets) throws IOException {
        if (graph == null) {
            return null;
        }
        final ArrayList<int[]> nodesByLevel = new ArrayList<int[]>(graph.numLevels());
        nodesByLevel.add(null);
        int maxOrd = graph.size();
        int maxConnOnLevel = this.M * 2;
        HnswGraph.NodesIterator nodesOnLevel0 = graph.getNodesOnLevel(0);
        levelNodeOffsets[0] = new int[nodesOnLevel0.size()];
        while (nodesOnLevel0.hasNext()) {
            int node = nodesOnLevel0.nextInt();
            NeighborArray neighbors = graph.getNeighbors(0, newToOldMap[node]);
            long offset = this.vectorIndex.getFilePointer();
            this.reconstructAndWriteNeigbours(neighbors, oldToNewMap, maxConnOnLevel, maxOrd);
            levelNodeOffsets[0][node] = Math.toIntExact(this.vectorIndex.getFilePointer() - offset);
        }
        maxConnOnLevel = this.M;
        for (int level = 1; level < graph.numLevels(); ++level) {
            HnswGraph.NodesIterator nodesOnLevel = graph.getNodesOnLevel(level);
            int[] newNodes = new int[nodesOnLevel.size()];
            int n = 0;
            while (nodesOnLevel.hasNext()) {
                newNodes[n++] = oldToNewMap[nodesOnLevel.nextInt()];
            }
            Arrays.sort(newNodes);
            nodesByLevel.add(newNodes);
            levelNodeOffsets[level] = new int[newNodes.length];
            int nodeOffsetIndex = 0;
            for (int node : newNodes) {
                NeighborArray neighbors = graph.getNeighbors(level, newToOldMap[node]);
                long offset = this.vectorIndex.getFilePointer();
                this.reconstructAndWriteNeigbours(neighbors, oldToNewMap, maxConnOnLevel, maxOrd);
                levelNodeOffsets[level][nodeOffsetIndex++] = Math.toIntExact(this.vectorIndex.getFilePointer() - offset);
            }
        }
        return new HnswGraph(){

            @Override
            public int nextNeighbor() {
                throw new UnsupportedOperationException("Not supported on a mock graph");
            }

            @Override
            public void seek(int level, int target) {
                throw new UnsupportedOperationException("Not supported on a mock graph");
            }

            @Override
            public int size() {
                return graph.size();
            }

            @Override
            public int numLevels() {
                return graph.numLevels();
            }

            @Override
            public int entryNode() {
                throw new UnsupportedOperationException("Not supported on a mock graph");
            }

            @Override
            public HnswGraph.NodesIterator getNodesOnLevel(int level) {
                if (level == 0) {
                    return graph.getNodesOnLevel(0);
                }
                return new HnswGraph.ArrayNodesIterator((int[])nodesByLevel.get(level), ((int[])nodesByLevel.get(level)).length);
            }
        };
    }

    private void reconstructAndWriteNeigbours(NeighborArray neighbors, int[] oldToNewMap, int maxConnOnLevel, int maxOrd) throws IOException {
        int i;
        int size = neighbors.size();
        this.vectorIndex.writeVInt(size);
        int[] nnodes = neighbors.node();
        for (i = 0; i < size; ++i) {
            nnodes[i] = oldToNewMap[nnodes[i]];
        }
        Arrays.sort(nnodes, 0, size);
        for (i = size - 1; i > 0; --i) {
            assert (nnodes[i] < maxOrd) : "node too large: " + nnodes[i] + ">=" + maxOrd;
            int n = i;
            nnodes[n] = nnodes[n] - nnodes[i - 1];
        }
        for (i = 0; i < size; ++i) {
            this.vectorIndex.writeVInt(nnodes[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mergeOneField(FieldInfo fieldInfo, MergeState mergeState) throws IOException {
        long vectorDataOffset = this.vectorData.alignFilePointer(4);
        IndexOutput tempVectorData = this.segmentWriteState.directory.createTempOutput(this.vectorData.getName(), "temp", this.segmentWriteState.context);
        IndexInput vectorDataInput = null;
        boolean success = false;
        try {
            DocsWithFieldSet docsWithField;
            switch (fieldInfo.getVectorEncoding()) {
                case BYTE: {
                    docsWithField = Lucene95HnswVectorsWriter.writeByteVectorData(tempVectorData, KnnVectorsWriter.MergedVectorValues.mergeByteVectorValues(fieldInfo, mergeState));
                    break;
                }
                case FLOAT32: {
                    docsWithField = Lucene95HnswVectorsWriter.writeVectorData(tempVectorData, KnnVectorsWriter.MergedVectorValues.mergeFloatVectorValues(fieldInfo, mergeState));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown vector encoding=" + fieldInfo.getVectorEncoding());
                }
            }
            CodecUtil.writeFooter(tempVectorData);
            IOUtils.close(tempVectorData);
            vectorDataInput = this.segmentWriteState.directory.openInput(tempVectorData.getName(), this.segmentWriteState.context);
            this.vectorData.copyBytes(vectorDataInput, vectorDataInput.length() - (long)CodecUtil.footerLength());
            CodecUtil.retrieveChecksum(vectorDataInput);
            long vectorDataLength = this.vectorData.getFilePointer() - vectorDataOffset;
            long vectorIndexOffset = this.vectorIndex.getFilePointer();
            int byteSize = fieldInfo.getVectorDimension() * fieldInfo.getVectorEncoding().byteSize;
            OnHeapHnswGraph graph = null;
            int[][] vectorIndexNodeOffsets = null;
            if (docsWithField.cardinality() != 0) {
                int initializerIndex = this.selectGraphForInitialization(mergeState, fieldInfo);
                switch (fieldInfo.getVectorEncoding()) {
                    case BYTE: {
                        OffHeapByteVectorValues.DenseOffHeapVectorValues byteVectorValues = new OffHeapByteVectorValues.DenseOffHeapVectorValues(fieldInfo.getVectorDimension(), docsWithField.cardinality(), vectorDataInput, byteSize);
                        HnswGraphBuilder<byte[]> bytesRefHnswGraphBuilder = this.createHnswGraphBuilder(mergeState, fieldInfo, byteVectorValues, initializerIndex);
                        bytesRefHnswGraphBuilder.setInfoStream(this.segmentWriteState.infoStream);
                        graph = bytesRefHnswGraphBuilder.build(byteVectorValues.copy());
                        break;
                    }
                    case FLOAT32: {
                        OffHeapFloatVectorValues.DenseOffHeapVectorValues vectorValues = new OffHeapFloatVectorValues.DenseOffHeapVectorValues(fieldInfo.getVectorDimension(), docsWithField.cardinality(), vectorDataInput, byteSize);
                        HnswGraphBuilder<float[]> hnswGraphBuilder = this.createHnswGraphBuilder(mergeState, fieldInfo, vectorValues, initializerIndex);
                        hnswGraphBuilder.setInfoStream(this.segmentWriteState.infoStream);
                        graph = hnswGraphBuilder.build(vectorValues.copy());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown vector encoding=" + fieldInfo.getVectorEncoding());
                    }
                }
                vectorIndexNodeOffsets = this.writeGraph(graph);
            }
            long vectorIndexLength = this.vectorIndex.getFilePointer() - vectorIndexOffset;
            this.writeMeta(fieldInfo, this.segmentWriteState.segmentInfo.maxDoc(), vectorDataOffset, vectorDataLength, vectorIndexOffset, vectorIndexLength, docsWithField, graph, vectorIndexNodeOffsets);
            success = true;
        }
        catch (Throwable throwable) {
            IOUtils.close(vectorDataInput);
            if (success) {
                this.segmentWriteState.directory.deleteFile(tempVectorData.getName());
            } else {
                IOUtils.closeWhileHandlingException(tempVectorData);
                IOUtils.deleteFilesIgnoringExceptions(this.segmentWriteState.directory, tempVectorData.getName());
            }
            throw throwable;
        }
        IOUtils.close(vectorDataInput);
        if (success) {
            this.segmentWriteState.directory.deleteFile(tempVectorData.getName());
        } else {
            IOUtils.closeWhileHandlingException(tempVectorData);
            IOUtils.deleteFilesIgnoringExceptions(this.segmentWriteState.directory, tempVectorData.getName());
        }
    }

    private <T> HnswGraphBuilder<T> createHnswGraphBuilder(MergeState mergeState, FieldInfo fieldInfo, RandomAccessVectorValues<T> floatVectorValues, int initializerIndex) throws IOException {
        if (initializerIndex == -1) {
            return HnswGraphBuilder.create(floatVectorValues, fieldInfo.getVectorEncoding(), fieldInfo.getVectorSimilarityFunction(), this.M, this.beamWidth, HnswGraphBuilder.randSeed);
        }
        HnswGraph initializerGraph = this.getHnswGraphFromReader(fieldInfo.name, mergeState.knnVectorsReaders[initializerIndex]);
        Map<Integer, Integer> ordinalMapper = this.getOldToNewOrdinalMap(mergeState, fieldInfo, initializerIndex);
        return HnswGraphBuilder.create(floatVectorValues, fieldInfo.getVectorEncoding(), fieldInfo.getVectorSimilarityFunction(), this.M, this.beamWidth, HnswGraphBuilder.randSeed, initializerGraph, ordinalMapper);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int selectGraphForInitialization(MergeState mergeState, FieldInfo fieldInfo) throws IOException {
        int maxCandidateVectorCount = 0;
        int initializerIndex = -1;
        int i = 0;
        while (true) {
            block9: {
                KnnVectorsReader candidateReader;
                if (i >= mergeState.liveDocs.length) {
                    return initializerIndex;
                }
                KnnVectorsReader currKnnVectorsReader = mergeState.knnVectorsReaders[i];
                if (mergeState.knnVectorsReaders[i] instanceof PerFieldKnnVectorsFormat.FieldsReader) {
                    candidateReader = (PerFieldKnnVectorsFormat.FieldsReader)mergeState.knnVectorsReaders[i];
                    currKnnVectorsReader = ((PerFieldKnnVectorsFormat.FieldsReader)candidateReader).getFieldReader(fieldInfo.name);
                }
                if (!this.allMatch(mergeState.liveDocs[i]) || !(currKnnVectorsReader instanceof Lucene95HnswVectorsReader)) break block9;
                candidateReader = (Lucene95HnswVectorsReader)currKnnVectorsReader;
                int candidateVectorCount = 0;
                switch (fieldInfo.getVectorEncoding()) {
                    case BYTE: {
                        ByteVectorValues byteVectorValues = ((Lucene95HnswVectorsReader)candidateReader).getByteVectorValues(fieldInfo.name);
                        if (byteVectorValues != null) {
                            candidateVectorCount = byteVectorValues.size();
                            break;
                        }
                        break block9;
                    }
                    case FLOAT32: {
                        FloatVectorValues vectorValues = ((Lucene95HnswVectorsReader)candidateReader).getFloatVectorValues(fieldInfo.name);
                        if (vectorValues == null) break block9;
                        candidateVectorCount = vectorValues.size();
                    }
                }
                if (candidateVectorCount > maxCandidateVectorCount) {
                    maxCandidateVectorCount = candidateVectorCount;
                    initializerIndex = i;
                }
            }
            ++i;
        }
    }

    private HnswGraph getHnswGraphFromReader(String fieldName, KnnVectorsReader knnVectorsReader) throws IOException {
        PerFieldKnnVectorsFormat.FieldsReader perFieldReader;
        if (knnVectorsReader instanceof PerFieldKnnVectorsFormat.FieldsReader && (perFieldReader = (PerFieldKnnVectorsFormat.FieldsReader)knnVectorsReader).getFieldReader(fieldName) instanceof Lucene95HnswVectorsReader) {
            Lucene95HnswVectorsReader fieldReader = (Lucene95HnswVectorsReader)perFieldReader.getFieldReader(fieldName);
            return fieldReader.getGraph(fieldName);
        }
        if (knnVectorsReader instanceof Lucene95HnswVectorsReader) {
            return ((Lucene95HnswVectorsReader)knnVectorsReader).getGraph(fieldName);
        }
        throw new IllegalArgumentException("Invalid KnnVectorsReader type for field: " + fieldName + ". Must be Lucene95HnswVectorsReader or newer");
    }

    private Map<Integer, Integer> getOldToNewOrdinalMap(MergeState mergeState, FieldInfo fieldInfo, int initializerIndex) throws IOException {
        DocIdSetIterator initializerIterator = null;
        switch (fieldInfo.getVectorEncoding()) {
            case BYTE: {
                initializerIterator = mergeState.knnVectorsReaders[initializerIndex].getByteVectorValues(fieldInfo.name);
                break;
            }
            case FLOAT32: {
                initializerIterator = mergeState.knnVectorsReaders[initializerIndex].getFloatVectorValues(fieldInfo.name);
            }
        }
        MergeState.DocMap initializerDocMap = mergeState.docMaps[initializerIndex];
        HashMap<Integer, Integer> newIdToOldOrdinal = new HashMap<Integer, Integer>();
        int oldOrd = 0;
        int maxNewDocID = -1;
        int oldId = initializerIterator.nextDoc();
        while (oldId != Integer.MAX_VALUE) {
            if (!this.isCurrentVectorNull(initializerIterator)) {
                int newId = initializerDocMap.get(oldId);
                maxNewDocID = Math.max(newId, maxNewDocID);
                newIdToOldOrdinal.put(newId, oldOrd);
                ++oldOrd;
            }
            oldId = initializerIterator.nextDoc();
        }
        if (maxNewDocID == -1) {
            return Collections.emptyMap();
        }
        HashMap<Integer, Integer> oldToNewOrdinalMap = new HashMap<Integer, Integer>();
        DocIdSetIterator vectorIterator = null;
        switch (fieldInfo.getVectorEncoding()) {
            case BYTE: {
                vectorIterator = KnnVectorsWriter.MergedVectorValues.mergeByteVectorValues(fieldInfo, mergeState);
                break;
            }
            case FLOAT32: {
                vectorIterator = KnnVectorsWriter.MergedVectorValues.mergeFloatVectorValues(fieldInfo, mergeState);
            }
        }
        int newOrd = 0;
        int newDocId = vectorIterator.nextDoc();
        while (newDocId <= maxNewDocID) {
            if (!this.isCurrentVectorNull(vectorIterator)) {
                if (newIdToOldOrdinal.containsKey(newDocId)) {
                    oldToNewOrdinalMap.put((Integer)newIdToOldOrdinal.get(newDocId), newOrd);
                }
                ++newOrd;
            }
            newDocId = vectorIterator.nextDoc();
        }
        return oldToNewOrdinalMap;
    }

    private boolean isCurrentVectorNull(DocIdSetIterator docIdSetIterator) throws IOException {
        if (docIdSetIterator instanceof FloatVectorValues) {
            return ((FloatVectorValues)docIdSetIterator).vectorValue() == null;
        }
        if (docIdSetIterator instanceof ByteVectorValues) {
            return ((ByteVectorValues)docIdSetIterator).vectorValue() == null;
        }
        return true;
    }

    private boolean allMatch(Bits bits) {
        if (bits == null) {
            return true;
        }
        for (int i = 0; i < bits.length(); ++i) {
            if (bits.get(i)) continue;
            return false;
        }
        return true;
    }

    private int[][] writeGraph(OnHeapHnswGraph graph) throws IOException {
        if (graph == null) {
            return new int[0][0];
        }
        int countOnLevel0 = graph.size();
        int[][] offsets = new int[graph.numLevels()][];
        for (int level = 0; level < graph.numLevels(); ++level) {
            HnswGraph.NodesIterator nodesOnLevel = graph.getNodesOnLevel(level);
            offsets[level] = new int[nodesOnLevel.size()];
            int nodeOffsetId = 0;
            while (nodesOnLevel.hasNext()) {
                int i;
                int node = nodesOnLevel.nextInt();
                NeighborArray neighbors = graph.getNeighbors(level, node);
                int size = neighbors.size();
                long offsetStart = this.vectorIndex.getFilePointer();
                this.vectorIndex.writeVInt(size);
                int[] nnodes = neighbors.node();
                Arrays.sort(nnodes, 0, size);
                for (i = size - 1; i > 0; --i) {
                    assert (nnodes[i] < countOnLevel0) : "node too large: " + nnodes[i] + ">=" + countOnLevel0;
                    int n = i;
                    nnodes[n] = nnodes[n] - nnodes[i - 1];
                }
                for (i = 0; i < size; ++i) {
                    this.vectorIndex.writeVInt(nnodes[i]);
                }
                offsets[level][nodeOffsetId++] = Math.toIntExact(this.vectorIndex.getFilePointer() - offsetStart);
            }
        }
        return offsets;
    }

    private void writeMeta(FieldInfo field, int maxDoc, long vectorDataOffset, long vectorDataLength, long vectorIndexOffset, long vectorIndexLength, DocsWithFieldSet docsWithField, HnswGraph graph, int[][] graphLevelNodeOffsets) throws IOException {
        this.meta.writeInt(field.number);
        this.meta.writeInt(field.getVectorEncoding().ordinal());
        this.meta.writeInt(field.getVectorSimilarityFunction().ordinal());
        this.meta.writeVLong(vectorDataOffset);
        this.meta.writeVLong(vectorDataLength);
        this.meta.writeVLong(vectorIndexOffset);
        this.meta.writeVLong(vectorIndexLength);
        this.meta.writeVInt(field.getVectorDimension());
        int count = docsWithField.cardinality();
        this.meta.writeInt(count);
        if (count == 0) {
            this.meta.writeLong(-2L);
            this.meta.writeLong(0L);
            this.meta.writeShort((short)-1);
            this.meta.writeByte((byte)-1);
        } else if (count == maxDoc) {
            this.meta.writeLong(-1L);
            this.meta.writeLong(0L);
            this.meta.writeShort((short)-1);
            this.meta.writeByte((byte)-1);
        } else {
            long offset = this.vectorData.getFilePointer();
            this.meta.writeLong(offset);
            short jumpTableEntryCount = IndexedDISI.writeBitSet(docsWithField.iterator(), this.vectorData, (byte)9);
            this.meta.writeLong(this.vectorData.getFilePointer() - offset);
            this.meta.writeShort(jumpTableEntryCount);
            this.meta.writeByte((byte)9);
            long start = this.vectorData.getFilePointer();
            this.meta.writeLong(start);
            this.meta.writeVInt(16);
            DirectMonotonicWriter ordToDocWriter = DirectMonotonicWriter.getInstance(this.meta, this.vectorData, count, 16);
            DocIdSetIterator iterator = docsWithField.iterator();
            int doc = iterator.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                ordToDocWriter.add(doc);
                doc = iterator.nextDoc();
            }
            ordToDocWriter.finish();
            this.meta.writeLong(this.vectorData.getFilePointer() - start);
        }
        this.meta.writeVInt(this.M);
        if (graph == null) {
            this.meta.writeVInt(0);
        } else {
            this.meta.writeVInt(graph.numLevels());
            long valueCount = 0L;
            for (int level = 0; level < graph.numLevels(); ++level) {
                HnswGraph.NodesIterator nodesOnLevel = graph.getNodesOnLevel(level);
                valueCount += (long)nodesOnLevel.size();
                if (level > 0) {
                    int[] nol = new int[nodesOnLevel.size()];
                    int numberConsumed = nodesOnLevel.consume(nol);
                    assert (numberConsumed == nodesOnLevel.size());
                    this.meta.writeVInt(nol.length);
                    for (int i = nodesOnLevel.size() - 1; i > 0; --i) {
                        int n = i;
                        nol[n] = nol[n] - nol[i - 1];
                    }
                    for (int n : nol) {
                        assert (n >= 0) : "delta encoding for nodes failed; expected nodes to be sorted";
                        this.meta.writeVInt(n);
                    }
                    continue;
                }
                assert (nodesOnLevel.size() == count) : "Level 0 expects to have all nodes";
            }
            long start = this.vectorIndex.getFilePointer();
            this.meta.writeLong(start);
            this.meta.writeVInt(16);
            DirectMonotonicWriter memoryOffsetsWriter = DirectMonotonicWriter.getInstance(this.meta, this.vectorIndex, valueCount, 16);
            long cumulativeOffsetSum = 0L;
            int[][] nArray = graphLevelNodeOffsets;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int[] levelOffsets;
                for (int v : levelOffsets = nArray[i]) {
                    memoryOffsetsWriter.add(cumulativeOffsetSum);
                    cumulativeOffsetSum += (long)v;
                }
            }
            memoryOffsetsWriter.finish();
            this.meta.writeLong(this.vectorIndex.getFilePointer() - start);
        }
    }

    private static DocsWithFieldSet writeByteVectorData(IndexOutput output2, ByteVectorValues byteVectorValues) throws IOException {
        DocsWithFieldSet docsWithField = new DocsWithFieldSet();
        int docV = byteVectorValues.nextDoc();
        while (docV != Integer.MAX_VALUE) {
            byte[] binaryValue = byteVectorValues.vectorValue();
            assert (binaryValue.length == byteVectorValues.dimension() * VectorEncoding.BYTE.byteSize);
            output2.writeBytes(binaryValue, binaryValue.length);
            docsWithField.add(docV);
            docV = byteVectorValues.nextDoc();
        }
        return docsWithField;
    }

    private static DocsWithFieldSet writeVectorData(IndexOutput output2, FloatVectorValues floatVectorValues) throws IOException {
        DocsWithFieldSet docsWithField = new DocsWithFieldSet();
        ByteBuffer buffer = ByteBuffer.allocate(floatVectorValues.dimension() * VectorEncoding.FLOAT32.byteSize).order(ByteOrder.LITTLE_ENDIAN);
        int docV = floatVectorValues.nextDoc();
        while (docV != Integer.MAX_VALUE) {
            float[] value = floatVectorValues.vectorValue();
            buffer.asFloatBuffer().put(value);
            output2.writeBytes(buffer.array(), buffer.limit());
            docsWithField.add(docV);
            docV = floatVectorValues.nextDoc();
        }
        return docsWithField;
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.meta, this.vectorData, this.vectorIndex);
    }

    private static class RAVectorValues<T>
    implements RandomAccessVectorValues<T> {
        private final List<T> vectors;
        private final int dim;

        RAVectorValues(List<T> vectors, int dim) {
            this.vectors = vectors;
            this.dim = dim;
        }

        @Override
        public int size() {
            return this.vectors.size();
        }

        @Override
        public int dimension() {
            return this.dim;
        }

        @Override
        public T vectorValue(int targetOrd) throws IOException {
            return this.vectors.get(targetOrd);
        }

        @Override
        public RandomAccessVectorValues<T> copy() throws IOException {
            return this;
        }
    }

    private static abstract class FieldWriter<T>
    extends KnnFieldVectorsWriter<T> {
        private final FieldInfo fieldInfo;
        private final int dim;
        private final DocsWithFieldSet docsWithField;
        private final List<T> vectors;
        private final HnswGraphBuilder<T> hnswGraphBuilder;
        private int lastDocID = -1;
        private int node = 0;

        static FieldWriter<?> create(FieldInfo fieldInfo, int M, int beamWidth, InfoStream infoStream) throws IOException {
            final int dim = fieldInfo.getVectorDimension();
            switch (fieldInfo.getVectorEncoding()) {
                case BYTE: {
                    return new FieldWriter<byte[]>(fieldInfo, M, beamWidth, infoStream){

                        @Override
                        public byte[] copyValue(byte[] value) {
                            return ArrayUtil.copyOfSubArray(value, 0, dim);
                        }
                    };
                }
                case FLOAT32: {
                    return new FieldWriter<float[]>(fieldInfo, M, beamWidth, infoStream){

                        @Override
                        public float[] copyValue(float[] value) {
                            return ArrayUtil.copyOfSubArray(value, 0, dim);
                        }
                    };
                }
            }
            throw new AssertionError();
        }

        FieldWriter(FieldInfo fieldInfo, int M, int beamWidth, InfoStream infoStream) throws IOException {
            this.fieldInfo = fieldInfo;
            this.dim = fieldInfo.getVectorDimension();
            this.docsWithField = new DocsWithFieldSet();
            this.vectors = new ArrayList<T>();
            this.hnswGraphBuilder = HnswGraphBuilder.create(new RAVectorValues<T>(this.vectors, this.dim), fieldInfo.getVectorEncoding(), fieldInfo.getVectorSimilarityFunction(), M, beamWidth, HnswGraphBuilder.randSeed);
            this.hnswGraphBuilder.setInfoStream(infoStream);
        }

        @Override
        public void addValue(int docID, T vectorValue) throws IOException {
            if (docID == this.lastDocID) {
                throw new IllegalArgumentException("VectorValuesField \"" + this.fieldInfo.name + "\" appears more than once in this document (only one value is allowed per field)");
            }
            assert (docID > this.lastDocID);
            this.docsWithField.add(docID);
            this.vectors.add(this.copyValue(vectorValue));
            this.hnswGraphBuilder.addGraphNode(this.node, vectorValue);
            ++this.node;
            this.lastDocID = docID;
        }

        OnHeapHnswGraph getGraph() {
            if (this.vectors.size() > 0) {
                return this.hnswGraphBuilder.getGraph();
            }
            return null;
        }

        @Override
        public long ramBytesUsed() {
            if (this.vectors.size() == 0) {
                return 0L;
            }
            return this.docsWithField.ramBytesUsed() + (long)this.vectors.size() * (long)(RamUsageEstimator.NUM_BYTES_OBJECT_REF + RamUsageEstimator.NUM_BYTES_ARRAY_HEADER) + (long)this.vectors.size() * (long)this.fieldInfo.getVectorDimension() * (long)this.fieldInfo.getVectorEncoding().byteSize + this.hnswGraphBuilder.getGraph().ramBytesUsed();
        }
    }
}

