/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene90;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.SegmentInfoFormat;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexSorter;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SortFieldProvider;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.Version;

public class Lucene90SegmentInfoFormat
extends SegmentInfoFormat {
    public static final String SI_EXTENSION = "si";
    static final String CODEC_NAME = "Lucene90SegmentInfo";
    static final int VERSION_START = 0;
    static final int VERSION_CURRENT = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SegmentInfo read(Directory dir, String segment, byte[] segmentID, IOContext context) throws IOException {
        String fileName = IndexFileNames.segmentFileName(segment, "", SI_EXTENSION);
        try (ChecksumIndexInput input = dir.openChecksumInput(fileName, context);){
            Throwable priorE = null;
            SegmentInfo si = null;
            try {
                CodecUtil.checkIndexHeader(input, CODEC_NAME, 0, 0, segmentID, "");
                si = this.parseSegmentInfo(dir, input, segment, segmentID);
            }
            catch (Throwable exception) {
                priorE = exception;
            }
            finally {
                CodecUtil.checkFooter(input, priorE);
            }
            SegmentInfo segmentInfo = si;
            return segmentInfo;
        }
    }

    private SegmentInfo parseSegmentInfo(Directory dir, DataInput input, String segment, byte[] segmentID) throws IOException {
        Sort indexSort;
        Version minVersion;
        Version version = Version.fromBits(input.readInt(), input.readInt(), input.readInt());
        byte hasMinVersion = input.readByte();
        switch (hasMinVersion) {
            case 0: {
                minVersion = null;
                break;
            }
            case 1: {
                minVersion = Version.fromBits(input.readInt(), input.readInt(), input.readInt());
                break;
            }
            default: {
                throw new CorruptIndexException("Illegal boolean value " + hasMinVersion, input);
            }
        }
        int docCount = input.readInt();
        if (docCount < 0) {
            throw new CorruptIndexException("invalid docCount: " + docCount, input);
        }
        boolean isCompoundFile = input.readByte() == 1;
        Map<String, String> diagnostics = input.readMapOfStrings();
        Set<String> files = input.readSetOfStrings();
        Map<String, String> attributes = input.readMapOfStrings();
        int numSortFields = input.readVInt();
        if (numSortFields > 0) {
            SortField[] sortFields = new SortField[numSortFields];
            for (int i = 0; i < numSortFields; ++i) {
                String name = input.readString();
                sortFields[i] = SortFieldProvider.forName(name).readSortField(input);
            }
            indexSort = new Sort(sortFields);
        } else {
            if (numSortFields < 0) {
                throw new CorruptIndexException("invalid index sort field count: " + numSortFields, input);
            }
            indexSort = null;
        }
        SegmentInfo si = new SegmentInfo(dir, version, minVersion, segment, docCount, isCompoundFile, null, diagnostics, segmentID, attributes, indexSort);
        si.setFiles(files);
        return si;
    }

    @Override
    public void write(Directory dir, SegmentInfo si, IOContext ioContext) throws IOException {
        String fileName = IndexFileNames.segmentFileName(si.name, "", SI_EXTENSION);
        try (IndexOutput output2 = dir.createOutput(fileName, ioContext);){
            si.addFile(fileName);
            CodecUtil.writeIndexHeader(output2, CODEC_NAME, 0, si.getId(), "");
            this.writeSegmentInfo(output2, si);
            CodecUtil.writeFooter(output2);
        }
    }

    private void writeSegmentInfo(DataOutput output2, SegmentInfo si) throws IOException {
        Version version = si.getVersion();
        if (version.major < 7) {
            throw new IllegalArgumentException("invalid major version: should be >= 7 but got: " + version.major + " segment=" + si);
        }
        output2.writeInt(version.major);
        output2.writeInt(version.minor);
        output2.writeInt(version.bugfix);
        if (si.getMinVersion() != null) {
            output2.writeByte((byte)1);
            Version minVersion = si.getMinVersion();
            output2.writeInt(minVersion.major);
            output2.writeInt(minVersion.minor);
            output2.writeInt(minVersion.bugfix);
        } else {
            output2.writeByte((byte)0);
        }
        assert (version.prerelease == 0);
        output2.writeInt(si.maxDoc());
        output2.writeByte((byte)(si.getUseCompoundFile() ? 1 : -1));
        output2.writeMapOfStrings(si.getDiagnostics());
        Set<String> files = si.files();
        for (String file : files) {
            if (IndexFileNames.parseSegmentName(file).equals(si.name)) continue;
            throw new IllegalArgumentException("invalid files: expected segment=" + si.name + ", got=" + files);
        }
        output2.writeSetOfStrings(files);
        output2.writeMapOfStrings(si.getAttributes());
        Sort indexSort = si.getIndexSort();
        int numSortFields = indexSort == null ? 0 : indexSort.getSort().length;
        output2.writeVInt(numSortFields);
        for (int i = 0; i < numSortFields; ++i) {
            SortField sortField = indexSort.getSort()[i];
            IndexSorter sorter = sortField.getIndexSorter();
            if (sorter == null) {
                throw new IllegalArgumentException("cannot serialize SortField " + sortField);
            }
            output2.writeString(sorter.getProviderName());
            SortFieldProvider.write(sortField, output2);
        }
    }
}

