/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.guava;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.guava.Cancelled;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0016J\u0013\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0017J\u000e\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001aJ\r\u0010\u001b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001cJ\u001e\u0010\u001b\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0096\u0002\u00a2\u0006\u0002\u0010!J\u0017\u0010\"\u001a\u00028\u00002\b\u0010\u0016\u001a\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0002\u0010#J\b\u0010$\u001a\u00020\u000bH\u0016J\b\u0010%\u001a\u00020\u000bH\u0016J\b\u0010&\u001a\u00020'H\u0016R&\u0010\u0006\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u00010\b \t*\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lkotlinx/coroutines/guava/JobListenableFuture;", "T", "Lcom/google/common/util/concurrent/ListenableFuture;", "jobToCancel", "Lkotlinx/coroutines/Job;", "(Lkotlinx/coroutines/Job;)V", "auxFuture", "Lcom/google/common/util/concurrent/SettableFuture;", "", "kotlin.jvm.PlatformType", "auxFutureIsFailed", "", "addListener", "", "listener", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "executor", "Ljava/util/concurrent/Executor;", "cancel", "mayInterruptIfRunning", "complete", "result", "(Ljava/lang/Object;)Z", "completeExceptionallyOrCancel", "t", "", "get", "()Ljava/lang/Object;", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "(JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", "getInternal", "(Ljava/lang/Object;)Ljava/lang/Object;", "isCancelled", "isDone", "toString", "", "kotlinx-coroutines-guava"})
@SourceDebugExtension(value={"SMAP\nListenableFuture.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ListenableFuture.kt\nkotlinx/coroutines/guava/JobListenableFuture\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,509:1\n1#2:510\n*E\n"})
final class JobListenableFuture<T>
implements ListenableFuture<T> {
    @NotNull
    private final Job jobToCancel;
    private final SettableFuture<Object> auxFuture;
    private boolean auxFutureIsFailed;

    public JobListenableFuture(@NotNull Job jobToCancel) {
        this.jobToCancel = jobToCancel;
        this.auxFuture = SettableFuture.create();
    }

    public final boolean complete(T result) {
        return this.auxFuture.set(result);
    }

    public final boolean completeExceptionallyOrCancel(@NotNull Throwable t) {
        boolean bl;
        if (t instanceof CancellationException) {
            bl = this.auxFuture.set((Object)new Cancelled((CancellationException)t));
        } else {
            boolean bl2;
            boolean it = bl2 = this.auxFuture.setException(t);
            boolean bl3 = false;
            if (it) {
                this.auxFutureIsFailed = true;
            }
            bl = bl2;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isCancelled() {
        boolean bl;
        if (this.auxFuture.isCancelled()) return true;
        if (!this.isDone()) return false;
        if (this.auxFutureIsFailed) return false;
        try {
            bl = Uninterruptibles.getUninterruptibly((Future)((Future)this.auxFuture)) instanceof Cancelled;
        }
        catch (CancellationException e) {
            return true;
        }
        catch (ExecutionException e) {
            this.auxFutureIsFailed = true;
            return false;
        }
        if (!bl) return false;
        return true;
    }

    public T get() {
        return this.getInternal(this.auxFuture.get());
    }

    public T get(long timeout, @NotNull TimeUnit unit) {
        return this.getInternal(this.auxFuture.get(timeout, unit));
    }

    private final T getInternal(Object result) {
        if (result instanceof Cancelled) {
            throw new CancellationException().initCause(((Cancelled)result).exception);
        }
        return (T)result;
    }

    public void addListener(@NotNull Runnable listener, @NotNull Executor executor) {
        this.auxFuture.addListener(listener, executor);
    }

    public boolean isDone() {
        return this.auxFuture.isDone();
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean bl;
        if (this.auxFuture.cancel(mayInterruptIfRunning)) {
            Job.DefaultImpls.cancel$default((Job)this.jobToCancel, null, (int)1, null);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public String toString() {
        StringBuilder $this$toString_u24lambda_u241;
        StringBuilder stringBuilder;
        block7: {
            $this$toString_u24lambda_u241 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$toString_u24lambda_u241.append(super.toString());
            $this$toString_u24lambda_u241.append("[status=");
            if (this.isDone()) {
                try {
                    Object result = Uninterruptibles.getUninterruptibly((Future)((Future)this.auxFuture));
                    if (result instanceof Cancelled) {
                        $this$toString_u24lambda_u241.append("CANCELLED, cause=[" + ((Cancelled)result).exception + ']');
                        break block7;
                    }
                    $this$toString_u24lambda_u241.append("SUCCESS, result=[" + result + ']');
                }
                catch (CancellationException e) {
                    $this$toString_u24lambda_u241.append("CANCELLED");
                }
                catch (ExecutionException e) {
                    $this$toString_u24lambda_u241.append("FAILURE, cause=[" + e.getCause() + ']');
                }
                catch (Throwable t) {
                    $this$toString_u24lambda_u241.append("UNKNOWN, cause=[" + t.getClass() + " thrown from get()]");
                }
            } else {
                $this$toString_u24lambda_u241.append("PENDING, delegate=[" + this.auxFuture + ']');
            }
        }
        $this$toString_u24lambda_u241.append(']');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }
}

