/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui;

import com.intellij.CommonBundle;
import com.intellij.DynamicBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import git4idea.GitStashUsageCollector;
import git4idea.GitUtil;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.stash.GitStashOperations;
import git4idea.stash.GitStashUtils;
import git4idea.ui.StashInfo;
import git4idea.util.GitUIUtil;
import git4idea.validators.GitBranchValidatorKt;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;

public class GitUnstashDialog
extends DialogWrapper {
    private JComboBox<VirtualFile> myGitRootComboBox;
    private JLabel myCurrentBranch;
    private JButton myViewButton;
    private JButton myDropButton;
    private JButton myClearButton;
    private JCheckBox myPopStashCheckBox;
    private JTextField myBranchTextField;
    private JPanel myPanel;
    private JList<StashInfo> myStashList;
    private final DefaultListModel<StashInfo> myStashListModel;
    private JCheckBox myReinstateIndexCheckBox;
    private final Project myProject;
    private static final Logger LOG = Logger.getInstance(GitUnstashDialog.class);

    public GitUnstashDialog(final Project project, List<VirtualFile> roots, VirtualFile defaultRoot) {
        super(project, true);
        this.$$$setupUI$$$();
        this.setModal(false);
        this.myProject = project;
        this.setTitle(GitBundle.message("unstash.title", new Object[0]));
        this.setOKButtonText(GitBundle.message("unstash.button.apply", new Object[0]));
        this.setCancelButtonText(CommonBundle.getCloseButtonText());
        GitUIUtil.setupRootChooser(project, roots, defaultRoot, this.myGitRootComboBox, this.myCurrentBranch);
        this.myStashListModel = new DefaultListModel();
        this.myStashList.setModel(this.myStashListModel);
        this.refreshStashList();
        this.myGitRootComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitUnstashDialog.this.refreshStashList();
                GitUnstashDialog.this.updateDialogState();
            }
        });
        this.myStashList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                GitUnstashDialog.this.updateDialogState();
            }
        });
        this.myBranchTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                GitUnstashDialog.this.updateDialogState();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "git4idea/ui/GitUnstashDialog$3", "textChanged"));
            }
        });
        this.myPopStashCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitUnstashDialog.this.updateDialogState();
            }
        });
        this.myClearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean cleared = GitStashOperations.clearStashesWithConfirmation(project, GitUnstashDialog.this.getGitRoot(), GitUnstashDialog.this.getContentPane());
                if (cleared) {
                    GitUnstashDialog.this.refreshStashList();
                    GitUnstashDialog.this.updateDialogState();
                }
            }
        });
        this.myDropButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean dropped = GitStashOperations.dropStashWithConfirmation(GitUnstashDialog.this.myProject, GitUnstashDialog.this.getContentPane(), GitUnstashDialog.this.getSelectedStash());
                if (dropped) {
                    GitUnstashDialog.this.refreshStashList();
                    GitUnstashDialog.this.updateDialogState();
                }
            }
        });
        this.myViewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitStashOperations.viewStash(project, GitUnstashDialog.this.getSelectedStash(), true);
            }
        });
        this.init();
        this.updateDialogState();
    }

    private void updateDialogState() {
        String branch = this.myBranchTextField.getText();
        if (branch.length() != 0) {
            ValidationInfo branchValidationInfo;
            this.setOKButtonText(GitBundle.message("unstash.button.branch", new Object[0]));
            this.myPopStashCheckBox.setEnabled(false);
            this.myPopStashCheckBox.setSelected(true);
            this.myReinstateIndexCheckBox.setEnabled(false);
            this.myReinstateIndexCheckBox.setSelected(true);
            GitRepository repository = (GitRepository)GitUtil.getRepositoryManager(this.myProject).getRepositoryForRootQuick(this.getGitRoot());
            if (repository != null && (branchValidationInfo = GitBranchValidatorKt.validateName(Collections.singletonList(repository), branch)) != null) {
                this.setErrorText(branchValidationInfo.message, this.myBranchTextField);
                this.setOKActionEnabled(false);
                return;
            }
        } else {
            if (!this.myPopStashCheckBox.isEnabled()) {
                this.myPopStashCheckBox.setSelected(false);
            }
            this.myPopStashCheckBox.setEnabled(true);
            this.setOKButtonText(this.myPopStashCheckBox.isSelected() ? GitBundle.message("unstash.button.pop", new Object[0]) : GitBundle.message("unstash.button.apply", new Object[0]));
            if (!this.myReinstateIndexCheckBox.isEnabled()) {
                this.myReinstateIndexCheckBox.setSelected(false);
            }
            this.myReinstateIndexCheckBox.setEnabled(true);
        }
        if (this.myStashList.getModel().getSize() == 0) {
            this.myViewButton.setEnabled(false);
            this.myDropButton.setEnabled(false);
            this.myClearButton.setEnabled(false);
            this.setErrorText(null);
            this.setOKActionEnabled(false);
            return;
        }
        this.myClearButton.setEnabled(true);
        if (this.myStashList.getSelectedIndex() == -1) {
            this.myViewButton.setEnabled(false);
            this.myDropButton.setEnabled(false);
            this.setErrorText(null);
            this.setOKActionEnabled(false);
            return;
        }
        this.myViewButton.setEnabled(true);
        this.myDropButton.setEnabled(true);
        this.setErrorText(null);
        this.setOKActionEnabled(true);
    }

    private void refreshStashList() {
        this.myStashListModel.clear();
        VirtualFile root = this.getGitRoot();
        try {
            List listOfStashes = (List)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> GitStashUtils.loadStashStack(this.myProject, root), GitBundle.message("unstash.dialog.stash.list.load.progress.indicator.title", new Object[0]), true, this.myProject);
            for (StashInfo info : listOfStashes) {
                this.myStashListModel.addElement(info);
            }
            this.myStashList.setSelectedIndex(0);
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            Messages.showErrorDialog((Project)this.myProject, (String)e.getMessage(), (String)GitBundle.message("unstash.dialog.show.stashes.error.dialog.title", new Object[0]));
        }
    }

    private VirtualFile getGitRoot() {
        return (VirtualFile)this.myGitRootComboBox.getSelectedItem();
    }

    private StashInfo getSelectedStash() {
        return this.myStashList.getSelectedValue();
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected String getHelpId() {
        return "reference.VersionControl.Git.Unstash";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myStashList;
    }

    protected void doOKAction() {
        GitStashUsageCollector.logStashPopDialog(!StringUtil.isEmpty((String)this.myBranchTextField.getText()), this.myReinstateIndexCheckBox.isSelected(), this.myPopStashCheckBox.isSelected());
        boolean completed2 = GitStashOperations.unstash(this.myProject, this.getSelectedStash(), this.myBranchTextField.getText(), this.myPopStashCheckBox.isSelected(), this.myReinstateIndexCheckBox.isSelected());
        if (completed2) {
            super.doOKAction();
        }
    }

    public static void showUnstashDialog(Project project, List<VirtualFile> gitRoots, VirtualFile defaultRoot) {
        new GitUnstashDialog(project, gitRoots, defaultRoot).show();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JBList jBList;
        JTextField jTextField;
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JLabel jLabel;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/GitBundle", GitUnstashDialog.class).getString("common.git.root"));
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myGitRootComboBox = jComboBox;
        jComboBox.setToolTipText(DynamicBundle.getBundle((String)"messages/GitBundle", GitUnstashDialog.class).getString("common.git.root.tooltip"));
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 2, 8, 1, 2, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/GitBundle", GitUnstashDialog.class).getString("common.current.branch"));
        jPanel.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCurrentBranch = jLabel = new JLabel();
        jLabel.setText("  ");
        jLabel.setToolTipText(DynamicBundle.getBundle((String)"messages/GitBundle", GitUnstashDialog.class).getString("common.current.branch.tooltip"));
        jPanel.add((Component)jLabel, new GridConstraints(1, 1, 1, 2, 0, 1, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/GitBundle", GitUnstashDialog.class).getString("unstash.stashes"));
        jPanel.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myViewButton = jButton3 = new JButton();
        this.$$$loadButtonText$$$(jButton3, DynamicBundle.getBundle((String)"messages/GitBundle", GitUnstashDialog.class).getString("unstash.view"));
        jButton3.setToolTipText(DynamicBundle.getBundle((String)"messages/GitBundle", GitUnstashDialog.class).getString("unstash.view.tooltip"));
        jPanel2.add((Component)jButton3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myDropButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, DynamicBundle.getBundle((String)"messages/GitBundle", GitUnstashDialog.class).getString("unstash.drop"));
        jButton2.setToolTipText(DynamicBundle.getBundle((String)"messages/GitBundle", GitUnstashDialog.class).getString("unstash.drop.tooltip"));
        jPanel2.add((Component)jButton2, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myClearButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/GitBundle", GitUnstashDialog.class).getString("unstash.clear"));
        jButton.setToolTipText(DynamicBundle.getBundle((String)"messages/GitBundle", GitUnstashDialog.class).getString("unstash.clear.tooltip"));
        jPanel2.add((Component)jButton, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, DynamicBundle.getBundle((String)"messages/GitBundle", GitUnstashDialog.class).getString("unstash.branch.label"));
        jPanel.add((Component)jLabel5, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myBranchTextField = jTextField = new JTextField();
        jTextField.setToolTipText(DynamicBundle.getBundle((String)"messages/GitBundle", GitUnstashDialog.class).getString("unstash.branch.tooltip"));
        jPanel.add((Component)jTextField, new GridConstraints(4, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(2, 1, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myStashList = jBList = new JBList();
        jBList.setSelectionMode(0);
        jBScrollPane.setViewportView((Component)jBList);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(3, 1, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myPopStashCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/GitBundle", GitUnstashDialog.class).getString("unstash.pop.stash"));
        jCheckBox2.setToolTipText(DynamicBundle.getBundle((String)"messages/GitBundle", GitUnstashDialog.class).getString("unstash.pop.stash.tooltip"));
        jPanel3.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myReinstateIndexCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/GitBundle", GitUnstashDialog.class).getString("unstash.reinstate.index"));
        jCheckBox.setToolTipText(DynamicBundle.getBundle((String)"messages/GitBundle", GitUnstashDialog.class).getString("unstash.reinstate.index.tooltip"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        jLabel2.setLabelFor(jComboBox);
        jLabel4.setLabelFor((Component)jBScrollPane);
        jLabel5.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

