/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitRemoteBranch;
import git4idea.push.GitPushNativeResult;
import git4idea.push.GitPushSource;
import git4idea.update.GitUpdateResult;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitPushRepoResult {
    static Comparator<Type> TYPE_COMPARATOR = Comparator.naturalOrder();
    @NotNull
    private final Type myType;
    private final int myCommits;
    @NotNull
    private final String mySourceBranch;
    @NotNull
    private final String myTargetBranch;
    @NotNull
    private final String myTargetRemote;
    @NotNull
    private final List<String> myPushedTags;
    @Nullable
    private final String myError;
    @Nullable
    private final GitUpdateResult myUpdateResult;

    @NotNull
    public static GitPushRepoResult convertFromNative(@NotNull GitPushNativeResult result2, @NotNull List<? extends GitPushNativeResult> tagResults, int commits2, @NotNull GitPushSource source, @NotNull GitRemoteBranch target) {
        if (result2 == null) {
            GitPushRepoResult.$$$reportNull$$$0(0);
        }
        if (tagResults == null) {
            GitPushRepoResult.$$$reportNull$$$0(1);
        }
        if (source == null) {
            GitPushRepoResult.$$$reportNull$$$0(2);
        }
        if (target == null) {
            GitPushRepoResult.$$$reportNull$$$0(3);
        }
        List tags = ContainerUtil.map(tagResults, result1 -> result1.getSourceRef());
        return new GitPushRepoResult(GitPushRepoResult.convertType(result2), commits2, source.getRevision(), target.getFullName(), target.getRemote().getName(), tags, result2.getReason(), null);
    }

    @NotNull
    public static GitPushRepoResult error(@NotNull GitPushSource source, @NotNull GitRemoteBranch target, @NotNull String error) {
        if (source == null) {
            GitPushRepoResult.$$$reportNull$$$0(4);
        }
        if (target == null) {
            GitPushRepoResult.$$$reportNull$$$0(5);
        }
        if (error == null) {
            GitPushRepoResult.$$$reportNull$$$0(6);
        }
        return new GitPushRepoResult(Type.ERROR, -1, source.getRevision(), target.getFullName(), target.getRemote().getName(), Collections.emptyList(), error, null);
    }

    @NotNull
    public static GitPushRepoResult notPushed(@NotNull GitPushSource source, @NotNull GitRemoteBranch target) {
        if (source == null) {
            GitPushRepoResult.$$$reportNull$$$0(7);
        }
        if (target == null) {
            GitPushRepoResult.$$$reportNull$$$0(8);
        }
        return new GitPushRepoResult(Type.NOT_PUSHED, -1, source.getRevision(), target.getFullName(), target.getRemote().getName(), Collections.emptyList(), null, null);
    }

    @NotNull
    static GitPushRepoResult addUpdateResult(GitPushRepoResult original, GitUpdateResult updateResult) {
        return new GitPushRepoResult(original.getType(), original.getNumberOfPushedCommits(), original.getSourceBranch(), original.getTargetBranch(), original.getTargetRemote(), original.getPushedTags(), original.getError(), updateResult);
    }

    private GitPushRepoResult(@NotNull Type type, int pushedCommits, @NotNull String sourceBranch, @NotNull String targetBranch, @NotNull String targetRemote, @NotNull List<String> pushedTags, @Nullable String error, @Nullable GitUpdateResult result2) {
        if (type == null) {
            GitPushRepoResult.$$$reportNull$$$0(9);
        }
        if (sourceBranch == null) {
            GitPushRepoResult.$$$reportNull$$$0(10);
        }
        if (targetBranch == null) {
            GitPushRepoResult.$$$reportNull$$$0(11);
        }
        if (targetRemote == null) {
            GitPushRepoResult.$$$reportNull$$$0(12);
        }
        if (pushedTags == null) {
            GitPushRepoResult.$$$reportNull$$$0(13);
        }
        this.myType = type;
        this.myCommits = pushedCommits;
        this.mySourceBranch = sourceBranch;
        this.myTargetBranch = targetBranch;
        this.myTargetRemote = targetRemote;
        this.myPushedTags = pushedTags;
        this.myError = error;
        this.myUpdateResult = result2;
    }

    @NotNull
    public Type getType() {
        Type type = this.myType;
        if (type == null) {
            GitPushRepoResult.$$$reportNull$$$0(14);
        }
        return type;
    }

    @Nullable
    GitUpdateResult getUpdateResult() {
        return this.myUpdateResult;
    }

    int getNumberOfPushedCommits() {
        return this.myCommits;
    }

    @NotNull
    String getSourceBranch() {
        String string = this.mySourceBranch;
        if (string == null) {
            GitPushRepoResult.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    String getTargetBranch() {
        String string = this.myTargetBranch;
        if (string == null) {
            GitPushRepoResult.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NlsSafe
    @Nullable
    public String getError() {
        return this.myError;
    }

    @NotNull List<@NlsSafe String> getPushedTags() {
        List<String> list2 = this.myPushedTags;
        if (list2 == null) {
            GitPushRepoResult.$$$reportNull$$$0(17);
        }
        return list2;
    }

    @NlsSafe
    @NotNull
    public String getTargetRemote() {
        String string = this.myTargetRemote;
        if (string == null) {
            GitPushRepoResult.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    private static Type convertType(@NotNull GitPushNativeResult nativeResult) {
        if (nativeResult == null) {
            GitPushRepoResult.$$$reportNull$$$0(19);
        }
        Type type = switch (nativeResult.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case GitPushNativeResult.Type.SUCCESS -> Type.SUCCESS;
            case GitPushNativeResult.Type.FORCED_UPDATE -> Type.FORCED;
            case GitPushNativeResult.Type.NEW_REF -> Type.NEW_BRANCH;
            case GitPushNativeResult.Type.REJECTED -> {
                if (nativeResult.isNonFFUpdate()) {
                    yield Type.REJECTED_NO_FF;
                }
                if (nativeResult.isStaleInfo()) {
                    yield Type.REJECTED_STALE_INFO;
                }
                yield Type.REJECTED_OTHER;
            }
            case GitPushNativeResult.Type.UP_TO_DATE -> Type.UP_TO_DATE;
            case GitPushNativeResult.Type.ERROR -> Type.ERROR;
            case GitPushNativeResult.Type.DELETED -> throw new IllegalArgumentException("Conversion is not supported: " + nativeResult.getType());
        };
        if (type == null) {
            GitPushRepoResult.$$$reportNull$$$0(20);
        }
        return type;
    }

    @NonNls
    public String toString() {
        return String.format("%s (%d, '%s'), update: %s}", new Object[]{this.myType, this.myCommits, this.mySourceBranch, this.myUpdateResult});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14, 15, 16, 17, 18, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagResults";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceBranch";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetBranch";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRemote";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pushedTags";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/push/GitPushRepoResult";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/push/GitPushRepoResult";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceBranch";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetBranch";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPushedTags";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetRemote";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "convertType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertFromNative";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "notPushed";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "convertType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14, 15, 16, 17, 18, 20 -> new IllegalStateException(string);
        };
    }

    public static enum Type {
        SUCCESS,
        NEW_BRANCH,
        UP_TO_DATE,
        FORCED,
        REJECTED_NO_FF,
        REJECTED_STALE_INFO,
        REJECTED_OTHER,
        ERROR,
        NOT_PUSHED;

    }
}

