/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.WindowWrapper;
import com.intellij.openapi.ui.WindowWrapperBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitVcs;
import git4idea.config.GitExecutableManager;
import git4idea.i18n.GitBundle;
import git4idea.log.GitShowExternalLogAction;
import git4idea.log.GitShowExternalLogActionKt;
import git4idea.log.MyContentComponent;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0001\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lgit4idea/log/ShowLogInDialogTask;", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "project", "Lcom/intellij/openapi/project/Project;", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "vcs", "Lgit4idea/GitVcs;", "dialogTitle", "", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lgit4idea/GitVcs;Ljava/lang/String;)V", "getDialogTitle", "()Ljava/lang/String;", "getRoots", "()Ljava/util/List;", "getVcs", "()Lgit4idea/GitVcs;", "onSuccess", "", "run", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.vcs.git"})
final class ShowLogInDialogTask
extends Task.Backgroundable {
    @NotNull
    private final List<VirtualFile> roots;
    @NotNull
    private final GitVcs vcs;
    @NotNull
    private final String dialogTitle;

    public ShowLogInDialogTask(@NotNull Project project, @NotNull List<? extends VirtualFile> roots, @NotNull GitVcs vcs, @NlsContexts.DialogTitle @NotNull String dialogTitle) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Intrinsics.checkNotNullParameter((Object)((Object)vcs), (String)"vcs");
        Intrinsics.checkNotNullParameter((Object)dialogTitle, (String)"dialogTitle");
        super(project, GitBundle.message("git.log.external.loading.process", new Object[0]), true);
        this.roots = roots;
        this.vcs = vcs;
        this.dialogTitle = dialogTitle;
    }

    @NotNull
    public final List<VirtualFile> getRoots() {
        return this.roots;
    }

    @NotNull
    public final GitVcs getVcs() {
        return this.vcs;
    }

    @NotNull
    public final String getDialogTitle() {
        return this.dialogTitle;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        if (!GitExecutableManager.getInstance().testGitExecutableVersionValid(this.getProject())) {
            throw new ProcessCanceledException();
        }
    }

    public void onSuccess() {
        if (!this.getProject().isDisposed()) {
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            MyContentComponent content = GitShowExternalLogActionKt.access$createManagerAndContent(project, this.vcs, this.roots, false);
            WindowWrapper windowWrapper = new WindowWrapperBuilder(WindowWrapper.Mode.FRAME, (JComponent)content).setProject(this.getProject()).setTitle(this.dialogTitle).setPreferredFocusedComponent((JComponent)content).setDimensionServiceKey(GitShowExternalLogAction.class.getName()).build();
            Intrinsics.checkNotNullExpressionValue((Object)windowWrapper, (String)"WindowWrapperBuilder(Win\u2026va.name)\n        .build()");
            WindowWrapper window = windowWrapper;
            Disposer.register((Disposable)((Disposable)window), (Disposable)content.getDisposable());
            Project project2 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
            GitShowExternalLogActionKt.access$doOnProviderRemoval(project2, content.getDisposable(), (Function0)new Function0<Unit>(window){
                final /* synthetic */ WindowWrapper $window;
                {
                    this.$window = $window;
                    super(0);
                }

                public final void invoke() {
                    this.$window.close();
                }
            });
            window.show();
        }
    }
}

