/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index.vfs;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.progress.util.PotemkinProgress;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.encoding.EncodingManagerListener;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.index.GitIndexUtil;
import git4idea.index.vfs.GitIndexFileSystemRefresher;
import git4idea.index.vfs.GitIndexVirtualFile;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.util.GitFileUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\b\u0018\u0000 52\u00020\u0001:\u00045678B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0010\u001a\u00020\u00112\u0010\u0010\u0012\u001a\f\u0012\b\u0012\u00060\u0014R\u00020\u00000\u0013H\u0002J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001a\u001a\u00020\u0007H\u0002J\b\u0010\u001b\u001a\u00020\u0011H\u0016J\u0018\u0010\u001c\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u001d\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001fJ\u0016\u0010 \u001a\b\u0018\u00010\u0014R\u00020\u00002\u0006\u0010!\u001a\u00020\tH\u0002J(\u0010 \u001a\b\u0018\u00010\u0014R\u00020\u00002\u0006\u0010!\u001a\u00020\t2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u0010&\u001a\u00020%2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010'\u001a\u00020(H\u0002J\u001a\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001a\u0010+\u001a\u00020\u00112\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000f0-J\u0016\u0010+\u001a\u00020\u00112\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\t0\u0013H\u0002J/\u0010/\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\t2\b\u00100\u001a\u0004\u0018\u0001012\u0006\u00102\u001a\u00020\u001e2\u0006\u00103\u001a\u00020%H\u0000\u00a2\u0006\u0002\b4RN\u0010\u0005\u001aB\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\t0\t \b* \u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\t0\t\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u0001\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lgit4idea/index/vfs/GitIndexFileSystemRefresher;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "Lgit4idea/index/vfs/GitIndexFileSystemRefresher$Key;", "kotlin.jvm.PlatformType", "Lgit4idea/index/vfs/GitIndexVirtualFile;", "disposable", "Lorg/jetbrains/annotations/NotNull;", "executor", "Ljava/util/concurrent/ExecutorService;", "isShutDown", "", "applyRefresh", "", "fileDataList", "", "Lgit4idea/index/vfs/GitIndexFileSystemRefresher$IndexFileData;", "createIndexVirtualFile", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "key", "dispose", "getFile", "readContentFromGit", "", "readContentFromGit$intellij_vcs_git", "readFromGit", "file", "oldHash", "Lcom/intellij/vcs/log/Hash;", "oldModificationStamp", "", "readLengthFromGit", "hash", "", "readMetadataFromGit", "Lgit4idea/index/GitIndexUtil$StagedFile;", "refresh", "condition", "Lkotlin/Function1;", "filesToRefresh", "write", "requestor", "", "newContent", "newModificationStamp", "write$intellij_vcs_git", "Companion", "IndexFileData", "Key", "MyEncodingManagerListener", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitIndexFileSystemRefresher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitIndexFileSystemRefresher.kt\ngit4idea/index/vfs/GitIndexFileSystemRefresher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,339:1\n766#2:340\n857#2,2:341\n1549#2:343\n1620#2,3:344\n1855#2,2:347\n1#3:349\n*S KotlinDebug\n*F\n+ 1 GitIndexFileSystemRefresher.kt\ngit4idea/index/vfs/GitIndexFileSystemRefresher\n*L\n118#1:340\n118#1:341,2\n165#1:343\n165#1:344,3\n167#1:347,2\n*E\n"})
public final class GitIndexFileSystemRefresher
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ExecutorService executor;
    @NotNull
    private final Disposable disposable;
    private volatile boolean isShutDown;
    private final LoadingCache<Key, GitIndexVirtualFile> cache;
    @NotNull
    private static final Logger LOG;

    public GitIndexFileSystemRefresher(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Git index file system refresher", (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplication\u2026ile system refresher\", 1)");
        this.executor = executorService;
        Disposable disposable = Disposer.newDisposable((String)"Git Index File System");
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(\"Git Index File System\")");
        this.disposable = disposable;
        this.cache = Caffeine.newBuilder().weakValues().build(arg_0 -> GitIndexFileSystemRefresher.cache$lambda$0(this, arg_0));
        MessageBusConnection connection = this.project.getMessageBus().connect(this.disposable);
        Topic<GitRepositoryChangeListener> topic = GitRepository.GIT_REPO_CHANGE;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"GIT_REPO_CHANGE");
        connection.subscribe(topic, arg_0 -> GitIndexFileSystemRefresher._init_$lambda$1(this, arg_0));
        connection.subscribe(ProjectCloseListener.TOPIC, (Object)new ProjectCloseListener(){

            public void projectClosing(@NotNull Project p) {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                if (Intrinsics.areEqual((Object)project, (Object)p)) {
                    isShutDown = true;
                    Disposer.dispose((Disposable)disposable);
                    executor.shutdown();
                    ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> 2.projectClosing$lambda$0(this), GitBundle.message("stage.vfs.shutdown.process", new Object[0]), false, project);
                }
            }

            private static final void projectClosing$lambda$0(GitIndexFileSystemRefresher this$0) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                this$0.executor.awaitTermination(100L, TimeUnit.MILLISECONDS);
            }
        });
        Topic topic2 = EncodingManagerListener.ENCODING_MANAGER_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"ENCODING_MANAGER_CHANGES");
        connection.subscribe(topic2, (Object)new MyEncodingManagerListener());
    }

    @Nullable
    public final GitIndexVirtualFile getFile(@NotNull VirtualFile root, @NotNull FilePath filePath) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        try {
            return (GitIndexVirtualFile)((Object)this.cache.get((Object)new Key(root, filePath)));
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof ProcessCanceledException) {
                throw cause;
            }
            throw e;
        }
    }

    private final GitIndexVirtualFile createIndexVirtualFile(VirtualFile root, FilePath filePath) {
        if (this.isShutDown) {
            return null;
        }
        GitIndexUtil.StagedFile stagedFile = this.readMetadataFromGit(root, filePath);
        if (stagedFile == null) {
            return null;
        }
        GitIndexUtil.StagedFile stagedFile2 = stagedFile;
        String string = stagedFile2.getBlobHash();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stagedFile.blobHash");
        long length = this.readLengthFromGit(root, string);
        return new GitIndexVirtualFile(this.project, root, filePath, GitIndexFileSystemRefresher.Companion.hash(stagedFile2), length, stagedFile2.isExecutable());
    }

    private final GitIndexVirtualFile createIndexVirtualFile(Key key) {
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            return this.createIndexVirtualFile(key.getRoot(), key.getFilePath());
        }
        Object[] objectArray = new Object[]{key.getFilePath().getName()};
        return (GitIndexVirtualFile)((Object)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> GitIndexFileSystemRefresher.createIndexVirtualFile$lambda$2(this, key), GitBundle.message("stage.vfs.read.process", objectArray), false, this.project));
    }

    /*
     * WARNING - void declaration
     */
    public final void refresh(@NotNull Function1<? super GitIndexVirtualFile, Boolean> condition) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        Iterable $this$filter$iv = this.cache.asMap().values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)condition.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filesToRefresh = (List)destination$iv$iv;
        if (filesToRefresh.isEmpty()) {
            return;
        }
        this.refresh(filesToRefresh);
    }

    private final void refresh(List<GitIndexVirtualFile> filesToRefresh) {
        if (this.isShutDown) {
            return;
        }
        LOG.debug("Starting async refresh for " + CollectionsKt.joinToString$default((Iterable)filesToRefresh, null, null, null, (int)0, null, (Function1)refresh.1.INSTANCE, (int)31, null));
        BackgroundTaskUtil.execute((Executor)this.executor, (Disposable)this.disposable, () -> GitIndexFileSystemRefresher.refresh$lambda$4(filesToRefresh, this));
    }

    private final IndexFileData readFromGit(GitIndexVirtualFile file2) {
        Pair pair = (Pair)ActionsKt.runReadAction((Function0)((Function0)new Function0<Pair<? extends Hash, ? extends Long>>(file2){
            final /* synthetic */ GitIndexVirtualFile $file;
            {
                this.$file = $file;
                super(0);
            }

            @NotNull
            public final Pair<Hash, Long> invoke() {
                return new Pair((Object)this.$file.getHash$intellij_vcs_git(), (Object)this.$file.getModificationStamp());
            }
        }));
        Hash oldHash = (Hash)pair.component1();
        long oldModificationStamp = ((Number)pair.component2()).longValue();
        return this.readFromGit(file2, oldHash, oldModificationStamp);
    }

    private final IndexFileData readFromGit(GitIndexVirtualFile file2, Hash oldHash, long oldModificationStamp) {
        Hash newHash;
        GitIndexUtil.StagedFile stagedFile;
        GitIndexUtil.StagedFile stagedFile2 = stagedFile = this.readMetadataFromGit(file2.getRoot(), file2.getFilePath());
        Hash hash = newHash = stagedFile2 != null ? GitIndexFileSystemRefresher.Companion.hash(stagedFile2) : null;
        if (!Intrinsics.areEqual((Object)oldHash, (Object)newHash)) {
            long l;
            if (stagedFile != null) {
                VirtualFile virtualFile = file2.getRoot();
                String string = stagedFile.getBlobHash();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stagedFile.blobHash");
                l = this.readLengthFromGit(virtualFile, string);
            } else {
                l = 0L;
            }
            long newLength = l;
            LOG.debug("Preparing refresh for " + file2);
            GitIndexUtil.StagedFile stagedFile3 = stagedFile;
            return new IndexFileData(file2, oldHash, newHash, file2.getLength$intellij_vcs_git(), newLength, stagedFile3 != null ? stagedFile3.isExecutable() : false, oldModificationStamp);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final void applyRefresh(List<IndexFileData> fileDataList) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = fileDataList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IndexFileData indexFileData = (IndexFileData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getEvent());
        }
        List events = (List)destination$iv$iv;
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        ((BulkFileListener)messageBus.syncPublisher(topic)).before(events);
        Iterable $this$forEach$iv = fileDataList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IndexFileData it = (IndexFileData)element$iv;
            boolean bl = false;
            it.apply();
        }
        MessageBus messageBus2 = ApplicationManager.getApplication().getMessageBus();
        Topic topic2 = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"VFS_CHANGES");
        ((BulkFileListener)messageBus2.syncPublisher(topic2)).after(events);
    }

    public final void write$intellij_vcs_git(@NotNull GitIndexVirtualFile file2, @Nullable Object requestor, @NotNull byte[] newContent, long newModificationStamp) {
        Intrinsics.checkNotNullParameter((Object)((Object)file2), (String)"file");
        Intrinsics.checkNotNullParameter((Object)newContent, (String)"newContent");
        try {
            long newModStamp = newModificationStamp > 0L ? newModificationStamp : LocalTimeCounter.currentTime();
            VFileContentChangeEvent event = new VFileContentChangeEvent(requestor, (VirtualFile)file2, file2.getModificationStamp(), newModStamp, false);
            MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
            Topic topic = VirtualFileManager.VFS_CHANGES;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
            ((BulkFileListener)messageBus.syncPublisher(topic)).before(CollectionsKt.listOf((Object)event));
            Hash oldHash = file2.getHash$intellij_vcs_git();
            long oldModificationStamp = file2.getModificationStamp();
            Object[] objectArray = new Object[]{file2.getName()};
            String string = GitBundle.message("stage.vfs.write.process", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"stage.vfs.write.process\", file.name)");
            Function0 applyChanges2 = (Function0)GitIndexFileSystemRefresher.Companion.computeUnderPotemkinProgress(this.project, string, (Function0)new Function0<Function0<? extends Unit>>(this, file2, oldHash, oldModificationStamp, newContent, newModStamp){
                final /* synthetic */ GitIndexFileSystemRefresher this$0;
                final /* synthetic */ GitIndexVirtualFile $file;
                final /* synthetic */ Hash $oldHash;
                final /* synthetic */ long $oldModificationStamp;
                final /* synthetic */ byte[] $newContent;
                final /* synthetic */ long $newModStamp;
                {
                    this.this$0 = $receiver;
                    this.$file = $file;
                    this.$oldHash = $oldHash;
                    this.$oldModificationStamp = $oldModificationStamp;
                    this.$newContent = $newContent;
                    this.$newModStamp = $newModStamp;
                    super(0);
                }

                @NotNull
                public final Function0<Unit> invoke() {
                    IndexFileData indexFileData = GitIndexFileSystemRefresher.access$readFromGit(this.this$0, this.$file, this.$oldHash, this.$oldModificationStamp);
                    if (indexFileData != null) {
                        GitIndexFileSystemRefresher.access$getLOG$cp().info("Detected memory-disk conflict in " + this.$file);
                        return (Function0)new Function0<Unit>(this.this$0, indexFileData){
                            final /* synthetic */ GitIndexFileSystemRefresher this$0;
                            final /* synthetic */ IndexFileData $indexFileData;
                            {
                                this.this$0 = $receiver;
                                this.$indexFileData = $indexFileData;
                                super(0);
                            }

                            public final void invoke() {
                                GitIndexFileSystemRefresher.access$applyRefresh(this.this$0, CollectionsKt.listOf((Object)this.$indexFileData));
                            }
                        };
                    }
                    Hash hash = GitIndexUtil.write(GitIndexFileSystemRefresher.access$getProject$p(this.this$0), this.$file.getRoot(), this.$file.getFilePath(), new ByteArrayInputStream(this.$newContent), this.$file.isExecutable$intellij_vcs_git());
                    Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"write(project, file.root\u2026tent), file.isExecutable)");
                    Hash newHash = hash;
                    GitIndexFileSystemRefresher.access$getLOG$cp().debug("Written " + this.$file + ". newHash=" + newHash);
                    return (Function0)new Function0<Unit>(this.$file, newHash, this.$newContent, this.$newModStamp){
                        final /* synthetic */ GitIndexVirtualFile $file;
                        final /* synthetic */ Hash $newHash;
                        final /* synthetic */ byte[] $newContent;
                        final /* synthetic */ long $newModStamp;
                        {
                            this.$file = $file;
                            this.$newHash = $newHash;
                            this.$newContent = $newContent;
                            this.$newModStamp = $newModStamp;
                            super(0);
                        }

                        public final void invoke() {
                            this.$file.setDataFromWrite$intellij_vcs_git(this.$newHash, this.$newContent.length, this.$newModStamp);
                        }
                    };
                }
            });
            applyChanges2.invoke();
            MessageBus messageBus2 = ApplicationManager.getApplication().getMessageBus();
            Topic topic2 = VirtualFileManager.VFS_CHANGES;
            Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"VFS_CHANGES");
            ((BulkFileListener)messageBus2.syncPublisher(topic2)).after(CollectionsKt.listOf((Object)event));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @NotNull
    public final byte[] readContentFromGit$intellij_vcs_git(@NotNull VirtualFile root, @NotNull FilePath filePath) throws IOException {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        try {
            byte[] byArray2 = GitFileUtils.getFileContent(this.project, root, "", VcsFileUtil.relativePath((VirtualFile)root, (FilePath)filePath));
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"{\n      GitFileUtils.get\u2026th(root, filePath))\n    }");
            byArray = byArray2;
        }
        catch (VcsException e) {
            throw new IOException(e);
        }
        return byArray;
    }

    private final GitIndexUtil.StagedFile readMetadataFromGit(VirtualFile root, FilePath filePath) {
        List<GitIndexUtil.StagedFile> list2 = GitIndexUtil.listStaged(this.project, root, CollectionsKt.listOf((Object)filePath));
        Intrinsics.checkNotNullExpressionValue(list2, (String)"listStaged(project, root, listOf(filePath))");
        return (GitIndexUtil.StagedFile)CollectionsKt.singleOrNull(list2);
    }

    private final long readLengthFromGit(VirtualFile root, String hash) {
        try {
            GitLineHandler h = new GitLineHandler(this.project, root, GitCommand.CAT_FILE);
            h.setSilent(true);
            String[] stringArray = new String[]{"-s"};
            h.addParameters(stringArray);
            stringArray = new String[]{hash};
            h.addParameters(stringArray);
            h.endOptions();
            String string = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInstance().runCommand(h).getOutputOrThrow()");
            String output = string;
            Long l = Long.valueOf(((Object)StringsKt.trim((CharSequence)output)).toString());
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"valueOf(output.trim())");
            return ((Number)l).longValue();
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            return 0L;
        }
    }

    public void dispose() {
        this.cache.invalidateAll();
    }

    private static final GitIndexVirtualFile cache$lambda$0(GitIndexFileSystemRefresher this$0, Key key) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
        return this$0.createIndexVirtualFile(key);
    }

    private static final void _init_$lambda$1(GitIndexFileSystemRefresher this$0, GitRepository repository) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        LOG.debug("Scheduling refresh for repository " + repository.getRoot().getName());
        this$0.refresh((Function1<? super GitIndexVirtualFile, Boolean>)((Function1)new Function1<GitIndexVirtualFile, Boolean>(repository){
            final /* synthetic */ GitRepository $repository;
            {
                this.$repository = $repository;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull GitIndexVirtualFile it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                return Intrinsics.areEqual((Object)it.getRoot(), (Object)this.$repository.getRoot());
            }
        }));
    }

    private static final GitIndexVirtualFile createIndexVirtualFile$lambda$2(GitIndexFileSystemRefresher this$0, Key $key) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        return this$0.createIndexVirtualFile($key.getRoot(), $key.getFilePath());
    }

    private static final void refresh$lambda$4(List $filesToRefresh, GitIndexFileSystemRefresher this$0) {
        Intrinsics.checkNotNullParameter((Object)$filesToRefresh, (String)"$filesToRefresh");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        List fileDataList = new ArrayList();
        for (GitIndexVirtualFile file2 : $filesToRefresh) {
            IndexFileData it;
            if (this$0.readFromGit(file2) == null) continue;
            boolean bl = false;
            fileDataList.add(it);
        }
        if (fileDataList.isEmpty()) {
            return;
        }
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator != null) {
            progressIndicator.checkCanceled();
        }
        GitIndexFileSystemRefresher.Companion.writeInEdtAndWait((Function0<Unit>)((Function0)new Function0<Unit>(this$0, (List<IndexFileData>)fileDataList){
            final /* synthetic */ GitIndexFileSystemRefresher this$0;
            final /* synthetic */ List<IndexFileData> $fileDataList;
            {
                this.this$0 = $receiver;
                this.$fileDataList = $fileDataList;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$filterTo$iv$iv;
                if (GitIndexFileSystemRefresher.access$isShutDown$p(this.this$0)) {
                    return;
                }
                Iterable $this$filter$iv = this.$fileDataList;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    IndexFileData it = (IndexFileData)element$iv$iv;
                    boolean bl = false;
                    if (!(!it.isOutdated())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List dataToApply = (List)destination$iv$iv;
                if (dataToApply.isEmpty()) {
                    return;
                }
                GitIndexFileSystemRefresher.access$applyRefresh(this.this$0, dataToApply);
            }
        }));
    }

    @JvmStatic
    @NotNull
    public static final GitIndexFileSystemRefresher getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @JvmStatic
    public static final void refreshFilePaths(@NotNull Project project, @NotNull Collection<? extends FilePath> paths) {
        Companion.refreshFilePaths(project, paths);
    }

    @JvmStatic
    public static final void refreshFilePaths(@NotNull Project project, @NotNull Map<VirtualFile, ? extends Collection<? extends FilePath>> paths) {
        Companion.refreshFilePaths(project, paths);
    }

    @JvmStatic
    public static final void refreshVirtualFiles(@NotNull Project project, @NotNull Collection<? extends VirtualFile> paths) {
        Companion.refreshVirtualFiles(project, paths);
    }

    @JvmStatic
    public static final void refreshRoots(@NotNull Project project, @NotNull Collection<? extends VirtualFile> roots) {
        Companion.refreshRoots(project, roots);
    }

    public static final /* synthetic */ IndexFileData access$readFromGit(GitIndexFileSystemRefresher $this, GitIndexVirtualFile file2, Hash oldHash, long oldModificationStamp) {
        return $this.readFromGit(file2, oldHash, oldModificationStamp);
    }

    public static final /* synthetic */ void access$applyRefresh(GitIndexFileSystemRefresher $this, List fileDataList) {
        $this.applyRefresh(fileDataList);
    }

    public static final /* synthetic */ boolean access$isShutDown$p(GitIndexFileSystemRefresher $this) {
        return $this.isShutDown;
    }

    static {
        Logger logger = Logger.getInstance(GitIndexFileSystemRefresher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(GitIndexFile\u2026temRefresher::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J3\u0010\u0006\u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00070\rH\u0002\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0007J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0007J*\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u0016H\u0007J\u001e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00170\u0014H\u0007J\u001e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00170\u0014H\u0007J\u0016\u0010\u001b\u001a\u00020\u00122\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00120\rH\u0002J\f\u0010\u001d\u001a\u00020\u001e*\u00020\u001fH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lgit4idea/index/vfs/GitIndexFileSystemRefresher$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "computeUnderPotemkinProgress", "T", "project", "Lcom/intellij/openapi/project/Project;", "message", "", "computation", "Lkotlin/Function0;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "getInstance", "Lgit4idea/index/vfs/GitIndexFileSystemRefresher;", "refreshFilePaths", "", "paths", "", "Lcom/intellij/openapi/vcs/FilePath;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "refreshRoots", "roots", "refreshVirtualFiles", "writeInEdtAndWait", "action", "hash", "Lcom/intellij/vcs/log/Hash;", "Lgit4idea/index/GitIndexUtil$StagedFile;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitIndexFileSystemRefresher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitIndexFileSystemRefresher.kt\ngit4idea/index/vfs/GitIndexFileSystemRefresher$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,339:1\n29#2,3:340\n48#2:343\n48#2:344\n48#2:349\n1549#3:345\n1620#3,3:346\n*S KotlinDebug\n*F\n+ 1 GitIndexFileSystemRefresher.kt\ngit4idea/index/vfs/GitIndexFileSystemRefresher$Companion\n*L\n242#1:340,3\n247#1:343\n252#1:344\n264#1:349\n259#1:345\n259#1:346,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final GitIndexFileSystemRefresher getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<GitIndexFileSystemRefresher> serviceClass$iv = GitIndexFileSystemRefresher.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return (GitIndexFileSystemRefresher)object;
        }

        @JvmStatic
        public final void refreshFilePaths(@NotNull Project project, @NotNull Collection<? extends FilePath> paths) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter(paths, (String)"paths");
                Set pathsSet = CollectionsKt.toSet((Iterable)paths);
                ComponentManager $this$serviceIfCreated$iv = (ComponentManager)project;
                boolean $i$f$serviceIfCreated = false;
                GitIndexFileSystemRefresher gitIndexFileSystemRefresher = (GitIndexFileSystemRefresher)$this$serviceIfCreated$iv.getServiceIfCreated(GitIndexFileSystemRefresher.class);
                if (gitIndexFileSystemRefresher == null) break block0;
                gitIndexFileSystemRefresher.refresh((Function1<? super GitIndexVirtualFile, Boolean>)((Function1)new Function1<GitIndexVirtualFile, Boolean>((Set<? extends FilePath>)pathsSet){
                    final /* synthetic */ Set<FilePath> $pathsSet;
                    {
                        this.$pathsSet = $pathsSet;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull GitIndexVirtualFile it) {
                        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                        return this.$pathsSet.contains(it.getFilePath());
                    }
                }));
            }
        }

        @JvmStatic
        public final void refreshFilePaths(@NotNull Project project, @NotNull Map<VirtualFile, ? extends Collection<? extends FilePath>> paths) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter(paths, (String)"paths");
                ComponentManager $this$serviceIfCreated$iv = (ComponentManager)project;
                boolean $i$f$serviceIfCreated = false;
                GitIndexFileSystemRefresher gitIndexFileSystemRefresher = (GitIndexFileSystemRefresher)$this$serviceIfCreated$iv.getServiceIfCreated(GitIndexFileSystemRefresher.class);
                if (gitIndexFileSystemRefresher == null) break block0;
                gitIndexFileSystemRefresher.refresh((Function1<? super GitIndexVirtualFile, Boolean>)((Function1)new Function1<GitIndexVirtualFile, Boolean>(paths){
                    final /* synthetic */ Map<VirtualFile, Collection<FilePath>> $paths;
                    {
                        this.$paths = $paths;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull GitIndexVirtualFile it) {
                        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                        Collection<FilePath> collection = this.$paths.get(it.getRoot());
                        return collection != null ? collection.contains(it.getFilePath()) : false;
                    }
                }));
            }
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final void refreshVirtualFiles(@NotNull Project project, @NotNull Collection<? extends VirtualFile> paths) {
            Collection<FilePath> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(paths, (String)"paths");
            Iterable iterable = paths;
            Project project2 = project;
            Companion companion = this;
            boolean $i$f$map = false;
            void var5_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(VcsUtil.getFilePath((VirtualFile)p0));
            }
            collection = (List)destination$iv$iv;
            companion.refreshFilePaths(project2, (Collection<? extends FilePath>)collection);
        }

        @JvmStatic
        public final void refreshRoots(@NotNull Project project, @NotNull Collection<? extends VirtualFile> roots) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter(roots, (String)"roots");
                ComponentManager $this$serviceIfCreated$iv = (ComponentManager)project;
                boolean $i$f$serviceIfCreated = false;
                GitIndexFileSystemRefresher gitIndexFileSystemRefresher = (GitIndexFileSystemRefresher)$this$serviceIfCreated$iv.getServiceIfCreated(GitIndexFileSystemRefresher.class);
                if (gitIndexFileSystemRefresher == null) break block0;
                gitIndexFileSystemRefresher.refresh((Function1<? super GitIndexVirtualFile, Boolean>)((Function1)new Function1<GitIndexVirtualFile, Boolean>(roots){
                    final /* synthetic */ Collection<VirtualFile> $roots;
                    {
                        this.$roots = $roots;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull GitIndexVirtualFile it) {
                        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                        return this.$roots.contains(it.getRoot());
                    }
                }));
            }
        }

        private final Hash hash(GitIndexUtil.StagedFile $this$hash) {
            Hash hash = HashImpl.build((String)$this$hash.getBlobHash());
            Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"build(blobHash)");
            return hash;
        }

        private final void writeInEdtAndWait(Function0<Unit> action) {
            ApplicationManager.getApplication().invokeAndWait(() -> Companion.writeInEdtAndWait$lambda$1(action));
        }

        private final <T> T computeUnderPotemkinProgress(Project project, @NlsContexts.ProgressTitle String message, Function0<? extends T> computation) {
            Ref result2 = new Ref(null);
            new PotemkinProgress(message, project, null, null).runInBackground(() -> Companion.computeUnderPotemkinProgress$lambda$2(result2, computation));
            return (T)result2.get();
        }

        private static final void writeInEdtAndWait$lambda$1$lambda$0(Function0 $action) {
            Intrinsics.checkNotNullParameter((Object)$action, (String)"$action");
            $action.invoke();
        }

        private static final void writeInEdtAndWait$lambda$1(Function0 $action) {
            Intrinsics.checkNotNullParameter((Object)$action, (String)"$action");
            ApplicationManager.getApplication().runWriteAction(() -> Companion.writeInEdtAndWait$lambda$1$lambda$0($action));
        }

        private static final void computeUnderPotemkinProgress$lambda$2(Ref $result, Function0 $computation) {
            Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
            Intrinsics.checkNotNullParameter((Object)$computation, (String)"$computation");
            $result.set($computation.invoke());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\b\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u000bJ\r\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\u0017H\u0016R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lgit4idea/index/vfs/GitIndexFileSystemRefresher$IndexFileData;", "", "file", "Lgit4idea/index/vfs/GitIndexVirtualFile;", "oldHash", "Lcom/intellij/vcs/log/Hash;", "newHash", "oldLength", "", "newLength", "newExecutable", "", "oldModificationStamp", "(Lgit4idea/index/vfs/GitIndexFileSystemRefresher;Lgit4idea/index/vfs/GitIndexVirtualFile;Lcom/intellij/vcs/log/Hash;Lcom/intellij/vcs/log/Hash;JJZJ)V", "event", "Lcom/intellij/openapi/vfs/newvfs/events/VFileContentChangeEvent;", "getEvent", "()Lcom/intellij/openapi/vfs/newvfs/events/VFileContentChangeEvent;", "apply", "", "isOutdated", "toString", "", "Lorg/jetbrains/annotations/NonNls;", "intellij.vcs.git"})
    private final class IndexFileData {
        @NotNull
        private final GitIndexVirtualFile file;
        @Nullable
        private final Hash oldHash;
        @Nullable
        private final Hash newHash;
        private final long newLength;
        private final boolean newExecutable;
        @NotNull
        private final VFileContentChangeEvent event;

        public IndexFileData(@Nullable GitIndexVirtualFile file2, @Nullable Hash oldHash, Hash newHash, long oldLength, long newLength, boolean newExecutable, long oldModificationStamp) {
            Intrinsics.checkNotNullParameter((Object)((Object)file2), (String)"file");
            this.file = file2;
            this.oldHash = oldHash;
            this.newHash = newHash;
            this.newLength = newLength;
            this.newExecutable = newExecutable;
            this.event = new VFileContentChangeEvent(null, (VirtualFile)this.file, oldModificationStamp, -1L, 0L, 0L, oldLength, this.newLength, true);
        }

        @NotNull
        public final VFileContentChangeEvent getEvent() {
            return this.event;
        }

        public final boolean isOutdated() {
            return !Intrinsics.areEqual((Object)this.file.getHash$intellij_vcs_git(), (Object)this.oldHash);
        }

        public final void apply() {
            LOG.debug("Refreshing " + this.file);
            this.file.setDataFromRefresh$intellij_vcs_git(this.newHash, this.newLength, this.newExecutable);
        }

        @NotNull
        public String toString() {
            return "IndexFileData: " + this.file;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lgit4idea/index/vfs/GitIndexFileSystemRefresher$Key;", "", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vcs/FilePath;)V", "getFilePath", "()Lcom/intellij/openapi/vcs/FilePath;", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.vcs.git"})
    private static final class Key {
        @NotNull
        private final VirtualFile root;
        @NotNull
        private final FilePath filePath;

        public Key(@NotNull VirtualFile root, @NotNull FilePath filePath) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            this.root = root;
            this.filePath = filePath;
        }

        @NotNull
        public final VirtualFile getRoot() {
            return this.root;
        }

        @NotNull
        public final FilePath getFilePath() {
            return this.filePath;
        }

        @NotNull
        public final VirtualFile component1() {
            return this.root;
        }

        @NotNull
        public final FilePath component2() {
            return this.filePath;
        }

        @NotNull
        public final Key copy(@NotNull VirtualFile root, @NotNull FilePath filePath) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            return new Key(root, filePath);
        }

        public static /* synthetic */ Key copy$default(Key key, VirtualFile virtualFile, FilePath filePath, int n, Object object) {
            if ((n & 1) != 0) {
                virtualFile = key.root;
            }
            if ((n & 2) != 0) {
                filePath = key.filePath;
            }
            return key.copy(virtualFile, filePath);
        }

        @NotNull
        public String toString() {
            return "Key(root=" + this.root + ", filePath=" + this.filePath + ")";
        }

        public int hashCode() {
            int result2 = this.root.hashCode();
            result2 = result2 * 31 + this.filePath.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Key)) {
                return false;
            }
            Key key = (Key)other;
            if (!Intrinsics.areEqual((Object)this.root, (Object)key.root)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.filePath, (Object)key.filePath);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\f\u001a\u00020\u0004H\u0002\u00a8\u0006\r"}, d2={"Lgit4idea/index/vfs/GitIndexFileSystemRefresher$MyEncodingManagerListener;", "Lcom/intellij/openapi/vfs/encoding/EncodingManagerListener;", "(Lgit4idea/index/vfs/GitIndexFileSystemRefresher;)V", "propertyChanged", "", "eventDocument", "Lcom/intellij/openapi/editor/Document;", "propertyName", "", "oldValue", "", "newValue", "reloadCachedPropertiesFiles", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitIndexFileSystemRefresher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitIndexFileSystemRefresher.kt\ngit4idea/index/vfs/GitIndexFileSystemRefresher$MyEncodingManagerListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,339:1\n766#2:340\n857#2,2:341\n*S KotlinDebug\n*F\n+ 1 GitIndexFileSystemRefresher.kt\ngit4idea/index/vfs/GitIndexFileSystemRefresher$MyEncodingManagerListener\n*L\n329#1:340\n329#1:341,2\n*E\n"})
    private final class MyEncodingManagerListener
    implements EncodingManagerListener {
        public void propertyChanged(@Nullable Document eventDocument, @NotNull String propertyName, @Nullable Object oldValue, @Nullable Object newValue2) {
            Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
            if (Intrinsics.areEqual((Object)"native2ascii", (Object)propertyName) || Intrinsics.areEqual((Object)"propertiesFilesEncoding", (Object)propertyName)) {
                ApplicationManager.getApplication().invokeLater(() -> MyEncodingManagerListener.propertyChanged$lambda$1(this));
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void reloadCachedPropertiesFiles() {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = GitIndexFileSystemRefresher.this.cache.asMap().values();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                GitIndexVirtualFile it = (GitIndexVirtualFile)((Object)element$iv$iv);
                boolean bl = false;
                if (!FileTypeRegistry.getInstance().isFileOfType((VirtualFile)it, (FileType)StdFileTypes.PROPERTIES)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List virtualFiles = (List)destination$iv$iv;
            for (GitIndexVirtualFile file2 : virtualFiles) {
                Document document = FileDocumentManager.getInstance().getCachedDocument((VirtualFile)file2);
                if (document != null) {
                    FileDocumentManager.getInstance().saveDocument(document);
                }
                file2.setCharset(null);
            }
            VirtualFile[] virtualFileArray = VfsUtil.toVirtualFileArray((Collection)virtualFiles);
            FileDocumentManager.getInstance().reloadFiles(Arrays.copyOf(virtualFileArray, virtualFileArray.length));
        }

        private static final void propertyChanged$lambda$1$lambda$0(MyEncodingManagerListener this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            this$0.reloadCachedPropertiesFiles();
        }

        private static final void propertyChanged$lambda$1(MyEncodingManagerListener this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            ApplicationManager.getApplication().runWriteAction(() -> MyEncodingManagerListener.propertyChanged$lambda$1$lambda$0(this$0));
        }
    }
}

