/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.update.FilePathChange;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.i18n.GitBundle;
import git4idea.index.ContentVersion;
import git4idea.index.GitFileStatusKt;
import git4idea.index.actions.StagingAreaOperation;
import git4idea.index.ui.GitFileStatusNode;
import git4idea.index.ui.NodeKind;
import git4idea.util.GitFileUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0017H\u0016J&\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00170\"H\u0016R1\u0010\u0003\u001a\u001f\u0012\u0016\u0012\u0014 \u0007*\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00060\u0005\u00a2\u0006\u0002\b\u00060\u0004\u00a2\u0006\u0002\b\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0019\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\f0\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\b\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\r\u00a8\u0006#"}, d2={"Lgit4idea/index/actions/GitRevertOperation;", "Lgit4idea/index/actions/StagingAreaOperation;", "()V", "actionText", "Ljava/util/function/Supplier;", "", "Lorg/jetbrains/annotations/Nls;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getActionText", "()Ljava/util/function/Supplier;", "errorMessage", "getErrorMessage", "()Ljava/lang/String;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "progressTitle", "getProgressTitle", "createChange", "Lcom/intellij/openapi/vcs/update/FilePathChange;", "node", "Lgit4idea/index/ui/GitFileStatusNode;", "matches", "", "statusNode", "processPaths", "", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "nodes", "", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nStagingAreaOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StagingAreaOperation.kt\ngit4idea/index/actions/GitRevertOperation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n1549#2:88\n1620#2,3:89\n1549#2:92\n1620#2,3:93\n*S KotlinDebug\n*F\n+ 1 StagingAreaOperation.kt\ngit4idea/index/actions/GitRevertOperation\n*L\n81#1:88\n81#1:89,3\n82#1:92\n82#1:93,3\n*E\n"})
public final class GitRevertOperation
implements StagingAreaOperation {
    @NotNull
    public static final GitRevertOperation INSTANCE = new GitRevertOperation();
    @NotNull
    private static final Icon icon;

    private GitRevertOperation() {
    }

    @Override
    @NotNull
    public Supplier<String> getActionText() {
        Supplier<String> supplier = GitBundle.messagePointer("stage.revert.action.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(\"stage.revert.action.text\")");
        return supplier;
    }

    @Override
    @NotNull
    public String getProgressTitle() {
        String string = GitBundle.message("stage.revert.process", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"stage.revert.process\")");
        return string;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return icon;
    }

    @Override
    @NotNull
    public String getErrorMessage() {
        String string = GitBundle.message("stage.revert.error.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"stage.revert.error.title\")");
        return string;
    }

    @Override
    public boolean matches(@NotNull GitFileStatusNode statusNode) {
        Intrinsics.checkNotNullParameter((Object)statusNode, (String)"statusNode");
        return statusNode.getKind() == NodeKind.UNSTAGED;
    }

    @Override
    public void processPaths(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<GitFileStatusNode> nodes) {
        GitFileStatusNode it;
        Collection<FilePath> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        Iterable iterable = nodes;
        Object object = root;
        Project project2 = project;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            GitFileStatusNode gitFileStatusNode = (GitFileStatusNode)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFilePath());
        }
        collection = (List)destination$iv$iv;
        GitFileUtils.revertUnstagedPaths(project2, (VirtualFile)object, (List<? extends FilePath>)collection);
        $this$map$iv = nodes;
        project2 = RefreshVFsSynchronously.INSTANCE;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (GitFileStatusNode)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(INSTANCE.createChange(it));
        }
        project2.refresh((Collection)((List)destination$iv$iv), true);
    }

    private final FilePathChange createChange(GitFileStatusNode node) {
        return (FilePathChange)new FilePathChange.Simple(GitFileStatusKt.path(node.getStatus(), ContentVersion.STAGED), GitFileStatusKt.path(node.getStatus(), ContentVersion.LOCAL));
    }

    static {
        Icon icon = AllIcons.Actions.Rollback;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Rollback");
        GitRevertOperation.icon = icon;
    }
}

