/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ignore;

import com.intellij.openapi.vcs.Ignored;
import com.intellij.openapi.vcs.IgnoredCheckResult;
import com.intellij.openapi.vcs.NotIgnored;
import com.intellij.openapi.vcs.VcsIgnoreChecker;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.PathKt;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J.\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\n2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0015"}, d2={"Lgit4idea/ignore/GitIgnoreChecker;", "Lcom/intellij/openapi/vcs/VcsIgnoreChecker;", "()V", "getSupportedVcs", "Lcom/intellij/openapi/vcs/VcsKey;", "isFilePatternIgnored", "Lcom/intellij/openapi/vcs/IgnoredCheckResult;", "vcsRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "filePattern", "", "isIgnored", "file", "Ljava/nio/file/Path;", "checkForIgnore", "isPattern", "", "parseOutput", "checkForIgnorePath", "output", "", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitIgnoreChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitIgnoreChecker.kt\ngit4idea/ignore/GitIgnoreChecker\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,70:1\n37#2,2:71\n*S KotlinDebug\n*F\n+ 1 GitIgnoreChecker.kt\ngit4idea/ignore/GitIgnoreChecker\n*L\n59#1:71,2\n*E\n"})
public final class GitIgnoreChecker
implements VcsIgnoreChecker {
    @NotNull
    public VcsKey getSupportedVcs() {
        VcsKey vcsKey = GitVcs.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)vcsKey, (String)"getKey()");
        return vcsKey;
    }

    @NotNull
    public IgnoredCheckResult isIgnored(@NotNull VirtualFile vcsRoot, @NotNull Path file2) {
        Intrinsics.checkNotNullParameter((Object)vcsRoot, (String)"vcsRoot");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Path path = file2.toAbsolutePath().normalize();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"file.toAbsolutePath().normalize()");
        return this.isIgnored(vcsRoot, PathKt.getSystemIndependentPath((Path)path), false);
    }

    @NotNull
    public IgnoredCheckResult isFilePatternIgnored(@NotNull VirtualFile vcsRoot, @NotNull String filePattern) {
        Intrinsics.checkNotNullParameter((Object)vcsRoot, (String)"vcsRoot");
        Intrinsics.checkNotNullParameter((Object)filePattern, (String)"filePattern");
        return this.isIgnored(vcsRoot, filePattern, true);
    }

    private final IgnoredCheckResult isIgnored(VirtualFile vcsRoot, String checkForIgnore, boolean isPattern) {
        GitLineHandler handler = new GitLineHandler(null, VfsUtilCore.virtualToIoFile((VirtualFile)vcsRoot), GitCommand.CHECK_IGNORE);
        String[] stringArray = new String[]{"--verbose"};
        handler.addParameters(stringArray);
        handler.endOptions();
        stringArray = new String[]{checkForIgnore};
        handler.addParameters(stringArray);
        GitCommandResult gitCommandResult = Git.getInstance().runCommand(handler);
        Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"getInstance().runCommand(handler)");
        GitCommandResult commandResult = gitCommandResult;
        List<String> list2 = commandResult.getOutput();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"commandResult.output");
        return this.parseOutput(vcsRoot, checkForIgnore, list2, isPattern);
    }

    private final IgnoredCheckResult parseOutput(VirtualFile vcsRoot, String checkForIgnorePath, List<String> output, boolean isPattern) {
        if (output.isEmpty()) {
            return (IgnoredCheckResult)NotIgnored.INSTANCE;
        }
        for (String line : output) {
            VirtualFile gitIgnoreFile2;
            String[] stringArray;
            List lineElements = StringsKt.split$default((CharSequence)line, (String[])(stringArray = new String[]{"\t"}), (boolean)false, (int)0, (int)6, null);
            if (lineElements.size() != 2) continue;
            String path = (String)lineElements.get(1);
            String[] stringArray2 = new String[]{":"};
            List prefixParts = StringsKt.split$default((CharSequence)((CharSequence)lineElements.get(0)), (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            if (prefixParts.size() != 3) continue;
            String gitIgnoreRelPath = (String)prefixParts.get(0);
            String matchedPattern = (String)prefixParts.get(2);
            if (StringsKt.startsWith$default((String)matchedPattern, (String)"!", (boolean)false, (int)2, null)) continue;
            String[] stringArray3 = new String[]{"/"};
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)gitIgnoreRelPath, (String[])stringArray3, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray4 = thisCollection$iv.toArray(new String[0]);
            if (VfsUtil.findRelativeFile((VirtualFile)vcsRoot, (String[])Arrays.copyOf(stringArray4, stringArray4.length)) == null) continue;
            if (isPattern && StringsKt.equals((String)path, (String)checkForIgnorePath, (!gitIgnoreFile2.isCaseSensitive() ? 1 : 0) != 0)) {
                File file2 = VfsUtil.virtualToIoFile((VirtualFile)gitIgnoreFile2);
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"virtualToIoFile(gitIgnoreFile)");
                return (IgnoredCheckResult)new Ignored(file2, matchedPattern);
            }
            if (isPattern) continue;
            File file3 = VfsUtil.virtualToIoFile((VirtualFile)gitIgnoreFile2);
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"virtualToIoFile(gitIgnoreFile)");
            return (IgnoredCheckResult)new Ignored(file3, matchedPattern);
        }
        return (IgnoredCheckResult)NotIgnored.INSTANCE;
    }
}

