/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.RegistryBooleanOptionDescriptor;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.LightColors;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.index.VcsLogBigRepositoriesList;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.data.index.VcsLogModifiableIndex;
import com.intellij.vcs.log.history.VcsLogFileHistoryProviderImplKt;
import com.intellij.vcs.log.impl.VcsLogSharedSettings;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.util.VcsLogUtil;
import git4idea.history.GitHistoryProvider;
import git4idea.i18n.GitBundle;
import git4idea.log.GitLogProvider;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lgit4idea/history/GitHistoryNotificationPanel;", "", "()V", "create", "Lcom/intellij/ui/EditorNotificationPanel;", "project", "Lcom/intellij/openapi/project/Project;", "session", "Lcom/intellij/openapi/vcs/history/VcsHistorySession;", "intellij.vcs.git"})
public final class GitHistoryNotificationPanel {
    @NotNull
    public static final GitHistoryNotificationPanel INSTANCE = new GitHistoryNotificationPanel();

    private GitHistoryNotificationPanel() {
    }

    @JvmStatic
    @Nullable
    public static final EditorNotificationPanel create(@NotNull Project project, @NotNull VcsHistorySession session) {
        EditorNotificationPanel editorNotificationPanel;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        GitHistoryProvider.GitHistorySession gitHistorySession = session instanceof GitHistoryProvider.GitHistorySession ? (GitHistoryProvider.GitHistorySession)session : null;
        if (gitHistorySession == null || (gitHistorySession = gitHistorySession.getFilePath()) == null) {
            return null;
        }
        GitHistoryProvider.GitHistorySession filePath = gitHistorySession;
        if (PropertiesComponent.getInstance((Project)project).getBoolean("git.history.resume.index.dismissed")) {
            return null;
        }
        if (!VcsLogFileHistoryProviderImplKt.isNewHistoryEnabled()) {
            return null;
        }
        if (!VcsLogSharedSettings.isIndexSwitchedOn((Project)project)) {
            return null;
        }
        VirtualFile virtualFile = VcsLogUtil.getActualRoot((Project)project, (FilePath)filePath);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile root = virtualFile;
        if (!VcsLogBigRepositoriesList.getInstance().isBig(root) && GitLogProvider.isIndexingOn()) {
            return null;
        }
        EditorNotificationPanel $this$create_u24lambda_u242 = editorNotificationPanel = new EditorNotificationPanel(LightColors.YELLOW, EditorNotificationPanel.Status.Warning);
        boolean bl = false;
        $this$create_u24lambda_u242.setText(GitBundle.message("history.indexing.disabled.notification.text", new Object[0]));
        $this$create_u24lambda_u242.createActionLabel(GitBundle.message("history.indexing.disabled.notification.resume.link", new Object[0]), () -> GitHistoryNotificationPanel.create$lambda$2$lambda$0(root, $this$create_u24lambda_u242, project));
        $this$create_u24lambda_u242.add((Component)new InplaceButton(new IconButton(GitBundle.message("history.indexing.disabled.notification.dismiss.link", new Object[0]), AllIcons.Actions.Close, AllIcons.Actions.CloseHovered), arg_0 -> GitHistoryNotificationPanel.create$lambda$2$lambda$1(project, $this$create_u24lambda_u242, arg_0)), (Object)"East");
        return editorNotificationPanel;
    }

    private static final void create$lambda$2$lambda$0(VirtualFile $root, EditorNotificationPanel $this_apply, Project $project) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)$root, (String)"$root");
            Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            VcsLogBigRepositoriesList.getInstance().removeRepository($root);
            if (!GitLogProvider.isIndexingOn()) {
                GitLogProvider.getIndexingRegistryOption().setValue(true);
                RegistryBooleanOptionDescriptor.suggestRestartIfNecessary((JComponent)((JComponent)$this_apply));
            } else {
                VcsLogData vcsLogData = VcsProjectLog.Companion.getInstance($project).getDataManager();
                VcsLogIndex vcsLogIndex = vcsLogData != null ? vcsLogData.getIndex() : null;
                VcsLogModifiableIndex vcsLogModifiableIndex = vcsLogIndex instanceof VcsLogModifiableIndex ? (VcsLogModifiableIndex)vcsLogIndex : null;
                if (vcsLogModifiableIndex != null) {
                    vcsLogModifiableIndex.scheduleIndex(false);
                }
            }
            Container container = $this_apply.getParent();
            if (container == null) break block3;
            container.remove((Component)$this_apply);
        }
    }

    private static final void create$lambda$2$lambda$1(Project $project, EditorNotificationPanel $this_apply, ActionEvent it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
            PropertiesComponent.getInstance((Project)$project).setValue("git.history.resume.index.dismissed", true);
            Container container = $this_apply.getParent();
            if (container == null) break block0;
            container.remove((Component)$this_apply);
        }
    }
}

