/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import git4idea.config.ErrorNotifier;
import git4idea.config.GitDownloadAndInstallKt;
import git4idea.config.GitExecutableProblemHandler;
import git4idea.config.GitExecutableProblemHandlersKt;
import git4idea.config.GitInstaller;
import git4idea.config.GitVersionIdentificationException;
import git4idea.config.MacExecutableProblemHandler;
import git4idea.i18n.GitBundle;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 /2\u00020\u0001:\u0001/B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002J#\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J.\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u0014H\u0002J\u0018\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J$\u0010\u001f\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\f0!H\u0002J\u0010\u0010\"\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J&\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\f2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00110\u0014H\u0002J \u0010(\u001a\u00020\f2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\fH\u0002J\u0010\u0010)\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010*\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J&\u0010+\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u0014H\u0016J\u0018\u0010,\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010-\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010.\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u00070\u0006\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lgit4idea/config/MacExecutableProblemHandler;", "Lgit4idea/config/GitExecutableProblemHandler;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "mountPoint", "Ljava/io/File;", "getProject", "()Lcom/intellij/openapi/project/Project;", "tempPath", "Lorg/jetbrains/annotations/NotNull;", "attachVolume", "", "file", "errorNotifier", "Lgit4idea/config/ErrorNotifier;", "detachVolume", "", "downloadAndInstall", "onErrorResolved", "Lkotlin/Function0;", "downloadAndInstall$intellij_vcs_git", "execXCodeSelectInstall", "installGit", "dmgFile", "pkgFileName", "", "installPackageOrShowError", "isInvalidActiveDeveloperPath", "exception", "", "isXcodeError", "messageIndicator", "Lkotlin/Function1;", "isXcodeLicenseError", "runCommand", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "sudo", "onError", "runOrShowError", "showCouldntInstallError", "showCouldntStartInstallerError", "showError", "showGenericError", "showInvalidActiveDeveloperPathError", "showXCodeLicenseError", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nMacExecutableProblemHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacExecutableProblemHandler.kt\ngit4idea/config/MacExecutableProblemHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,177:1\n10#2:178\n*S KotlinDebug\n*F\n+ 1 MacExecutableProblemHandler.kt\ngit4idea/config/MacExecutableProblemHandler\n*L\n16#1:178\n*E\n"})
public final class MacExecutableProblemHandler
implements GitExecutableProblemHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final File tempPath;
    @NotNull
    private final File mountPoint;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String XCODE_LICENSE_ERROR = "Agreeing to the Xcode/iOS license";
    @NotNull
    private static final String XCODE_DEVELOPER_PART_ERROR = "invalid active developer path";
    @NotNull
    private static final String XCODE_XCRUN = "xcrun";

    public MacExecutableProblemHandler(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        File file2 = FileUtil.createTempDirectory((String)"git-install", null);
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"createTempDirectory(\"git-install\", null)");
        this.tempPath = file2;
        this.mountPoint = new File(this.tempPath, "mount");
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    public void showError(@NotNull Throwable exception, @NotNull ErrorNotifier errorNotifier, @NotNull Function0<Unit> onErrorResolved) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        Intrinsics.checkNotNullParameter((Object)errorNotifier, (String)"errorNotifier");
        Intrinsics.checkNotNullParameter(onErrorResolved, (String)"onErrorResolved");
        if (this.isXcodeLicenseError(exception)) {
            this.showXCodeLicenseError(errorNotifier);
        } else if (this.isInvalidActiveDeveloperPath(exception)) {
            this.showInvalidActiveDeveloperPathError(errorNotifier);
        } else {
            this.showGenericError(exception, errorNotifier);
        }
    }

    private final void showGenericError(Throwable exception, ErrorNotifier errorNotifier) {
        String string = GitBundle.message("executable.error.git.not.installed", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"executable.error.git.not.installed\")");
        errorNotifier.showError(string, GitExecutableProblemHandlersKt.getHumanReadableErrorFor(exception), null);
    }

    public final void downloadAndInstall$intellij_vcs_git(@NotNull ErrorNotifier errorNotifier, @NotNull Function0<Unit> onErrorResolved) {
        Intrinsics.checkNotNullParameter((Object)errorNotifier, (String)"errorNotifier");
        Intrinsics.checkNotNullParameter(onErrorResolved, (String)"onErrorResolved");
        String string = GitBundle.message("install.downloading.progress", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"install.downloading.progress\")");
        errorNotifier.executeTask(string, false, (Function0<Unit>)((Function0)new Function0<Unit>(errorNotifier, this, onErrorResolved){
            final /* synthetic */ ErrorNotifier $errorNotifier;
            final /* synthetic */ MacExecutableProblemHandler this$0;
            final /* synthetic */ Function0<Unit> $onErrorResolved;
            {
                this.$errorNotifier = $errorNotifier;
                this.this$0 = $receiver;
                this.$onErrorResolved = $onErrorResolved;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                try {
                    GitInstaller installer2 = GitDownloadAndInstallKt.fetchInstaller(this.$errorNotifier, (Function1<? super GitInstaller, Boolean>)((Function1)downloadAndInstall.installer.1.INSTANCE));
                    if (installer2 != null) {
                        String fileName = installer2.getFileName();
                        File dmgFile = new File(MacExecutableProblemHandler.access$getTempPath$p(this.this$0), fileName);
                        String string = installer2.getPkgFileName();
                        Intrinsics.checkNotNull((Object)string);
                        String pkgFileName = string;
                        if (GitDownloadAndInstallKt.downloadGit(installer2, dmgFile, this.this$0.getProject(), this.$errorNotifier)) {
                            String string2 = GitBundle.message("install.installing.progress", new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"install.installing.progress\")");
                            this.$errorNotifier.changeProgressTitle(string2);
                            MacExecutableProblemHandler.access$installGit(this.this$0, dmgFile, pkgFileName, this.$errorNotifier, this.$onErrorResolved);
                        }
                    }
                }
                finally {
                    FileUtil.delete((File)MacExecutableProblemHandler.access$getTempPath$p(this.this$0));
                }
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void installGit(File dmgFile, String pkgFileName, ErrorNotifier errorNotifier, Function0<Unit> onErrorResolved) {
        if (this.attachVolume(dmgFile, errorNotifier)) {
            try {
                if (this.installPackageOrShowError(pkgFileName, errorNotifier)) {
                    String string = GitBundle.message("install.success.message", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"install.success.message\")");
                    errorNotifier.showMessage(string);
                    onErrorResolved.invoke();
                    errorNotifier.resetGitExecutable();
                }
            }
            finally {
                this.detachVolume();
            }
        }
    }

    private final boolean attachVolume(File file2, ErrorNotifier errorNotifier) {
        String[] stringArray = new String[]{"hdiutil", "attach", "-readonly", "-noautoopen", "-noautofsck", "-nobrowse", "-mountpoint", this.mountPoint.getPath(), file2.getPath()};
        GeneralCommandLine cmd = new GeneralCommandLine(stringArray);
        return this.runOrShowError(cmd, errorNotifier, false);
    }

    private final boolean installPackageOrShowError(String pkgFileName, ErrorNotifier errorNotifier) {
        String[] stringArray = new String[]{"installer", "-package", this.mountPoint + "/" + pkgFileName, "-target", "/"};
        return this.runOrShowError(new GeneralCommandLine(stringArray), errorNotifier, true);
    }

    private final void detachVolume() {
        String[] stringArray = new String[]{"hdiutil", "detach", this.mountPoint.getPath()};
        this.runCommand(new GeneralCommandLine(stringArray), false, (Function0<Unit>)((Function0)detachVolume.1.INSTANCE));
    }

    private final boolean runOrShowError(GeneralCommandLine commandLine, ErrorNotifier errorNotifier, boolean sudo) {
        return this.runCommand(commandLine, sudo, (Function0<Unit>)((Function0)new Function0<Unit>(this, errorNotifier){
            final /* synthetic */ MacExecutableProblemHandler this$0;
            final /* synthetic */ ErrorNotifier $errorNotifier;
            {
                this.this$0 = $receiver;
                this.$errorNotifier = $errorNotifier;
                super(0);
            }

            public final void invoke() {
                MacExecutableProblemHandler.access$showCouldntInstallError(this.this$0, this.$errorNotifier);
            }
        }));
    }

    private final boolean runCommand(GeneralCommandLine commandLine, boolean sudo, Function0<Unit> onError) {
        try {
            GeneralCommandLine generalCommandLine;
            if (sudo) {
                String string = GitBundle.message("title.sudo.command.install.git", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"title.sudo.command.install.git\")");
                generalCommandLine = ExecUtil.sudoCommand((GeneralCommandLine)commandLine, (String)string);
            } else {
                generalCommandLine = commandLine;
            }
            GeneralCommandLine cmd = generalCommandLine;
            ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)cmd);
            if (output.checkSuccess(LOG)) {
                return true;
            }
            LOG.warn(output.getStderr());
            onError.invoke();
            return false;
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            onError.invoke();
            return false;
        }
    }

    private final void showCouldntInstallError(ErrorNotifier errorNotifier) {
        String string = GitBundle.message("install.general.error", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"install.general.error\")");
        errorNotifier.showError(string, GitExecutableProblemHandlersKt.getLinkToConfigure(this.project));
    }

    private final void showCouldntStartInstallerError(ErrorNotifier errorNotifier) {
        String string = GitBundle.message("install.mac.error.couldnt.start.command.line.tools", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"install.mac.err\u2026tart.command.line.tools\")");
        errorNotifier.showError(string, GitExecutableProblemHandlersKt.getLinkToConfigure(this.project));
    }

    private final void showXCodeLicenseError(ErrorNotifier errorNotifier) {
        String string = GitBundle.message("git.executable.validation.error.xcode.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"git.executable.\u2026ation.error.xcode.title\")");
        errorNotifier.showError(string, GitBundle.message("git.executable.validation.error.xcode.message", new Object[0]), GitExecutableProblemHandlersKt.getLinkToConfigure(this.project));
    }

    private final void showInvalidActiveDeveloperPathError(ErrorNotifier errorNotifier) {
        String string = GitBundle.message("executable.mac.fix.path.action", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"executable.mac.fix.path.action\")");
        ErrorNotifier.FixOption.Standard fixPathOption2 = new ErrorNotifier.FixOption.Standard(string, (Function0<Unit>)((Function0)new Function0<Unit>(errorNotifier, this){
            final /* synthetic */ ErrorNotifier $errorNotifier;
            final /* synthetic */ MacExecutableProblemHandler this$0;
            {
                this.$errorNotifier = $errorNotifier;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.$errorNotifier.executeTask(GitBundle.message("install.mac.requesting.command.line.tools", new Object[0]) + "\u2026", false, (Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, this.$errorNotifier){
                    final /* synthetic */ MacExecutableProblemHandler this$0;
                    final /* synthetic */ ErrorNotifier $errorNotifier;
                    {
                        this.this$0 = $receiver;
                        this.$errorNotifier = $errorNotifier;
                        super(0);
                    }

                    public final void invoke() {
                        MacExecutableProblemHandler.access$execXCodeSelectInstall(this.this$0, this.$errorNotifier);
                    }
                }));
            }
        }));
        String string2 = GitBundle.message("executable.mac.error.invalid.path.to.command.line.tools", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"executable.mac.\u2026h.to.command.line.tools\")");
        errorNotifier.showError(string2, fixPathOption2);
    }

    private final boolean isXcodeLicenseError(Throwable exception) {
        return this.isXcodeError(exception, (Function1<? super String, Boolean>)((Function1)isXcodeLicenseError.1.INSTANCE));
    }

    private final boolean isInvalidActiveDeveloperPath(Throwable exception) {
        return this.isXcodeError(exception, (Function1<? super String, Boolean>)((Function1)isInvalidActiveDeveloperPath.1.INSTANCE));
    }

    private final boolean isXcodeError(Throwable exception, Function1<? super String, Boolean> messageIndicator) {
        String string;
        if (exception instanceof GitVersionIdentificationException) {
            Throwable throwable = exception.getCause();
            string = throwable != null ? throwable.getMessage() : null;
        } else {
            string = exception.getMessage();
        }
        String message = string;
        return message != null && (Boolean)messageIndicator.invoke((Object)message) != false;
    }

    private final void execXCodeSelectInstall(ErrorNotifier errorNotifier) {
        try {
            String[] stringArray = new String[]{"xcode-select", "--install"};
            GeneralCommandLine cmd = new GeneralCommandLine(stringArray);
            ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)cmd);
            errorNotifier.hideProgress();
            if (!output.checkSuccess(LOG)) {
                LOG.warn(output.getStderr());
                this.showCouldntStartInstallerError(errorNotifier);
            } else {
                errorNotifier.resetGitExecutable();
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            this.showCouldntStartInstallerError(errorNotifier);
        }
    }

    public static final /* synthetic */ File access$getTempPath$p(MacExecutableProblemHandler $this) {
        return $this.tempPath;
    }

    public static final /* synthetic */ void access$installGit(MacExecutableProblemHandler $this, File dmgFile, String pkgFileName, ErrorNotifier errorNotifier, Function0 onErrorResolved) {
        $this.installGit(dmgFile, pkgFileName, errorNotifier, (Function0<Unit>)onErrorResolved);
    }

    public static final /* synthetic */ void access$showCouldntInstallError(MacExecutableProblemHandler $this, ErrorNotifier errorNotifier) {
        $this.showCouldntInstallError(errorNotifier);
    }

    public static final /* synthetic */ void access$execXCodeSelectInstall(MacExecutableProblemHandler $this, ErrorNotifier errorNotifier) {
        $this.execXCodeSelectInstall(errorNotifier);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MacExecutableProblemHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lgit4idea/config/MacExecutableProblemHandler$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "XCODE_DEVELOPER_PART_ERROR", "", "Lorg/jetbrains/annotations/NonNls;", "XCODE_LICENSE_ERROR", "XCODE_XCRUN", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

