/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.VcsScopeKt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitStyleFactory;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRangeFilter;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.DataPackBase;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.ui.highlighters.MergeCommitsHighlighter;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.DataPackUtilKt;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.branch.DeepComparatorHolder;
import git4idea.branch.GitCompareUtilKt;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Scope;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 >2\u00020\u00012\u00020\u0002:\u0003>?@B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\fJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J0\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00142\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u00142\u0006\u0010\"\u001a\u00020\u000eH\u0002J(\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020&2\u0006\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020+H\u0007J\u0012\u0010-\u001a\u00020\u001d2\b\u0010.\u001a\u0004\u0018\u00010\u000eH\u0002J4\u0010/\u001a\u0002H0\"\u0004\b\u0000\u001002\u0006\u00101\u001a\u00020 2\b\b\u0001\u00102\u001a\u00020\u000e2\f\u00103\u001a\b\u0012\u0004\u0012\u0002H004H\u0082\b\u00a2\u0006\u0002\u00105J\u0010\u00106\u001a\u00020\u001d2\u0006\u00107\u001a\u000208H\u0002J\u0018\u00106\u001a\u00020\u001d2\u0006\u00107\u001a\u0002082\u0006\u0010\"\u001a\u00020\u000eH\u0007J\b\u00109\u001a\u00020\u001dH\u0002J\b\u0010:\u001a\u00020\u001dH\u0007J\b\u0010;\u001a\u00020\u001dH\u0002J\u0018\u0010<\u001a\u00020\u001d2\u0006\u00107\u001a\u0002082\u0006\u0010=\u001a\u00020+H\u0016R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0017\u001a\u00070\u0018\u00a2\u0006\u0002\b\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lgit4idea/branch/DeepComparator;", "Lcom/intellij/vcs/log/VcsLogHighlighter;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "repositoryManager", "Lgit4idea/repo/GitRepositoryManager;", "vcsLogData", "Lcom/intellij/vcs/log/data/VcsLogData;", "ui", "Lcom/intellij/vcs/log/VcsLogUi;", "parent", "(Lcom/intellij/openapi/project/Project;Lgit4idea/repo/GitRepositoryManager;Lcom/intellij/vcs/log/data/VcsLogData;Lcom/intellij/vcs/log/VcsLogUi;Lcom/intellij/openapi/Disposable;)V", "comparedBranch", "", "nonPickedCommits", "Lit/unimi/dsi/fastutil/ints/IntOpenHashSet;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "repositoriesWithCurrentBranches", "", "Lgit4idea/repo/GitRepository;", "Lgit4idea/GitBranch;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "Lorg/jetbrains/annotations/NotNull;", "getStorage", "()Lcom/intellij/vcs/log/data/VcsLogStorage;", "dispose", "", "getRepositories", "providers", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/vcs/log/VcsLogProvider;", "branchToCompare", "getStyle", "Lcom/intellij/vcs/log/VcsLogHighlighter$VcsCommitStyle;", "commitId", "", "commitDetails", "Lcom/intellij/vcs/log/VcsShortCommitDetails;", "column", "isSelected", "", "hasHighlightingOrInProgress", "notifyUnhighlight", "branch", "recordSpan", "R", "root", "actionName", "block", "Lkotlin/Function0;", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "startTask", "dataPack", "Lcom/intellij/vcs/log/VcsLogDataPack;", "stopTask", "stopTaskAndUnhighlight", "unhighlight", "update", "refreshHappened", "Companion", "Factory", "MyTask", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nDeepComparator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeepComparator.kt\ngit4idea/branch/DeepComparator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 trace.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/TraceKt\n*L\n1#1,366:1\n1603#2,9:367\n1855#2:376\n1856#2:378\n1612#2:379\n766#2:380\n857#2,2:381\n1271#2,2:383\n1285#2,4:385\n1#3:377\n63#4:389\n21#4,3:390\n101#4,2:393\n116#4:395\n104#4,10:396\n*S KotlinDebug\n*F\n+ 1 DeepComparator.kt\ngit4idea/branch/DeepComparator\n*L\n159#1:367,9\n159#1:376\n159#1:378\n159#1:379\n159#1:380\n159#1:381,2\n162#1:383,2\n162#1:385,4\n159#1:377\n361#1:389\n361#1:390,3\n361#1:393,2\n361#1:395\n361#1:396,10\n*E\n"})
public final class DeepComparator
implements VcsLogHighlighter,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final GitRepositoryManager repositoryManager;
    @NotNull
    private final VcsLogData vcsLogData;
    @NotNull
    private final VcsLogUi ui;
    @Nullable
    private ProgressIndicator progressIndicator;
    @Nullable
    private String comparedBranch;
    @Nullable
    private Map<GitRepository, ? extends GitBranch> repositoriesWithCurrentBranches;
    @Nullable
    private IntOpenHashSet nonPickedCommits;
    @NotNull
    private static final Logger LOG;

    public DeepComparator(@NotNull Project project, @NotNull GitRepositoryManager repositoryManager, @NotNull VcsLogData vcsLogData, @NotNull VcsLogUi ui, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)repositoryManager), (String)"repositoryManager");
        Intrinsics.checkNotNullParameter((Object)vcsLogData, (String)"vcsLogData");
        Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.project = project;
        this.repositoryManager = repositoryManager;
        this.vcsLogData = vcsLogData;
        this.ui = ui;
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    private final VcsLogStorage getStorage() {
        VcsLogStorage vcsLogStorage = this.vcsLogData.getStorage();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogStorage, (String)"vcsLogData.storage");
        return vcsLogStorage;
    }

    @NotNull
    public VcsLogHighlighter.VcsCommitStyle getStyle(int commitId, @NotNull VcsShortCommitDetails commitDetails, int column, boolean isSelected) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)commitDetails, (String)"commitDetails");
                if (this.nonPickedCommits == null) break block2;
                IntOpenHashSet intOpenHashSet = this.nonPickedCommits;
                Intrinsics.checkNotNull((Object)intOpenHashSet);
                if (!intOpenHashSet.contains(commitId)) break block3;
            }
            VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsLogHighlighter.VcsCommitStyle.DEFAULT;
            Intrinsics.checkNotNullExpressionValue((Object)vcsCommitStyle, (String)"DEFAULT");
            return vcsCommitStyle;
        }
        VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsCommitStyleFactory.foreground((Color)((Color)MergeCommitsHighlighter.MERGE_COMMIT_FOREGROUND));
        Intrinsics.checkNotNullExpressionValue((Object)vcsCommitStyle, (String)"foreground(MergeCommitsH\u2026.MERGE_COMMIT_FOREGROUND)");
        return vcsCommitStyle;
    }

    public void update(@NotNull VcsLogDataPack dataPack, boolean refreshHappened) {
        Intrinsics.checkNotNullParameter((Object)dataPack, (String)"dataPack");
        if (this.comparedBranch == null) {
            return;
        }
        VcsLogFilterCollection vcsLogFilterCollection = dataPack.getFilters();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogFilterCollection, (String)"dataPack.filters");
        VcsLogRefs vcsLogRefs = dataPack.getRefs();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogRefs, (String)"dataPack.refs");
        String singleFilteredBranch = Companion.getComparedBranchFromFilters(vcsLogFilterCollection, vcsLogRefs);
        if (!Intrinsics.areEqual((Object)this.comparedBranch, (Object)singleFilteredBranch)) {
            String oldComparedBranch = this.comparedBranch;
            LOG.debug("Branch filter changed. Compared branch: " + oldComparedBranch + ", filtered branch: " + singleFilteredBranch);
            this.stopTaskAndUnhighlight();
            this.notifyUnhighlight(oldComparedBranch);
            return;
        }
        if (refreshHappened) {
            this.stopTask();
            Map map2 = dataPack.getLogProviders();
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"dataPack.logProviders");
            String string = this.comparedBranch;
            Intrinsics.checkNotNull((Object)string);
            Map<GitRepository, GitBranch> repositories2 = this.getRepositories(map2, string);
            if (Intrinsics.areEqual(repositories2, this.repositoriesWithCurrentBranches)) {
                this.startTask(dataPack);
            } else {
                LOG.debug("Repositories with current branches changed. Actual:\n" + repositories2 + "\nExpected:\n" + this.repositoriesWithCurrentBranches);
                this.unhighlight();
            }
        }
    }

    @RequiresEdt
    public final void startTask(@NotNull VcsLogDataPack dataPack, @NotNull String branchToCompare) {
        Intrinsics.checkNotNullParameter((Object)dataPack, (String)"dataPack");
        Intrinsics.checkNotNullParameter((Object)branchToCompare, (String)"branchToCompare");
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.comparedBranch != null) {
            LOG.error("Already comparing with branch " + this.comparedBranch);
            return;
        }
        Map map2 = this.ui.getDataPack().getLogProviders();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"ui.dataPack.logProviders");
        Map<GitRepository, GitBranch> repositories2 = this.getRepositories(map2, branchToCompare);
        if (repositories2.isEmpty()) {
            LOG.debug("Could not find suitable repositories for selected branch " + this.comparedBranch);
            return;
        }
        this.comparedBranch = branchToCompare;
        this.repositoriesWithCurrentBranches = repositories2;
        this.startTask(dataPack);
    }

    @RequiresEdt
    public final void stopTaskAndUnhighlight() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.stopTask();
        this.unhighlight();
    }

    @RequiresEdt
    public final boolean hasHighlightingOrInProgress() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.comparedBranch != null;
    }

    private final void startTask(VcsLogDataPack dataPack) {
        LOG.debug("Highlighting requested for " + this.repositoriesWithCurrentBranches);
        Map<GitRepository, ? extends GitBranch> map2 = this.repositoriesWithCurrentBranches;
        Intrinsics.checkNotNull(map2);
        String string = this.comparedBranch;
        Intrinsics.checkNotNull((Object)string);
        MyTask task = new MyTask(map2, dataPack, string);
        this.progressIndicator = (ProgressIndicator)new BackgroundableProcessIndicator((Task.Backgroundable)task);
        ProgressManager progressManager = ProgressManager.getInstance();
        Task.Backgroundable backgroundable = task;
        ProgressIndicator progressIndicator = this.progressIndicator;
        Intrinsics.checkNotNull((Object)progressIndicator);
        progressManager.runProcessWithProgressAsynchronously(backgroundable, progressIndicator);
    }

    private final void stopTask() {
        if (this.progressIndicator != null) {
            ProgressIndicator progressIndicator = this.progressIndicator;
            Intrinsics.checkNotNull((Object)progressIndicator);
            progressIndicator.cancel();
            this.progressIndicator = null;
        }
    }

    private final void unhighlight() {
        this.nonPickedCommits = null;
        this.comparedBranch = null;
        this.repositoriesWithCurrentBranches = null;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<GitRepository, GitBranch> getRepositories(Map<VirtualFile, ? extends VcsLogProvider> providers, String branchToCompare) {
        GitRepository repository;
        void $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = providers.keySet();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            GitRepository it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl2 = false;
            if ((GitRepository)this.repositoryManager.getRepositoryForRootQuick(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            repository = (GitRepository)element$iv$iv;
            boolean bl = false;
            boolean bl4 = repository.getCurrentBranch() != null && repository.getBranches().findBranchByName(branchToCompare) != null;
            if (!bl4) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associateWith$iv = (List)destination$iv$iv;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            GitLocalBranch gitLocalBranch;
            void it;
            repository = (GitRepository)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it.getCurrentBranch());
            map2.put(t, gitLocalBranch);
        }
        return result$iv;
    }

    private final void notifyUnhighlight(String branch) {
        if (this.ui instanceof VcsLogUiEx) {
            Object[] objectArray = new Object[]{branch};
            String string = GitBundle.message("git.log.cherry.picked.highlighter.cancelled.message", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"git.log.cherry.\u2026ncelled.message\", branch)");
            String message = string;
            Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, null, MessageType.INFO.getPopupBackground(), null).setFadeoutTime(5000L).createBalloon();
            Intrinsics.checkNotNullExpressionValue((Object)balloon, (String)"getInstance().createHtml\u2026\n        .createBalloon()");
            Balloon balloon2 = balloon;
            VcsLogGraphTable vcsLogGraphTable = ((VcsLogUiEx)this.ui).getTable();
            Intrinsics.checkNotNullExpressionValue((Object)vcsLogGraphTable, (String)"ui.table");
            VcsLogGraphTable component2 = vcsLogGraphTable;
            balloon2.show(new RelativePoint((Component)component2, new Point(component2.getWidth() / 2, component2.getVisibleRect().y)), Balloon.Position.below);
            Disposer.register((Disposable)this, (Disposable)((Disposable)balloon2));
        }
    }

    public void dispose() {
        this.stopTaskAndUnhighlight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <R> R recordSpan(VirtualFile root, @NonNls String actionName, Function0<? extends R> block) {
        Object object;
        boolean $i$f$recordSpan = false;
        Tracer tracer$iv = (Tracer)TelemetryManager.Companion.getInstance().getTracer(VcsScopeKt.VcsScope);
        boolean $i$f$computeWithSpan = false;
        SpanBuilder spanBuilder = tracer$iv.spanBuilder(actionName);
        Intrinsics.checkNotNullExpressionValue((Object)spanBuilder, (String)"tracer.spanBuilder(spanName)");
        SpanBuilder $this$useWithScope$iv$iv = spanBuilder;
        boolean $i$f$useWithScope = false;
        Span span$iv$iv = $this$useWithScope$iv$iv.startSpan();
        AutoCloseable autoCloseable = (AutoCloseable)span$iv$iv.makeCurrent();
        Throwable throwable = null;
        try {
            Object object2;
            Scope it$iv$iv = (Scope)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)span$iv$iv, (String)"span");
            Span $this$use$iv$iv$iv = span$iv$iv;
            boolean $i$f$use = false;
            try {
                Span span = $this$use$iv$iv$iv;
                boolean bl2 = false;
                span.setAttribute("rootName", root.getName());
                object2 = block.invoke();
            }
            catch (CancellationException e$iv$iv$iv) {
                throw e$iv$iv$iv;
            }
            catch (ProcessCanceledException e$iv$iv$iv) {
                throw e$iv$iv$iv;
            }
            catch (Throwable e$iv$iv$iv) {
                $this$use$iv$iv$iv.recordException(e$iv$iv$iv);
                $this$use$iv$iv$iv.setStatus(StatusCode.ERROR);
                throw e$iv$iv$iv;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                $this$use$iv$iv$iv.end();
                InlineMarker.finallyEnd((int)1);
            }
            object = object2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            InlineMarker.finallyEnd((int)1);
        }
        return (R)object;
    }

    @JvmStatic
    @NotNull
    public static final DeepComparator getInstance(@NotNull Project project, @NotNull VcsLogData dataProvider, @NotNull VcsLogUi logUi2) {
        return Companion.getInstance(project, dataProvider, logUi2);
    }

    @JvmStatic
    @Nullable
    public static final String getComparedBranchFromFilters(@NotNull VcsLogFilterCollection filters, @NotNull VcsLogRefs refs) {
        return Companion.getComparedBranchFromFilters(filters, refs);
    }

    static {
        Logger logger = Logger.getInstance(DeepComparator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(DeepComparator::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lgit4idea/branch/DeepComparator$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getComparedBranchFromFilters", "", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "refs", "Lcom/intellij/vcs/log/VcsLogRefs;", "getInstance", "Lgit4idea/branch/DeepComparator;", "project", "Lcom/intellij/openapi/project/Project;", "dataProvider", "Lcom/intellij/vcs/log/data/VcsLogData;", "logUi", "Lcom/intellij/vcs/log/VcsLogUi;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DeepComparator getInstance(@NotNull Project project, @NotNull VcsLogData dataProvider, @NotNull VcsLogUi logUi2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dataProvider, (String)"dataProvider");
            Intrinsics.checkNotNullParameter((Object)logUi2, (String)"logUi");
            DeepComparator deepComparator = ((DeepComparatorHolder)project.getService(DeepComparatorHolder.class)).getInstance(dataProvider, logUi2);
            Intrinsics.checkNotNullExpressionValue((Object)deepComparator, (String)"project.getService(DeepC\u2026ance(dataProvider, logUi)");
            return deepComparator;
        }

        @JvmStatic
        @Nullable
        public final String getComparedBranchFromFilters(@NotNull VcsLogFilterCollection filters, @NotNull VcsLogRefs refs) {
            Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
            Intrinsics.checkNotNullParameter((Object)refs, (String)"refs");
            String singleFilteredBranch = VcsLogUtil.getSingleFilteredBranch((VcsLogFilterCollection)filters, (VcsLogRefs)refs);
            if (singleFilteredBranch != null) {
                return singleFilteredBranch;
            }
            VcsLogRangeFilter vcsLogRangeFilter = (VcsLogRangeFilter)filters.get(VcsLogFilterCollection.RANGE_FILTER);
            if (vcsLogRangeFilter == null) {
                return null;
            }
            VcsLogRangeFilter rangeFilter = vcsLogRangeFilter;
            VcsLogRangeFilter.RefRange refRange = (VcsLogRangeFilter.RefRange)CollectionsKt.singleOrNull((List)rangeFilter.getRanges());
            return refRange != null ? refRange.getInclusiveRef() : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lgit4idea/branch/DeepComparator$Factory;", "Lcom/intellij/vcs/log/ui/highlighters/VcsLogHighlighterFactory;", "()V", "createHighlighter", "Lcom/intellij/vcs/log/VcsLogHighlighter;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "logUi", "Lcom/intellij/vcs/log/VcsLogUi;", "getId", "", "getTitle", "showMenuItem", "", "intellij.vcs.git"})
    public static final class Factory
    implements VcsLogHighlighterFactory {
        @NotNull
        public VcsLogHighlighter createHighlighter(@NotNull VcsLogData logData, @NotNull VcsLogUi logUi2) {
            Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
            Intrinsics.checkNotNullParameter((Object)logUi2, (String)"logUi");
            Project project = logData.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"logData.project");
            return Companion.getInstance(project, logData, logUi2);
        }

        @NotNull
        public String getId() {
            return "CHERRY_PICKED_COMMITS";
        }

        @NotNull
        public String getTitle() {
            String string = GitBundle.message("action.Git.Log.DeepCompare.text", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"action.Git.Log.DeepCompare.text\")");
            return string;
        }

        public boolean showMenuItem() {
            return false;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B)\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\tH\u0002J \u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tH\u0002J \u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\tH\u0002J \u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0002J<\u0010\u001b\u001a\u0004\u0018\u00010\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020#H\u0016J\u0010\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\tH\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lgit4idea/branch/DeepComparator$MyTask;", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "repositoriesWithCurrentBranches", "", "Lgit4idea/repo/GitRepository;", "Lgit4idea/GitBranch;", "vcsLogDataPack", "Lcom/intellij/vcs/log/VcsLogDataPack;", "comparedBranch", "", "(Lgit4idea/branch/DeepComparator;Ljava/util/Map;Lcom/intellij/vcs/log/VcsLogDataPack;Ljava/lang/String;)V", "collectedNonPickedCommits", "Lit/unimi/dsi/fastutil/ints/IntOpenHashSet;", "dataPack", "Lcom/intellij/vcs/log/data/DataPack;", "exception", "Lcom/intellij/openapi/vcs/VcsException;", "getCommitsByIndexFast", "Lit/unimi/dsi/fastutil/ints/IntSet;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "sourceBranch", "getCommitsByIndexReliable", "targetBranch", "getCommitsByPatch", "getCommitsFromGit", "currentBranch", "getCommitsFromIndex", "sourceBranchRef", "Lcom/intellij/vcs/log/VcsRef;", "targetBranchRef", "sourceBranchCommits", "reliable", "", "onFinished", "", "onSuccess", "run", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "toString", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nDeepComparator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeepComparator.kt\ngit4idea/branch/DeepComparator$MyTask\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 DeepComparator.kt\ngit4idea/branch/DeepComparator\n+ 4 trace.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/TraceKt\n+ 5 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,366:1\n215#2,2:367\n361#3:369\n362#3,2:376\n361#3:389\n362#3,2:396\n361#3:409\n362#3,2:416\n63#4:370\n21#4,3:371\n101#4,2:374\n116#4:378\n104#4,10:379\n63#4:390\n21#4,3:391\n101#4,2:394\n116#4:398\n104#4,10:399\n63#4:410\n21#4,3:411\n101#4,2:414\n116#4:418\n104#4,10:419\n107#5:429\n79#5,22:430\n*S KotlinDebug\n*F\n+ 1 DeepComparator.kt\ngit4idea/branch/DeepComparator$MyTask\n*L\n193#1:367,2\n233#1:369\n233#1:376,2\n243#1:389\n243#1:396,2\n255#1:409\n255#1:416,2\n233#1:370\n233#1:371,3\n233#1:374,2\n233#1:378\n233#1:379,10\n243#1:390\n243#1:391,3\n243#1:394,2\n243#1:398\n243#1:399,10\n255#1:410\n255#1:411,3\n255#1:414,2\n255#1:418\n255#1:419,10\n277#1:429\n277#1:430,22\n*E\n"})
    private final class MyTask
    extends Task.Backgroundable {
        @NotNull
        private final Map<GitRepository, GitBranch> repositoriesWithCurrentBranches;
        @NotNull
        private final String comparedBranch;
        @Nullable
        private final DataPack dataPack;
        @NotNull
        private final IntOpenHashSet collectedNonPickedCommits;
        @Nullable
        private VcsException exception;

        public MyTask(@NotNull Map<GitRepository, ? extends GitBranch> repositoriesWithCurrentBranches, @NotNull VcsLogDataPack vcsLogDataPack, String comparedBranch) {
            Intrinsics.checkNotNullParameter(repositoriesWithCurrentBranches, (String)"repositoriesWithCurrentBranches");
            Intrinsics.checkNotNullParameter((Object)vcsLogDataPack, (String)"vcsLogDataPack");
            Intrinsics.checkNotNullParameter((Object)comparedBranch, (String)"comparedBranch");
            super(DeepComparator.this.project, GitBundle.message("git.log.cherry.picked.highlighter.process", new Object[0]));
            this.repositoriesWithCurrentBranches = repositoriesWithCurrentBranches;
            this.comparedBranch = comparedBranch;
            VisiblePack visiblePack = vcsLogDataPack instanceof VisiblePack ? (VisiblePack)vcsLogDataPack : null;
            DataPackBase dataPackBase = visiblePack != null ? visiblePack.getDataPack() : null;
            this.dataPack = dataPackBase instanceof DataPack ? (DataPack)dataPackBase : null;
            this.collectedNonPickedCommits = new IntOpenHashSet();
        }

        public void run(@NotNull ProgressIndicator indicator) {
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            try {
                Map<GitRepository, GitBranch> $this$forEach$iv = this.repositoriesWithCurrentBranches;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<GitRepository, GitBranch>> iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    IntSet intSet;
                    Map.Entry<GitRepository, GitBranch> element$iv;
                    Map.Entry<GitRepository, GitBranch> entry = element$iv = iterator.next();
                    boolean bl = false;
                    GitRepository repo = entry.getKey();
                    GitBranch currentBranch = entry.getValue();
                    if (Registry.is((String)"git.log.use.index.for.picked.commits.highlighting")) {
                        if (Registry.is((String)"git.log.fast.picked.commits.highlighting")) {
                            VirtualFile virtualFile = repo.getRoot();
                            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"repo.root");
                            intSet = this.getCommitsByIndexFast(virtualFile, this.comparedBranch);
                            if (intSet == null) {
                                VirtualFile virtualFile2 = repo.getRoot();
                                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"repo.root");
                                String string = currentBranch.getName();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"currentBranch.name");
                                intSet = this.getCommitsByIndexReliable(virtualFile2, this.comparedBranch, string);
                            }
                        } else {
                            VirtualFile virtualFile = repo.getRoot();
                            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"repo.root");
                            String string = currentBranch.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"currentBranch.name");
                            intSet = this.getCommitsByIndexReliable(virtualFile, this.comparedBranch, string);
                        }
                    } else {
                        VirtualFile virtualFile = repo.getRoot();
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"repo.root");
                        String string = currentBranch.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"currentBranch.name");
                        intSet = this.getCommitsByPatch(virtualFile, this.comparedBranch, string);
                    }
                    IntSet commits2 = intSet;
                    this.collectedNonPickedCommits.addAll((IntCollection)commits2);
                }
            }
            catch (VcsException e) {
                LOG.warn((Throwable)e);
                this.exception = e;
            }
        }

        public void onFinished() {
            DeepComparator.this.progressIndicator = null;
        }

        public void onSuccess() {
            if (this.exception != null) {
                DeepComparator.this.nonPickedCommits = null;
                VcsNotifier vcsNotifier = VcsNotifier.getInstance((Project)this.getProject());
                Object[] objectArray = new Object[]{this.comparedBranch};
                String string = GitBundle.message("git.log.cherry.picked.highlighter.error.message", objectArray);
                VcsException vcsException = this.exception;
                Intrinsics.checkNotNull((Object)((Object)vcsException));
                vcsNotifier.notifyError("git.could.not.compare.with.branch", string, vcsException.getMessage());
                return;
            }
            DeepComparator.this.nonPickedCommits = this.collectedNonPickedCommits;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final IntSet getCommitsByPatch(VirtualFile root, String targetBranch, String sourceBranch) throws VcsException {
            IntSet intSet;
            DeepComparator deepComparator = DeepComparator.this;
            String actionName$iv = "Getting non picked commits with git";
            boolean $i$f$recordSpan = false;
            Tracer tracer$iv$iv = (Tracer)TelemetryManager.Companion.getInstance().getTracer(VcsScopeKt.VcsScope);
            boolean $i$f$computeWithSpan = false;
            SpanBuilder spanBuilder = tracer$iv$iv.spanBuilder(actionName$iv);
            Intrinsics.checkNotNullExpressionValue((Object)spanBuilder, (String)"tracer.spanBuilder(spanName)");
            SpanBuilder $this$useWithScope$iv$iv$iv = spanBuilder;
            boolean $i$f$useWithScope = false;
            Span span$iv$iv$iv = $this$useWithScope$iv$iv$iv.startSpan();
            AutoCloseable autoCloseable = (AutoCloseable)span$iv$iv$iv.makeCurrent();
            Throwable throwable = null;
            try {
                IntSet intSet2;
                Scope it$iv$iv$iv = (Scope)autoCloseable;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)span$iv$iv$iv, (String)"span");
                Span $this$use$iv$iv$iv$iv = span$iv$iv$iv;
                boolean $i$f$use = false;
                try {
                    Span span$iv = $this$use$iv$iv$iv$iv;
                    boolean bl2 = false;
                    span$iv.setAttribute("rootName", root.getName());
                    boolean bl3 = false;
                    intSet2 = this.getCommitsFromGit(root, targetBranch, sourceBranch);
                }
                catch (CancellationException e$iv$iv$iv$iv) {
                    throw e$iv$iv$iv$iv;
                }
                catch (ProcessCanceledException e$iv$iv$iv$iv) {
                    throw e$iv$iv$iv$iv;
                }
                catch (Throwable e$iv$iv$iv$iv) {
                    $this$use$iv$iv$iv$iv.recordException(e$iv$iv$iv$iv);
                    $this$use$iv$iv$iv$iv.setStatus(StatusCode.ERROR);
                    throw e$iv$iv$iv$iv;
                }
                finally {
                    $this$use$iv$iv$iv$iv.end();
                }
                intSet = intSet2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            return intSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final IntSet getCommitsByIndexReliable(VirtualFile root, String sourceBranch, String targetBranch) throws VcsException {
            IntSet resultFromIndex;
            IntSet intSet;
            IntSet resultFromGit = this.getCommitsByPatch(root, targetBranch, sourceBranch);
            if (this.dataPack == null) return resultFromGit;
            if (!this.dataPack.isFull()) {
                return resultFromGit;
            }
            DeepComparator deepComparator = DeepComparator.this;
            String actionName$iv = "Getting non picked commits with index reliable";
            boolean $i$f$recordSpan = false;
            Tracer tracer$iv$iv = (Tracer)TelemetryManager.Companion.getInstance().getTracer(VcsScopeKt.VcsScope);
            boolean $i$f$computeWithSpan = false;
            SpanBuilder spanBuilder = tracer$iv$iv.spanBuilder(actionName$iv);
            Intrinsics.checkNotNullExpressionValue((Object)spanBuilder, (String)"tracer.spanBuilder(spanName)");
            SpanBuilder $this$useWithScope$iv$iv$iv = spanBuilder;
            boolean $i$f$useWithScope = false;
            Span span$iv$iv$iv = $this$useWithScope$iv$iv$iv.startSpan();
            AutoCloseable autoCloseable = (AutoCloseable)span$iv$iv$iv.makeCurrent();
            Throwable throwable = null;
            try {
                IntSet intSet2;
                Scope it$iv$iv$iv = (Scope)autoCloseable;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)span$iv$iv$iv, (String)"span");
                Span $this$use$iv$iv$iv$iv = span$iv$iv$iv;
                boolean $i$f$use = false;
                try {
                    VcsRef vcsRef;
                    VcsRef vcsRef2;
                    Span span$iv = $this$use$iv$iv$iv$iv;
                    boolean bl2 = false;
                    span$iv.setAttribute("rootName", root.getName());
                    boolean bl3 = false;
                    RefsModel refsModel = this.dataPack.getRefsModel();
                    Intrinsics.checkNotNullExpressionValue((Object)refsModel, (String)"dataPack.refsModel");
                    if (DataPackUtilKt.findBranch((RefsModel)refsModel, (String)sourceBranch, (VirtualFile)root) == null) {
                        IntSet intSet3 = resultFromGit;
                        IntSet intSet4 = intSet3;
                        return intSet4;
                    }
                    VcsRef sourceBranchRef = vcsRef2;
                    RefsModel refsModel2 = this.dataPack.getRefsModel();
                    Intrinsics.checkNotNullExpressionValue((Object)refsModel2, (String)"dataPack.refsModel");
                    if (DataPackUtilKt.findBranch((RefsModel)refsModel2, (String)"HEAD", (VirtualFile)root) == null) {
                        IntSet intSet5 = resultFromGit;
                        IntSet intSet6 = intSet5;
                        return intSet6;
                    }
                    VcsRef targetBranchRef = vcsRef;
                    intSet2 = this.getCommitsFromIndex(this.dataPack, root, sourceBranchRef, targetBranchRef, resultFromGit, true);
                }
                catch (CancellationException e$iv$iv$iv$iv) {
                    throw e$iv$iv$iv$iv;
                }
                catch (ProcessCanceledException e$iv$iv$iv$iv) {
                    throw e$iv$iv$iv$iv;
                }
                catch (Throwable e$iv$iv$iv$iv) {
                    $this$use$iv$iv$iv$iv.recordException(e$iv$iv$iv$iv);
                    $this$use$iv$iv$iv$iv.setStatus(StatusCode.ERROR);
                    throw e$iv$iv$iv$iv;
                }
                finally {
                    $this$use$iv$iv$iv$iv.end();
                }
                intSet = intSet2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            IntSet intSet7 = resultFromIndex = intSet;
            IntSet intSet8 = intSet7;
            if (intSet7 != null) return intSet8;
            intSet8 = resultFromGit;
            return intSet8;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final IntSet getCommitsByIndexFast(VirtualFile root, String sourceBranch) {
            void actionName$iv;
            if (!DeepComparator.this.vcsLogData.getIndex().isIndexed(root)) return null;
            if (this.dataPack == null) return null;
            if (!this.dataPack.isFull()) {
                return null;
            }
            DeepComparator deepComparator = DeepComparator.this;
            String string = "Getting non picked commits with index fast";
            DeepComparator deepComparator2 = DeepComparator.this;
            boolean $i$f$recordSpan = false;
            Tracer tracer$iv$iv = (Tracer)TelemetryManager.Companion.getInstance().getTracer(VcsScopeKt.VcsScope);
            boolean $i$f$computeWithSpan = false;
            SpanBuilder spanBuilder = tracer$iv$iv.spanBuilder((String)actionName$iv);
            Intrinsics.checkNotNullExpressionValue((Object)spanBuilder, (String)"tracer.spanBuilder(spanName)");
            SpanBuilder $this$useWithScope$iv$iv$iv = spanBuilder;
            boolean $i$f$useWithScope = false;
            Span span$iv$iv$iv = $this$useWithScope$iv$iv$iv.startSpan();
            AutoCloseable autoCloseable = (AutoCloseable)span$iv$iv$iv.makeCurrent();
            Throwable throwable = null;
            try {
                IntSet intSet;
                Scope it$iv$iv$iv = (Scope)autoCloseable;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)span$iv$iv$iv, (String)"span");
                Span $this$use$iv$iv$iv$iv = span$iv$iv$iv;
                boolean $i$f$use = false;
                try {
                    IntSet intSet2;
                    VcsRef vcsRef;
                    VcsRef vcsRef2;
                    Span span$iv = $this$use$iv$iv$iv$iv;
                    boolean bl2 = false;
                    span$iv.setAttribute("rootName", root.getName());
                    boolean bl3 = false;
                    RefsModel refsModel = this.dataPack.getRefsModel();
                    Intrinsics.checkNotNullExpressionValue((Object)refsModel, (String)"dataPack.refsModel");
                    if (DataPackUtilKt.findBranch((RefsModel)refsModel, (String)sourceBranch, (VirtualFile)root) == null) {
                        IntSet intSet3 = null;
                        IntSet intSet4 = intSet3;
                        return intSet4;
                    }
                    VcsRef sourceBranchRef = vcsRef2;
                    RefsModel refsModel2 = this.dataPack.getRefsModel();
                    Intrinsics.checkNotNullExpressionValue((Object)refsModel2, (String)"dataPack.refsModel");
                    if (DataPackUtilKt.findBranch((RefsModel)refsModel2, (String)"HEAD", (VirtualFile)root) == null) {
                        IntSet intSet5 = null;
                        IntSet intSet6 = intSet5;
                        return intSet6;
                    }
                    VcsRef targetBranchRef = vcsRef;
                    if (DataPackUtilKt.subgraphDifference((DataPack)this.dataPack, (VcsRef)sourceBranchRef, (VcsRef)targetBranchRef, (VcsLogStorage)deepComparator2.getStorage()) == null) {
                        IntSet intSet7 = null;
                        IntSet intSet8 = intSet7;
                        return intSet8;
                    }
                    IntSet sourceBranchCommits = intSet2;
                    intSet = this.getCommitsFromIndex(this.dataPack, root, sourceBranchRef, targetBranchRef, sourceBranchCommits, false);
                }
                catch (CancellationException e$iv$iv$iv$iv) {
                    throw e$iv$iv$iv$iv;
                }
                catch (ProcessCanceledException e$iv$iv$iv$iv) {
                    throw e$iv$iv$iv$iv;
                }
                catch (Throwable e$iv$iv$iv$iv) {
                    $this$use$iv$iv$iv$iv.recordException(e$iv$iv$iv$iv);
                    $this$use$iv$iv$iv$iv.setStatus(StatusCode.ERROR);
                    throw e$iv$iv$iv$iv;
                }
                finally {
                    $this$use$iv$iv$iv$iv.end();
                }
                IntSet intSet9 = intSet;
                return intSet9;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }

        private final IntSet getCommitsFromGit(VirtualFile root, String currentBranch, String comparedBranch) throws VcsException {
            GitLineHandler handler = new GitLineHandler(this.getProject(), root, GitCommand.CHERRY);
            String[] stringArray = new String[]{currentBranch, comparedBranch};
            handler.addParameters(stringArray);
            IntOpenHashSet pickedCommits = new IntOpenHashSet();
            handler.addLineListener((arg_0, arg_1) -> MyTask.getCommitsFromGit$lambda$5(pickedCommits, DeepComparator.this, root, arg_0, arg_1));
            Git.getInstance().runCommandWithoutCollectingOutput(handler).throwOnError(new int[0]);
            return (IntSet)pickedCommits;
        }

        private final IntSet getCommitsFromIndex(DataPack dataPack, VirtualFile root, VcsRef sourceBranchRef, VcsRef targetBranchRef, IntSet sourceBranchCommits, boolean reliable) {
            if (dataPack == null) {
                return null;
            }
            if (sourceBranchCommits.isEmpty()) {
                return sourceBranchCommits;
            }
            if (!DeepComparator.this.vcsLogData.getIndex().isIndexed(root)) {
                return null;
            }
            IndexDataGetter indexDataGetter = DeepComparator.this.vcsLogData.getIndex().getDataGetter();
            if (indexDataGetter == null) {
                return null;
            }
            IndexDataGetter dataGetter = indexDataGetter;
            IntSet intSet = DataPackUtilKt.subgraphDifference((DataPack)dataPack, (VcsRef)targetBranchRef, (VcsRef)sourceBranchRef, (VcsLogStorage)DeepComparator.this.getStorage());
            if (intSet == null) {
                return null;
            }
            IntSet targetBranchCommits = intSet;
            if (targetBranchCommits.isEmpty()) {
                return sourceBranchCommits;
            }
            IntSet match = GitCompareUtilKt.match(dataGetter, root, sourceBranchCommits, targetBranchCommits, reliable);
            sourceBranchCommits.removeAll((IntCollection)match);
            if (!match.isEmpty()) {
                LOG.debug("Using index, detected " + match.size() + " commits in " + sourceBranchRef.getName() + "#" + root.getName() + " that were picked to the current branch" + (reliable ? " with different patch id but matching cherry-picked suffix" : " with matching author, author time and message"));
            }
            return sourceBranchCommits;
        }

        @NotNull
        public String toString() {
            return "Task for '" + this.comparedBranch + "' in " + this.repositoriesWithCurrentBranches;
        }

        /*
         * WARNING - void declaration
         */
        private static final void getCommitsFromGit$lambda$5(IntOpenHashSet $pickedCommits, DeepComparator this$0, VirtualFile $root, String l, Key key) {
            String line;
            Intrinsics.checkNotNullParameter((Object)$pickedCommits, (String)"$pickedCommits");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$root, (String)"$root");
            String string = line = l;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"line");
            if (StringsKt.startsWith$default((String)string, (String)"+", (boolean)false, (int)2, null)) {
                try {
                    void $this$trim$iv;
                    String string2 = line;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"line");
                    String string3 = string2;
                    int n = 2;
                    String string4 = string3.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
                    string3 = string4;
                    boolean $i$f$trim = false;
                    CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                    boolean $i$f$trim2 = false;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    String string5 = line = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"line");
                    int firstSpace = StringsKt.indexOf$default((CharSequence)string5, (char)' ', (int)0, (boolean)false, (int)6, null);
                    if (firstSpace > 0) {
                        String string6 = line;
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"line");
                        String string7 = string6;
                        int n2 = 0;
                        String string8 = string7.substring(n2, firstSpace);
                        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        line = string8;
                    }
                    VcsLogStorage vcsLogStorage = this$0.getStorage();
                    Hash hash = HashImpl.build((String)line);
                    Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"build(line)");
                    $pickedCommits.add(vcsLogStorage.getCommitIndex(hash, $root));
                }
                catch (Exception e) {
                    LOG.error("Couldn't parse line [" + line + "]", (Throwable)e);
                }
            }
        }
    }
}

