/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.io.PathKt;
import git4idea.FsMonitor;
import git4idea.config.GitConfigUtil;
import git4idea.repo.GitRepository;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0002H\u0002\u00a8\u0006\u0005"}, d2={"detectFsMonitor", "Lgit4idea/FsMonitor;", "Lgit4idea/repo/GitRepository;", "isWorkTreeUsed", "", "intellij.vcs.git"})
public final class GitStatisticsCollectorKt {
    private static final boolean isWorkTreeUsed(GitRepository $this$isWorkTreeUsed) {
        boolean bl;
        try {
            Path path = $this$isWorkTreeUsed.getRoot().toNioPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"this.root.toNioPath()");
            Path rootPath = path;
            String[] stringArray = new String[]{".git"};
            Path dotGit = Path.of(((Object)rootPath).toString(), stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)dotGit, (String)"dotGit");
            if (PathKt.isFile((Path)dotGit)) {
                return true;
            }
            Path worktreesPath = $this$isWorkTreeUsed.getRepositoryFiles().getWorktreesDirFile().toPath();
            Intrinsics.checkNotNullExpressionValue((Object)worktreesPath, (String)"worktreesPath");
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(worktreesPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                return false;
            }
            if (!PathKt.isDirectory((Path)worktreesPath)) {
                return false;
            }
            bl = Files.list(worktreesPath).count() > 0L;
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    private static final FsMonitor detectFsMonitor(GitRepository $this$detectFsMonitor) {
        try {
            boolean useBuiltIn;
            Boolean bl = GitConfigUtil.getBooleanValue(GitConfigUtil.getValue($this$detectFsMonitor.getProject(), $this$detectFsMonitor.getRoot(), "core.useBuiltinFSMonitor"));
            if (bl == null) {
                bl = false;
            }
            if (useBuiltIn = bl.booleanValue()) {
                return FsMonitor.BUILTIN;
            }
            String fsMonitorHook = GitConfigUtil.getValue($this$detectFsMonitor.getProject(), $this$detectFsMonitor.getRoot(), "core.fsmonitor");
            if (fsMonitorHook != null && !Intrinsics.areEqual((Object)GitConfigUtil.getBooleanValue(fsMonitorHook), (Object)false)) {
                return FsMonitor.EXTERNAL_FS_MONITOR;
            }
        }
        catch (VcsException vcsException) {
            // empty catch block
        }
        return FsMonitor.NONE;
    }

    public static final /* synthetic */ boolean access$isWorkTreeUsed(GitRepository $receiver) {
        return GitStatisticsCollectorKt.isWorkTreeUsed($receiver);
    }

    public static final /* synthetic */ FsMonitor access$detectFsMonitor(GitRepository $receiver) {
        return GitStatisticsCollectorKt.detectFsMonitor($receiver);
    }
}

