/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.profile;

import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.staticAnalysis.inspections.config.QodanaConfig;
import org.jetbrains.qodana.staticAnalysis.profile.FileAndModule;
import org.jetbrains.qodana.staticAnalysis.profile.ProblemCounters;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00132\b\u0010\u001b\u001a\u0004\u0018\u00010\u0013J\"\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00132\b\u0010\u001b\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001f\u001a\u00020\u0013J\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001d0!2\u0006\u0010\"\u001a\u00020\u0013J\u001a\u0010#\u001a\u00020$2\b\u0010\u001a\u001a\u0004\u0018\u00010\u00132\b\u0010\u001b\u001a\u0004\u0018\u00010\u0013J\u0006\u0010%\u001a\u00020$R\u0019\u0010\u0006\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\f0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\f0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006&"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/profile/ProblemCounters;", "", "config", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig;", "project", "Lcom/intellij/openapi/project/Project;", "inspectionToolWrapper", "Lcom/intellij/codeInspection/ex/InspectionToolWrapper;", "(Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig;Lcom/intellij/openapi/project/Project;Lcom/intellij/codeInspection/ex/InspectionToolWrapper;)V", "getInspectionToolWrapper", "()Lcom/intellij/codeInspection/ex/InspectionToolWrapper;", "maxPerFile", "", "maxPerModule", "maxPerProject", "perFile", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/qodana/staticAnalysis/profile/FileAndModule;", "perModule", "", "perProject", "Ljava/util/concurrent/atomic/AtomicInteger;", "getProject", "()Lcom/intellij/openapi/project/Project;", "addProblem", "", "relativePath", "module", "constructServiceMessage", "Lorg/jdom/Element;", "file", "message", "constructServiceMessages", "", "id", "isThresholdReached", "", "wasAnyThresholdReached", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nSanityInspectionGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SanityInspectionGroup.kt\norg/jetbrains/qodana/staticAnalysis/profile/ProblemCounters\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,232:1\n187#2,3:233\n187#2,3:236\n766#3:239\n857#3,2:240\n1549#3:242\n1620#3,3:243\n766#3:246\n857#3,2:247\n1549#3:249\n1620#3,3:250\n766#3:253\n857#3,2:254\n1549#3:256\n1620#3,3:257\n*S KotlinDebug\n*F\n+ 1 SanityInspectionGroup.kt\norg/jetbrains/qodana/staticAnalysis/profile/ProblemCounters\n*L\n141#1:233,3\n143#1:236,3\n162#1:239\n162#1:240,2\n162#1:242\n162#1:243,3\n164#1:246\n164#1:247,2\n165#1:249\n165#1:250,3\n180#1:253\n180#1:254,2\n181#1:256\n181#1:257,3\n*E\n"})
final class ProblemCounters {
    @NotNull
    private final Project project;
    @NotNull
    private final InspectionToolWrapper<?, ?> inspectionToolWrapper;
    @NotNull
    private final ConcurrentHashMap<FileAndModule, Integer> perFile;
    @NotNull
    private final ConcurrentHashMap<String, Integer> perModule;
    @NotNull
    private final AtomicInteger perProject;
    private final int maxPerFile;
    private final int maxPerModule;
    private final int maxPerProject;

    public ProblemCounters(@NotNull QodanaConfig config, @NotNull Project project2, @NotNull InspectionToolWrapper<?, ?> inspectionToolWrapper) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(inspectionToolWrapper, (String)"inspectionToolWrapper");
        this.project = project2;
        this.inspectionToolWrapper = inspectionToolWrapper;
        this.perFile = new ConcurrentHashMap();
        this.perModule = new ConcurrentHashMap();
        this.perProject = new AtomicInteger(0);
        this.maxPerFile = config.getFileSuspendThreshold();
        this.maxPerModule = config.getModuleSuspendThreshold();
        this.maxPerProject = config.getProjectSuspendThreshold();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final InspectionToolWrapper<?, ?> getInspectionToolWrapper() {
        return this.inspectionToolWrapper;
    }

    public final void addProblem(@Nullable String relativePath, @Nullable String module2) {
        if (relativePath != null) {
            String string = module2;
            if (string == null) {
                string = "";
            }
            this.perFile.compute(new FileAndModule(relativePath, string), addProblem.1.INSTANCE);
        }
        if (module2 != null) {
            this.perModule.compute(module2, addProblem.2.INSTANCE);
        }
        this.perProject.incrementAndGet();
    }

    public final boolean isThresholdReached(@Nullable String relativePath, @Nullable String module2) {
        if (this.maxPerProject > 0 && this.perProject.get() >= this.maxPerProject) {
            return true;
        }
        if (module2 != null && this.maxPerModule > 0) {
            Integer n = this.perModule.get(module2);
            if (n == null) {
                n = 0;
            }
            if (((Number)n).intValue() >= this.maxPerModule) {
                return true;
            }
        }
        if (relativePath != null && this.maxPerFile > 0) {
            Integer n;
            String string = module2;
            if (string == null) {
                string = "";
            }
            if ((n = this.perFile.get(new FileAndModule(relativePath, string))) == null) {
                n = 0;
            }
            if (((Number)n).intValue() >= this.maxPerFile) {
                return true;
            }
        }
        return false;
    }

    public final boolean wasAnyThresholdReached() {
        Map.Entry it;
        Map.Entry element$iv;
        Iterator iterator;
        boolean $i$f$any;
        Map $this$any$iv;
        if (this.maxPerProject > 0 && this.perProject.get() >= this.maxPerProject) {
            return true;
        }
        if (this.maxPerModule > 0) {
            boolean bl;
            block11: {
                $this$any$iv = this.perModule;
                $i$f$any = false;
                if ($this$any$iv.isEmpty()) {
                    bl = false;
                } else {
                    iterator = $this$any$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        it = element$iv = iterator.next();
                        boolean bl2 = false;
                        if (!(((Number)it.getValue()).intValue() >= this.maxPerModule)) continue;
                        bl = true;
                        break block11;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return true;
            }
        }
        if (this.maxPerFile > 0) {
            boolean bl;
            block12: {
                $this$any$iv = this.perFile;
                $i$f$any = false;
                if ($this$any$iv.isEmpty()) {
                    bl = false;
                } else {
                    iterator = $this$any$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        it = element$iv = iterator.next();
                        boolean bl3 = false;
                        if (!(((Number)it.getValue()).intValue() >= this.maxPerFile)) continue;
                        bl = true;
                        break block12;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Element> constructServiceMessages(@NotNull String id) {
        int fileThreshold;
        Collection destination$iv$iv;
        Collection<Element> collection;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        if (this.maxPerProject > 0 && this.perProject.get() >= this.maxPerProject) {
            Object[] objectArray = new Object[]{id, this.perProject.get(), this.maxPerProject};
            String string = QodanaBundle.message("inspection.message.inspection.suppressed.on.project", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\n        \"inspec\u2026),\n        maxPerProject)");
            String message = string;
            return CollectionsKt.listOf((Object)this.constructServiceMessage(null, null, message));
        }
        List result = new ArrayList();
        List reportedModules = new ArrayList();
        int moduleThreshold = this.maxPerModule;
        if (moduleThreshold > 0) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Object object;
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv2;
            Set<Map.Entry<String, Integer>> set = this.perModule.entrySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"perModule.entries");
            Iterable iterable = set;
            collection = reportedModules;
            boolean $i$f$filter = false;
            void var7_12 = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                object = (Map.Entry)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"(_, v)");
                Integer v = (Integer)object.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)v, (String)"v");
                if (!(v >= moduleThreshold)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv2 = (List)destination$iv$iv2;
            boolean $i$f$map22 = false;
            $this$filterTo$iv$iv2 = $this$map$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                object = (Map.Entry)item$iv$iv;
                Collection collection2 = destination$iv$iv2;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"(k, _)");
                String k = (String)object.getKey();
                Intrinsics.checkNotNullExpressionValue((Object)k, (String)"k");
                collection2.add(k);
            }
            collection.addAll((List)destination$iv$iv2);
            Set<Map.Entry<String, Integer>> set2 = this.perModule.entrySet();
            Intrinsics.checkNotNullExpressionValue(set2, (String)"perModule.entries");
            Iterable $i$f$map22 = set2;
            boolean $i$f$filter2 = false;
            destination$iv$iv2 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Map.Entry bl = (Map.Entry)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"(_, v)");
                Integer v = (Integer)bl.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)v, (String)"v");
                if (!(v >= moduleThreshold)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String message;
                Map.Entry bl = (Map.Entry)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"(module, counter)");
                String module2 = (String)bl.getKey();
                Integer counter = (Integer)bl.getValue();
                Object[] objectArray = new Object[]{id, module2, counter, moduleThreshold};
                Intrinsics.checkNotNullExpressionValue((Object)QodanaBundle.message("inspection.message.inspection.suppressed.on.module", objectArray), (String)"message(\n            \"in\u2026         moduleThreshold)");
                collection.add(this.constructServiceMessage(null, module2, message));
            }
            List problems2 = (List)destination$iv$iv;
            result.addAll(problems2);
        }
        if ((fileThreshold = this.maxPerFile) > 0) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Set<Map.Entry<FileAndModule, Integer>> set = this.perFile.entrySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"perFile.entries");
            Iterable $i$f$map = set;
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Map.Entry entry = (Map.Entry)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"(k, v)");
                FileAndModule k = (FileAndModule)entry.getKey();
                Integer v = (Integer)entry.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)v, (String)"v");
                if (!(v >= fileThreshold && !reportedModules.contains(k.getModule()))) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv3;
            boolean $i$f$map2 = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String message;
                Map.Entry entry = (Map.Entry)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"(file, counter)");
                FileAndModule file = (FileAndModule)entry.getKey();
                Integer counter = (Integer)entry.getValue();
                Object[] objectArray = new Object[]{id, file.getFile(), counter, fileThreshold};
                Intrinsics.checkNotNullExpressionValue((Object)QodanaBundle.message("inspection.message.inspection.suppressed.on.file", objectArray), (String)"message(\n            \"in\u2026           fileThreshold)");
                collection.add(this.constructServiceMessage(file.getFile(), file.getModule(), message));
            }
            List problems3 = (List)destination$iv$iv3;
            result.addAll(problems3);
        }
        return result;
    }

    @NotNull
    public final Element constructServiceMessage(@Nullable String file, @Nullable String module2, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Element element2 = new Element("problem");
        if (file != null) {
            element2.addContent(new Element("file").addContent(file));
        }
        if (module2 != null) {
            element2.addContent(new Element("module").addContent(module2));
        }
        Element problem_class = new Element("problem_class").setAttribute("severity", "ERROR").setAttribute("id", "QodanaServiceMessage").setAttribute("attribute_key", "-").addContent("Qodana service message");
        element2.addContent(problem_class);
        Element entry_point = new Element("entry_point");
        if (file != null) {
            entry_point.setAttribute("TYPE", "file");
            entry_point.setAttribute("FQNAME", file);
        } else if (module2 != null) {
            entry_point.setAttribute("TYPE", "module");
            entry_point.setAttribute("FQNAME", module2);
        } else {
            entry_point.setAttribute("TYPE", "project");
            entry_point.setAttribute("FQNAME", this.project.getName());
        }
        element2.addContent(entry_point);
        element2.addContent(new Element("description").addContent(message));
        return element2;
    }
}

