/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.inspections.config;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.InterruptibleKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.staticAnalysis.Static_analysis_dispatchersKt;
import org.jetbrains.qodana.staticAnalysis.inspections.config.InspectScope;
import org.jetbrains.qodana.staticAnalysis.inspections.config.QodanaConfig;
import org.jetbrains.qodana.staticAnalysis.inspections.config.QodanaProfileConfig;
import org.jetbrains.qodana.staticAnalysis.inspections.config.QodanaYamlConfig;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.GitIgnoreExcludeScopeModifier;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.GlobalExcludeScopeModifier;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.OutputFormat;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.CustomClassLoaderConstructor;
import org.yaml.snakeyaml.introspector.BeanAccess;
import org.yaml.snakeyaml.representer.Representer;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a\u0019\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001d\u001a\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001f\u001a\u00020\u001c\u001a\b\u0010 \u001a\u00020\u0001H\u0002\u001a\u0016\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$\u001a/\u0010%\u001a\u0002H&\"\u0004\b\u0000\u0010&2\u0006\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H&0*2\u0006\u0010+\u001a\u0002H&\u00a2\u0006\u0002\u0010,\u001a/\u0010%\u001a\u0002H&\"\u0004\b\u0000\u0010&2\u0006\u0010\u001f\u001a\u00020\u001c2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H&0*2\u0006\u0010+\u001a\u0002H&\u00a2\u0006\u0002\u0010-\u001a\u0012\u0010.\u001a\u00020\u001a*\u00020/2\u0006\u0010\u001b\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\t\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u000e\u0010\f\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0011\u001a\u00020\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0017\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0018\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000*\u0016\u00100\"\b\u0012\u0004\u0012\u000202012\b\u0012\u0004\u0012\u00020201\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00063"}, d2={"COVERAGE_OUTPUT_DIR", "", "DEFAULT_EXCLUDE_SCOPE_MODIFIER", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/GlobalExcludeScopeModifier;", "getDEFAULT_EXCLUDE_SCOPE_MODIFIER", "()Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/GlobalExcludeScopeModifier;", "DEFAULT_FAIL_THRESHOLD", "", "DEFAULT_FILE_SUSPEND_THRESHOLD", "DEFAULT_FIXES_STRATEGY", "getDEFAULT_FIXES_STRATEGY", "()Ljava/lang/String;", "DEFAULT_MODULE_SUSPEND_THRESHOLD", "DEFAULT_OUTPUT_INSPECT_FORMAT", "DEFAULT_PROJECT_SUSPEND_THRESHOLD", "DEFAULT_STOP_THRESHOLD", "EMBEDDED_GIT_IGNORE_EXCLUDE", "GIT_IGNORE_SCOPE_MODIFIER", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/GitIgnoreExcludeScopeModifier;", "getGIT_IGNORE_SCOPE_MODIFIER", "()Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/GitIgnoreExcludeScopeModifier;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "QODANA_YAML_CONFIG_FILENAME", "QODANA_YML_CONFIG_FILENAME", "copyConfigToLog", "", "projectPath", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getConfigPath", "configFolder", "getDefaultProfileName", "getResultsStorage", "outPath", "outputFormat", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/OutputFormat;", "readQodanaConfig", "T", "reader", "Ljava/io/Reader;", "configClass", "Ljava/lang/Class;", "default", "(Ljava/io/Reader;Ljava/lang/Class;Ljava/lang/Object;)Ljava/lang/Object;", "(Ljava/nio/file/Path;Ljava/lang/Class;Ljava/lang/Object;)Ljava/lang/Object;", "correctRelativeProfilePathToAbsolute", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaYamlConfig;", "InspectScopes", "", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/InspectScope;", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nQodanaConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaConfig.kt\norg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfigKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,305:1\n10#2:306\n*S KotlinDebug\n*F\n+ 1 QodanaConfig.kt\norg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfigKt\n*L\n75#1:306\n*E\n"})
public final class QodanaConfigKt {
    @NotNull
    public static final String QODANA_YAML_CONFIG_FILENAME = "qodana.yaml";
    @NotNull
    public static final String QODANA_YML_CONFIG_FILENAME = "qodana.yml";
    @NotNull
    public static final String EMBEDDED_GIT_IGNORE_EXCLUDE = "embedded.gitignore";
    @NotNull
    public static final String DEFAULT_OUTPUT_INSPECT_FORMAT = "json";
    @NotNull
    public static final String COVERAGE_OUTPUT_DIR = "coverage";
    @NotNull
    private static final GlobalExcludeScopeModifier DEFAULT_EXCLUDE_SCOPE_MODIFIER;
    @NotNull
    private static final GitIgnoreExcludeScopeModifier GIT_IGNORE_SCOPE_MODIFIER;
    public static final int DEFAULT_FAIL_THRESHOLD = -1;
    public static final int DEFAULT_STOP_THRESHOLD = -1;
    @NotNull
    private static final String DEFAULT_FIXES_STRATEGY;
    @NotNull
    public static final String DEFAULT_FILE_SUSPEND_THRESHOLD = "5";
    @NotNull
    public static final String DEFAULT_MODULE_SUSPEND_THRESHOLD = "25";
    @NotNull
    public static final String DEFAULT_PROJECT_SUSPEND_THRESHOLD = "125";
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final GlobalExcludeScopeModifier getDEFAULT_EXCLUDE_SCOPE_MODIFIER() {
        return DEFAULT_EXCLUDE_SCOPE_MODIFIER;
    }

    @NotNull
    public static final GitIgnoreExcludeScopeModifier getGIT_IGNORE_SCOPE_MODIFIER() {
        return GIT_IGNORE_SCOPE_MODIFIER;
    }

    @NotNull
    public static final String getDEFAULT_FIXES_STRATEGY() {
        return DEFAULT_FIXES_STRATEGY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T readQodanaConfig(@NotNull Path configFolder, @NotNull Class<T> configClass, T t) {
        T t2;
        Intrinsics.checkNotNullParameter((Object)configFolder, (String)"configFolder");
        Intrinsics.checkNotNullParameter(configClass, (String)"configClass");
        Path path = QodanaConfigKt.getConfigPath(configFolder);
        if (path == null) {
            return t;
        }
        Path path2 = path;
        Closeable closeable = new InputStreamReader(Files.newInputStream(path2, new OpenOption[0]));
        Throwable throwable = null;
        try {
            InputStreamReader it = (InputStreamReader)closeable;
            boolean bl = false;
            t2 = QodanaConfigKt.readQodanaConfig(it, configClass, t);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return t2;
    }

    @Nullable
    public static final Path getConfigPath(@NotNull Path configFolder) {
        Intrinsics.checkNotNullParameter((Object)configFolder, (String)"configFolder");
        Path yaml = configFolder.resolve(QODANA_YAML_CONFIG_FILENAME);
        Intrinsics.checkNotNullExpressionValue((Object)yaml, (String)"yaml");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(yaml, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return yaml;
        }
        Path yml = configFolder.resolve(QODANA_YML_CONFIG_FILENAME);
        Intrinsics.checkNotNullExpressionValue((Object)yml, (String)"yml");
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (Files.exists(yml, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            return yml;
        }
        return null;
    }

    public static final <T> T readQodanaConfig(@NotNull Reader reader, @NotNull Class<T> configClass, T t) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter(configClass, (String)"configClass");
        Representer representer = new Representer(new DumperOptions());
        representer.getPropertyUtils().setSkipMissingProperties(true);
        CustomClassLoaderConstructor constr = new CustomClassLoaderConstructor(configClass, configClass.getClassLoader(), new LoaderOptions());
        Yaml yaml = new Yaml((BaseConstructor)constr, representer);
        yaml.setBeanAccess(BeanAccess.FIELD);
        Object object = yaml.load(reader);
        if (object == null) {
            object = t;
        }
        return (T)object;
    }

    @NotNull
    public static final Path getResultsStorage(@NotNull Path outPath, @NotNull OutputFormat outputFormat) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)outPath, (String)"outPath");
        Intrinsics.checkNotNullParameter((Object)((Object)outputFormat), (String)"outputFormat");
        if (outputFormat != OutputFormat.INSPECT_SH_FORMAT) {
            Path path2 = outPath.resolve("temp");
            path = path2;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"{\n    outPath.resolve(\"temp\")\n  }");
        } else {
            path = outPath;
        }
        return path;
    }

    private static final String getDefaultProfileName() {
        String string = System.getProperty("qodana.default.profile", "qodana.starter");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"qodana.defa\u2026ofile\", \"qodana.starter\")");
        return string;
    }

    @Nullable
    public static final Object copyConfigToLog(@NotNull Path projectPath, @NotNull Continuation<? super Unit> $completion) {
        Object object = InterruptibleKt.runInterruptible((CoroutineContext)Static_analysis_dispatchersKt.getStaticAnalysisDispatchers().getIO(), (Function0)((Function0)new Function0<Unit>(projectPath){
            final /* synthetic */ Path $projectPath;
            {
                this.$projectPath = $projectPath;
                super(0);
            }

            public final void invoke() {
                Object $i$a$-runCatching-QodanaConfigKt$copyConfigToLog$2$22;
                String[] stringArray = new String[]{"qodana.yaml"};
                Path qodanaLogPath = Paths.get(PathManager.getLogPath(), stringArray);
                try {
                    boolean $i$a$-runCatching-QodanaConfigKt$copyConfigToLog$2$22 = false;
                    $i$a$-runCatching-QodanaConfigKt$copyConfigToLog$2$22 = Result.constructor-impl((Object)Files.deleteIfExists(qodanaLogPath));
                }
                catch (Throwable throwable) {
                    $i$a$-runCatching-QodanaConfigKt$copyConfigToLog$2$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                Path path = QodanaConfigKt.getConfigPath(this.$projectPath);
                if (path == null) {
                    return;
                }
                Path configPath = path;
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Files.copy(configPath, qodanaLogPath, copyOptionArray);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static final void correctRelativeProfilePathToAbsolute(@NotNull QodanaYamlConfig $this$correctRelativeProfilePathToAbsolute, @NotNull String projectPath) {
        Intrinsics.checkNotNullParameter((Object)$this$correctRelativeProfilePathToAbsolute, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        if (((CharSequence)$this$correctRelativeProfilePathToAbsolute.getProfile().getPath()).length() > 0 && !Paths.get($this$correctRelativeProfilePathToAbsolute.getProfile().getPath(), new String[0]).isAbsolute()) {
            QodanaProfileConfig qodanaProfileConfig = $this$correctRelativeProfilePathToAbsolute.getProfile();
            String[] stringArray = new String[]{$this$correctRelativeProfilePathToAbsolute.getProfile().getPath()};
            Path path = Paths.get(projectPath, stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(projectPath, profile.path)");
            qodanaProfileConfig.setPath(((Object)path).toString());
        }
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ String access$getDefaultProfileName() {
        return QodanaConfigKt.getDefaultProfileName();
    }

    static {
        Object[] objectArray = new String[]{"buildSrc", "vendor", "build", "builds", "dist", "tests", "tools", "vendor", "bin", ".qodana"};
        List list2 = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"test:*..*", "file:buildSrc/*", "file[*.buildSrc]:*/"};
        DEFAULT_EXCLUDE_SCOPE_MODIFIER = new GlobalExcludeScopeModifier(new InspectScope("embedded.default", list2, CollectionsKt.listOf((Object[])objectArray)));
        GIT_IGNORE_SCOPE_MODIFIER = new GitIgnoreExcludeScopeModifier(new InspectScope(EMBEDDED_GIT_IGNORE_EXCLUDE, null, null, 6, null));
        DEFAULT_FIXES_STRATEGY = "NONE";
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(QodanaConfig.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(T::class.java)");
        LOG = logger2;
    }
}

