/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.problem;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.actions.OpenProblemWithRevisionAction;
import org.jetbrains.qodana.problem.SarifProblemKt;
import org.jetbrains.qodana.problem.SarifProblemWithProperties;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0007"}, d2={"navigatable", "Lcom/intellij/pom/Navigatable;", "Lorg/jetbrains/qodana/problem/SarifProblemWithProperties;", "project", "Lcom/intellij/openapi/project/Project;", "openFileDescriptor", "Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;", "intellij.qodana"})
public final class SarifProblemPropertiesKt {
    @Nullable
    public static final OpenFileDescriptor openFileDescriptor(@NotNull SarifProblemWithProperties $this$openFileDescriptor, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)$this$openFileDescriptor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        int line = $this$openFileDescriptor.getProperties().getLine();
        int column = $this$openFileDescriptor.getProperties().getColumn();
        VirtualFile virtualFile2 = $this$openFileDescriptor.getProblem().getVirtualFile(project2);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile virtualFile3 = virtualFile2;
        if (line < 0 || !$this$openFileDescriptor.getProperties().isPresent()) {
            return new OpenFileDescriptor(project2, virtualFile3, -1);
        }
        OpenFileDescriptor lineStartDescriptor = new OpenFileDescriptor(project2, virtualFile3, line, 0);
        OpenFileDescriptor nextLineStartDescriptor = new OpenFileDescriptor(project2, virtualFile3, line + 1, 0);
        int offset = lineStartDescriptor.getOffset() + Math.max(0, column);
        OpenFileDescriptor problemLocationDescriptor = new OpenFileDescriptor(project2, virtualFile3, offset);
        return problemLocationDescriptor.compareTo(nextLineStartDescriptor) >= 0 ? lineStartDescriptor : problemLocationDescriptor;
    }

    @NotNull
    public static final Navigatable navigatable(@NotNull SarifProblemWithProperties $this$navigatable, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)$this$navigatable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        OpenFileDescriptor openFileDescriptor = !$this$navigatable.getProperties().isMissing() ? SarifProblemPropertiesKt.openFileDescriptor($this$navigatable, project2) : null;
        Navigatable missingProblemNavigatable2 = new Navigatable($this$navigatable, project2){
            final /* synthetic */ SarifProblemWithProperties $this_navigatable;
            final /* synthetic */ Project $project;
            {
                this.$this_navigatable = $receiver;
                this.$project = $project;
            }

            public void navigate(boolean requestFocus) {
                String description2 = SarifProblemKt.buildDescription(this.$this_navigatable.getProblem(), false, false);
                Object[] objectArray = new Object[]{description2, this.$this_navigatable.getProblem().getRelativeNioFile().getFileName()};
                String string = QodanaBundle.message("notification.content.problem.not.present.in.file", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"notification.co\u2026relativeNioFile.fileName)");
                String notificationContent = string;
                Notification notification2 = new Notification("Qodana Problems Tab", QodanaBundle.message("notification.title.cannot.navigate.to.problem", new Object[0]), notificationContent, NotificationType.WARNING);
                OpenProblemWithRevisionAction openProblemWithRevisionAction = new OpenProblemWithRevisionAction(this.$this_navigatable.getProblem());
                if (openProblemWithRevisionAction.canBePerformed(this.$project)) {
                    notification2.addAction((AnAction)openProblemWithRevisionAction);
                }
                notification2.notify(this.$project);
            }

            public boolean canNavigate() {
                return true;
            }

            public boolean canNavigateToSource() {
                return true;
            }
        };
        OpenFileDescriptor openFileDescriptor2 = openFileDescriptor;
        return openFileDescriptor2 != null ? (Navigatable)openFileDescriptor2 : (Navigatable)missingProblemNavigatable2;
    }
}

