/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.cloud.authorization;

import com.intellij.collaboration.auth.credentials.Credentials;
import com.intellij.collaboration.auth.services.OAuthCredentialsAcquirer;
import java.net.http.HttpRequest;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.cloud.api.QodanaCloudException;
import org.jetbrains.qodana.cloud.api.RequestKt;
import org.jetbrains.qodana.cloud.api.RequestMethod;
import org.jetbrains.qodana.cloud.authorization.OauthKt;
import org.jetbrains.qodana.cloud.authorization.QodanaCloudCredentials;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/qodana/cloud/authorization/QodanaCloudOAuthCredentialsAcquirer;", "Lcom/intellij/collaboration/auth/services/OAuthCredentialsAcquirer;", "Lorg/jetbrains/qodana/cloud/authorization/QodanaCloudCredentials;", "()V", "acquireCredentials", "Lcom/intellij/collaboration/auth/services/OAuthCredentialsAcquirer$AcquireCredentialsResult;", "code", "", "intellij.qodana"})
public final class QodanaCloudOAuthCredentialsAcquirer
implements OAuthCredentialsAcquirer<QodanaCloudCredentials> {
    @NotNull
    public OAuthCredentialsAcquirer.AcquireCredentialsResult<QodanaCloudCredentials> acquireCredentials(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        HttpRequest request = RequestKt.buildRequestToQodanaCloud$default("/v1/idea/auth/token/", new RequestMethod.POST(MapsKt.mapOf((Pair)TuplesKt.to((Object)"code", (Object)code))), null, null, 12, null);
        try {
            QodanaCloudCredentials credentials = OauthKt.getCredentialsByHttpRequest(request);
            return (OAuthCredentialsAcquirer.AcquireCredentialsResult)new OAuthCredentialsAcquirer.AcquireCredentialsResult.Success((Credentials)credentials);
        }
        catch (QodanaCloudException e) {
            return (OAuthCredentialsAcquirer.AcquireCredentialsResult)new OAuthCredentialsAcquirer.AcquireCredentialsResult.Error(e.toString());
        }
    }
}

