/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en.translation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.languagetool.AnalyzedToken;
import org.languagetool.Languages;
import org.languagetool.synthesis.Synthesizer;

class Inflector {
    private final Synthesizer enSynth = Languages.getLanguageForShortCode("en").getSynthesizer();

    Inflector() {
    }

    List<String> inflect(String enToken, String dePosTag) {
        List<String> parts = Arrays.asList(enToken.replaceFirst("to ", "").split(" "));
        List<String> lastPartForms = this.inflectSingleWord(parts.get(parts.size() - 1), dePosTag);
        String startParts = parts.size() > 1 ? String.join((CharSequence)" ", parts.subList(0, parts.size() - 1)) : "";
        ArrayList<String> result2 = new ArrayList<String>();
        for (String lastPartForm : lastPartForms) {
            result2.add((startParts + " " + lastPartForm).trim());
        }
        return result2;
    }

    List<String> inflectSingleWord(String enToken, String dePosTag) {
        ArrayList<String> forms = new ArrayList<String>();
        if (dePosTag == null) {
            forms.add(enToken);
            return forms;
        }
        if (dePosTag.matches("SUB.*PLU.*")) {
            forms.addAll(this.getForms(enToken, "NNP?S"));
        } else if (dePosTag.matches("VER:3:SIN:PR\u00c4.*")) {
            forms.addAll(this.getForms(enToken, "VBZ"));
        } else if (dePosTag.matches("VER:3:SIN:PRT:.*")) {
            forms.addAll(this.getForms(enToken, "VBD"));
        } else if (dePosTag.matches("PA1:PRD:GRU:VER")) {
            forms.addAll(this.getForms(enToken, "VBG"));
        } else if (dePosTag.matches("PA2:PRD:GRU:VER")) {
            forms.addAll(this.getForms(enToken, "VBN"));
        } else if (dePosTag.matches("ADJ:PRD:KOM|ADJ:.*:KOM.*")) {
            forms.addAll(this.getForms(enToken, "JJR"));
        } else if (dePosTag.matches("ADJ:.*:SUP.*")) {
            forms.addAll(this.getForms(enToken, "JJS"));
        } else {
            forms.add(enToken);
        }
        return forms;
    }

    @NotNull
    private List<String> getForms(String enToken, String posTagRegex) {
        try {
            return Arrays.asList(this.enSynth.synthesize(new AnalyzedToken(enToken, "fake-value", enToken), posTagRegex, true));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

