/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.ide.notification;

import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.ide.notification.GrazieToastNotifications;
import com.intellij.grazie.ide.ui.components.dsl.SwingKTKt;
import com.intellij.grazie.jlanguage.Lang;
import com.intellij.grazie.remote.GrazieRemote;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.MultiMap;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0014\u0010\u0017\u001a\u00020\u000e*\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000bH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R;\u0010\t\u001a/\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u000e \f*\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r0\r0\n\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/grazie/ide/notification/GrazieToastNotifications;", "", "()V", "GENERAL_GROUP", "Lcom/intellij/notification/NotificationGroup;", "getGENERAL_GROUP$intellij_grazie_core", "()Lcom/intellij/notification/NotificationGroup;", "MISSING_LANGUAGES_GROUP", "getMISSING_LANGUAGES_GROUP$intellij_grazie_core", "shownNotifications", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/grazie/ide/notification/GrazieToastNotifications$Group;", "kotlin.jvm.PlatformType", "Ljava/lang/ref/WeakReference;", "Lcom/intellij/notification/Notification;", "Lorg/jetbrains/annotations/NotNull;", "obtainGroup", "id", "", "showMissedLanguages", "", "project", "Lcom/intellij/openapi/project/Project;", "expireAll", "group", "Group", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nGrazieToastNotifications.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrazieToastNotifications.kt\ncom/intellij/grazie/ide/notification/GrazieToastNotifications\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n1855#2,2:65\n*S KotlinDebug\n*F\n+ 1 GrazieToastNotifications.kt\ncom/intellij/grazie/ide/notification/GrazieToastNotifications\n*L\n54#1:65,2\n*E\n"})
public final class GrazieToastNotifications {
    @NotNull
    public static final GrazieToastNotifications INSTANCE = new GrazieToastNotifications();
    @NotNull
    private static final MultiMap<Group, WeakReference<Notification>> shownNotifications;

    private GrazieToastNotifications() {
    }

    @NotNull
    public final NotificationGroup getMISSING_LANGUAGES_GROUP$intellij_grazie_core() {
        return this.obtainGroup("Proofreading missing languages information");
    }

    @NotNull
    public final NotificationGroup getGENERAL_GROUP$intellij_grazie_core() {
        return this.obtainGroup("Grazie notifications");
    }

    public final void showMissedLanguages(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Set<Lang> langs = GrazieConfig.Companion.get().getMissedLanguages();
        Object object = new String[]{CollectionsKt.joinToString$default((Iterable)langs, null, null, null, (int)0, null, null, (int)63, null)};
        Notification notification = this.getMISSING_LANGUAGES_GROUP$intellij_grazie_core().createNotification(SwingKTKt.msg("grazie.notification.missing-languages.title", new String[0]), SwingKTKt.msg("grazie.notification.missing-languages.body", object), NotificationType.WARNING);
        object = SwingKTKt.msg("grazie.notification.missing-languages.action.download", new String[0]);
        NotificationAction notificationAction = new NotificationAction(project, (String)object){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super($super_call_param$1);
            }

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                GrazieRemote.INSTANCE.downloadMissing(this.$project);
                notification.expire();
            }
        };
        object = SwingKTKt.msg("grazie.notification.missing-languages.action.disable", new String[0]);
        Notification notification2 = notification.addAction((AnAction)notificationAction).addAction((AnAction)new NotificationAction((String)object){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                GrazieConfig.Companion.update((Function1<? super GrazieConfig.State, GrazieConfig.State>)((Function1)showMissedLanguages.actionPerformed.1.INSTANCE));
                notification.expire();
            }
        }).setSuggestionType(true).setDisplayId("grazie.missing.language");
        Intrinsics.checkNotNullExpressionValue((Object)notification2, (String)"project: Project) {\n    \u2026grazie.missing.language\")");
        this.expireAll(notification2, Group.LANGUAGES).notify(project);
    }

    private final Notification expireAll(Notification $this$expireAll, Group group) {
        $this$expireAll.whenExpired(() -> GrazieToastNotifications.expireAll$lambda$1(group));
        shownNotifications.putValue((Object)group, new WeakReference<Notification>($this$expireAll));
        return $this$expireAll;
    }

    private final NotificationGroup obtainGroup(String id) {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup(id);
        Intrinsics.checkNotNullExpressionValue((Object)notificationGroup, (String)"getInstance().getNotificationGroup(id)");
        return notificationGroup;
    }

    private static final void expireAll$lambda$1(Group $group) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)((Object)$group), (String)"$group");
            Collection collection = shownNotifications.remove((Object)$group);
            if (collection == null) break block1;
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WeakReference it = (WeakReference)element$iv;
                boolean bl = false;
                Notification notification = (Notification)it.get();
                if (notification == null) continue;
                notification.expire();
            }
        }
    }

    static {
        MultiMap multiMap = MultiMap.createConcurrent();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"createConcurrent<Group, \u2026eference<Notification>>()");
        shownNotifications = multiMap;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0003\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/grazie/ide/notification/GrazieToastNotifications$Group;", "", "(Ljava/lang/String;I)V", "LANGUAGES", "intellij.grazie.core"})
    private static final class Group
    extends Enum<Group> {
        public static final /* enum */ Group LANGUAGES = new Group();
        private static final /* synthetic */ Group[] $VALUES;

        public static Group[] values() {
            return (Group[])$VALUES.clone();
        }

        public static Group valueOf(String value) {
            return Enum.valueOf(Group.class, value);
        }

        static {
            $VALUES = groupArray = new Group[]{Group.LANGUAGES};
        }
    }
}

