/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server.core.util;

import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.projector.common.protocol.toClient.ServerDrawCommandsEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientWindowInterestEvent;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0005H$RN\u0010\u0003\u001aB\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007 \u0006* \u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/projector/server/core/util/AbstractWindowDrawInterestManager;", "", "()V", "disinterestedWindows", "Ljava/util/concurrent/ConcurrentHashMap$KeySetView;", "", "kotlin.jvm.PlatformType", "", "filterEvents", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/projector/common/protocol/toClient/ServerEvent;", "events", "isInterestedInWindow", "", "windowId", "processClientEvent", "event", "Lorg/jetbrains/projector/common/protocol/toServer/ClientWindowInterestEvent;", "redrawWindow", "id", "projector-server-core"})
public abstract class AbstractWindowDrawInterestManager {
    private final ConcurrentHashMap.KeySetView<Integer, Unit> disinterestedWindows = new ConcurrentHashMap().keySet(Unit.INSTANCE);

    public final boolean isInterestedInWindow(int windowId) {
        return !this.disinterestedWindows.contains(windowId);
    }

    @NotNull
    public final Sequence<ServerEvent> filterEvents(@NotNull Sequence<? extends ServerEvent> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        if (this.disinterestedWindows.isEmpty()) {
            return events;
        }
        return SequencesKt.filter(events, (Function1)((Function1)new Function1<ServerEvent, Boolean>(this){
            final /* synthetic */ AbstractWindowDrawInterestManager this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull ServerEvent it) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (it instanceof ServerDrawCommandsEvent) {
                    ServerDrawCommandsEvent.Target target = ((ServerDrawCommandsEvent)it).getTarget();
                    AbstractWindowDrawInterestManager abstractWindowDrawInterestManager = this.this$0;
                    ServerDrawCommandsEvent.Target target2 = target;
                    boolean bl2 = false;
                    if (!(!(target2 instanceof ServerDrawCommandsEvent.Target.Onscreen) || abstractWindowDrawInterestManager.isInterestedInWindow(((ServerDrawCommandsEvent.Target.Onscreen)target2).getWindowId()))) {
                        bl = false;
                        return bl;
                    }
                }
                bl = true;
                return bl;
            }
        }));
    }

    protected abstract void redrawWindow(int var1);

    public final void processClientEvent(@NotNull ClientWindowInterestEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.isInterested()) {
            if (this.disinterestedWindows.remove(event.getWindowId())) {
                this.redrawWindow(event.getWindowId());
            }
        } else {
            this.disinterestedWindows.add(event.getWindowId());
        }
    }
}

