/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server.core.ij;

import com.intellij.application.Topics;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBUI;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.common.protocol.data.PaintValue;
import org.jetbrains.projector.common.protocol.toClient.ServerWindowColorsEvent;
import org.jetbrains.projector.server.core.ij.IdeColors;
import org.jetbrains.projector.util.loading.UseProjectorLoader;
import org.jetbrains.projector.util.loading.state.IdeState;
import org.jetbrains.projector.util.loading.state.IdeStateUtilsKt;
import org.jetbrains.projector.util.logging.Logger;
import org.jetbrains.projector.util.logging.LoggerKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@UseProjectorLoader
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\n\u0010\r\u001a\u0004\u0018\u00010\u0004H\u0002J\b\u0010\u000e\u001a\u00020\u0005H\u0002R\"\u0010\b\u001a\u0004\u0018\u00010\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/projector/server/core/ij/IdeColors;", "", "onColorsChanged", "Lkotlin/Function1;", "Lorg/jetbrains/projector/common/protocol/toClient/ServerWindowColorsEvent$ColorsStorage;", "", "(Lkotlin/jvm/functions/Function1;)V", "<set-?>", "colors", "getColors", "()Lorg/jetbrains/projector/common/protocol/toClient/ServerWindowColorsEvent$ColorsStorage;", "logger", "Lorg/jetbrains/projector/util/logging/Logger;", "readColors", "subscribeToIdeLafManager", "projector-server-core"})
public final class IdeColors {
    @NotNull
    private final Function1<ServerWindowColorsEvent.ColorsStorage, Unit> onColorsChanged;
    @NotNull
    private final Logger logger;
    @Nullable
    private ServerWindowColorsEvent.ColorsStorage colors;

    public IdeColors(@NotNull Function1<? super ServerWindowColorsEvent.ColorsStorage, Unit> onColorsChanged) {
        Intrinsics.checkNotNullParameter(onColorsChanged, (String)"onColorsChanged");
        this.onColorsChanged = onColorsChanged;
        boolean $i$f$Logger = false;
        String string = Reflection.getOrCreateKotlinClass(IdeColors.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        this.logger = LoggerKt.Logger(string);
        IdeStateUtilsKt.whenOccurred(IdeState.CONFIGURATION_STORE_INITIALIZED, "Getting IDE colors", (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.subscribeToIdeLafManager();
            }
        }));
    }

    @Nullable
    public final ServerWindowColorsEvent.ColorsStorage getColors() {
        return this.colors;
    }

    private final void subscribeToIdeLafManager() {
        try {
            Topic topic = LafManagerListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            Topics.subscribe((Topic)topic, null, arg_0 -> IdeColors.subscribeToIdeLafManager$lambda-1(this, arg_0));
        }
        catch (Exception e) {
            this.logger.error(e, (Function0<String>)((Function0)subscribeToIdeLafManager.2.INSTANCE));
        }
    }

    private final ServerWindowColorsEvent.ColorsStorage readColors() {
        try {
            PaintValue.Color windowHeaderActiveText;
            PaintValue.Color windowHeaderActiveBackground = new PaintValue.Color(JBUI.CurrentTheme.Popup.headerBackground((boolean)true).getRGB());
            PaintValue.Color windowHeaderInactiveBackground = new PaintValue.Color(JBUI.CurrentTheme.Popup.headerBackground((boolean)false).getRGB());
            PaintValue.Color windowActiveBorder = new PaintValue.Color(JBUI.CurrentTheme.Popup.borderColor((boolean)true).getRGB());
            PaintValue.Color windowInactiveBorder = new PaintValue.Color(JBUI.CurrentTheme.Popup.borderColor((boolean)false).getRGB());
            PaintValue.Color windowHeaderInactiveText = windowHeaderActiveText = new PaintValue.Color(JBUI.CurrentTheme.Label.foreground().getRGB());
            return new ServerWindowColorsEvent.ColorsStorage(windowHeaderActiveBackground, windowHeaderInactiveBackground, windowActiveBorder, windowInactiveBorder, windowHeaderActiveText, windowHeaderInactiveText);
        }
        catch (Exception e) {
            this.logger.error(e, (Function0<String>)((Function0)readColors.1.INSTANCE));
            return null;
        }
    }

    private static final void subscribeToIdeLafManager$lambda-1(IdeColors this$0, LafManager it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ServerWindowColorsEvent.ColorsStorage colorsStorage = this$0.readColors();
        if (colorsStorage != null) {
            ServerWindowColorsEvent.ColorsStorage it2 = colorsStorage;
            boolean bl = false;
            this$0.colors = it2;
            this$0.onColorsChanged.invoke((Object)it2);
        }
    }
}

