/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.security.inspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.apiUsage.ApiUsageProcessor;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.ide.actions.QualifiedNameProviderUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.PackageCheckerBundle;
import org.jetbrains.security.problems.vulnerabilities.Vulnerability;
import org.jetbrains.security.service.VulnerableApiCallResult;
import org.jetbrains.security.service.VulnerableApiService;
import org.jetbrains.security.toolwindow.preview.PackageHtmlRenderer;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/security/inspection/VulnerableApiUsageProcessor;", "Lcom/intellij/codeInspection/apiUsage/ApiUsageProcessor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "module", "Lcom/intellij/openapi/module/Module;", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/intellij/openapi/module/Module;)V", "vulnerableApiService", "Lorg/jetbrains/security/service/VulnerableApiService;", "processReference", "", "sourceNode", "Lorg/jetbrains/uast/UElement;", "target", "Lcom/intellij/psi/PsiModifierListOwner;", "qualifier", "Lorg/jetbrains/uast/UExpression;", "Companion", "intellij.packageChecker"})
public final class VulnerableApiUsageProcessor
implements ApiUsageProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProblemsHolder holder;
    @NotNull
    private final VulnerableApiService vulnerableApiService;

    public VulnerableApiUsageProcessor(@NotNull ProblemsHolder holder, @NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.holder = holder;
        this.vulnerableApiService = VulnerableApiService.Companion.getInstance(module);
    }

    @NlsSafe
    public void processReference(@NotNull UElement sourceNode, @NotNull PsiModifierListOwner target, @Nullable UExpression qualifier) {
        Intrinsics.checkNotNullParameter((Object)sourceNode, (String)"sourceNode");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (!(target instanceof PsiCompiledElement)) {
            return;
        }
        PsiElement psiElement = sourceNode.getSourcePsi();
        if (psiElement == null) {
            return;
        }
        PsiElement sourcePsi = psiElement;
        String string = QualifiedNameProviderUtil.getQualifiedName((PsiElement)((PsiElement)target));
        if (string == null) {
            return;
        }
        String qualifiedName = string;
        VulnerableApiCallResult vulnerableApiCallResult = this.vulnerableApiService.isVulnerable(qualifiedName);
        boolean isVulnerable = vulnerableApiCallResult.component1();
        List<Vulnerability> vulnerabilities = vulnerableApiCallResult.component2();
        if (isVulnerable) {
            this.holder.registerProblem(sourcePsi, Companion.makeInspectionMessage(vulnerabilities), new LocalQuickFix[0]);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\f0\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\u0002\b\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/security/inspection/VulnerableApiUsageProcessor$Companion;", "", "()V", "makeInspectionMessage", "", "Lorg/jetbrains/annotations/Nls;", "Lorg/jetbrains/annotations/NotNull;", "vulnerabilities", "", "Lorg/jetbrains/security/problems/vulnerabilities/Vulnerability;", "intellij.packageChecker"})
    public static final class Companion {
        private Companion() {
        }

        @InspectionMessage
        @NotNull
        public final String makeInspectionMessage(@NotNull List<Vulnerability> vulnerabilities) {
            Intrinsics.checkNotNullParameter(vulnerabilities, (String)"vulnerabilities");
            Object[] objectArray = new Object[]{PackageHtmlRenderer.INSTANCE.getVulnerabilityList(vulnerabilities)};
            String string = PackageCheckerBundle.message("inspection.message.vulnerable.api.usage", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"inspection.mess\u2026ityList(vulnerabilities))");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

