/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.security.inspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.VulnerablePackage;
import org.jetbrains.security.api.PackageDeclaration;
import org.jetbrains.security.inspection.fix.ChangeVersionLocalQuickFix;
import org.jetbrains.security.inspection.fix.ShowVulnerabilityInfoFix;
import org.jetbrains.security.package.Package;
import org.jetbrains.security.package.PackageType;
import org.jetbrains.security.package.version.SingleVersion;
import org.jetbrains.security.problems.vulnerabilities.CallToAction;
import org.jetbrains.security.service.PackageService;
import org.jetbrains.security.service.Vulnerable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010H\u0002J2\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\b\b\u0001\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0013H\u0002J\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010H\u0002R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/security/inspection/ProblemDescriptorBuilder;", "", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "file", "Lcom/intellij/psi/PsiFile;", "declaredDependencies", "", "Lorg/jetbrains/security/package/Package;", "Lorg/jetbrains/security/api/PackageDeclaration;", "packageService", "Lorg/jetbrains/security/service/PackageService;", "headless", "", "(Lcom/intellij/codeInspection/InspectionManager;Lcom/intellij/psi/PsiFile;Ljava/util/Map;Lorg/jetbrains/security/service/PackageService;Z)V", "declared", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "vulnerablePackages", "Lorg/jetbrains/security/service/Vulnerable;", "descriptor", "text", "", "fix", "Lcom/intellij/codeInspection/LocalQuickFix;", "vulnerable", "psi", "Lcom/intellij/psi/PsiElement;", "descriptors", "getProblemHighlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "vulnerablePackage", "nonDeclared", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nVulnerableLibrariesLocalInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VulnerableLibrariesLocalInspection.kt\norg/jetbrains/security/inspection/ProblemDescriptorBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,145:1\n766#2:146\n857#2,2:147\n3190#2,10:149\n1360#2:159\n1446#2,5:160\n1549#2:165\n1620#2,3:166\n1#3:169\n11335#4:170\n11670#4,3:171\n*S KotlinDebug\n*F\n+ 1 VulnerableLibrariesLocalInspection.kt\norg/jetbrains/security/inspection/ProblemDescriptorBuilder\n*L\n63#1:146\n63#1:147,2\n69#1:149,10\n77#1:159\n77#1:160,5\n95#1:165\n95#1:166,3\n131#1:170\n131#1:171,3\n*E\n"})
final class ProblemDescriptorBuilder {
    @NotNull
    private final InspectionManager manager;
    @NotNull
    private final PsiFile file;
    @NotNull
    private final Map<Package, PackageDeclaration> declaredDependencies;
    @NotNull
    private final PackageService packageService;
    private final boolean headless;

    public ProblemDescriptorBuilder(@NotNull InspectionManager manager, @NotNull PsiFile file2, @NotNull Map<Package, PackageDeclaration> declaredDependencies2, @NotNull PackageService packageService, boolean headless) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(declaredDependencies2, (String)"declaredDependencies");
        Intrinsics.checkNotNullParameter((Object)packageService, (String)"packageService");
        this.manager = manager;
        this.file = file2;
        this.declaredDependencies = declaredDependencies2;
        this.packageService = packageService;
        this.headless = headless;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ProblemDescriptor> descriptors(@NotNull List<Vulnerable> vulnerablePackages) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(vulnerablePackages, (String)"vulnerablePackages");
        Iterable $this$filter$iv = vulnerablePackages;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PackageDeclaration packageDeclaration;
            Vulnerable vulnerable = (Vulnerable)element$iv$iv;
            boolean bl = false;
            ProgressManager.checkCanceled();
            Package vulnerablePackage = vulnerable.getPkg();
            PackageType[] packageTypeArray = new PackageType[]{PackageType.python, PackageType.pypi};
            boolean bl2 = !CollectionsKt.listOf((Object[])packageTypeArray).contains((Object)vulnerablePackage.getType()) || Intrinsics.areEqual((Object)((packageDeclaration = this.declaredDependencies.get(vulnerablePackage)) != null && (packageDeclaration = packageDeclaration.getPsiElement()) != null ? packageDeclaration.getContainingFile() : null), (Object)this.file);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$partition$iv = (List)destination$iv$iv;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            Vulnerable it = (Vulnerable)element$iv;
            boolean bl = false;
            ProgressManager.checkCanceled();
            if (this.declaredDependencies.containsKey(it.getPkg())) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List directlyVulnerable = (List)pair.component1();
        List vulnerableTransitive = (List)pair.component2();
        return CollectionsKt.plus((Collection)this.declared(directlyVulnerable), (Iterable)this.nonDeclared(vulnerableTransitive));
    }

    /*
     * WARNING - void declaration
     */
    private final List<ProblemDescriptor> declared(List<Vulnerable> vulnerablePackages) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = vulnerablePackages;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            PackageDeclaration psiElement;
            Vulnerable pkg = (Vulnerable)element$iv$iv;
            boolean bl = false;
            ProgressManager.checkCanceled();
            CallToAction callToAction = pkg.getVulnerablePackage().getCallToAction();
            SingleVersion call2action = callToAction != null ? callToAction.getNewVersion() : null;
            LocalQuickFix fix = null;
            PackageDeclaration packageDeclaration = this.declaredDependencies.get(pkg.getPkg());
            if (packageDeclaration == null || (packageDeclaration = packageDeclaration.getPsiElement()) == null) {
                packageDeclaration = psiElement = (PsiElement)this.file;
            }
            if (call2action != null) {
                fix = (LocalQuickFix)new ChangeVersionLocalQuickFix((PsiElement)psiElement, call2action.getValue(), pkg.getPkg());
            }
            SingleVersion singleVersion = call2action;
            Iterable list$iv$iv = this.descriptor(pkg.generateInspectionMessage("inspection.template", singleVersion != null ? singleVersion.getValue() : null), fix, pkg, (PsiElement)psiElement);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ProblemDescriptor> nonDeclared(List<Vulnerable> vulnerablePackages) {
        Collection<Package> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = vulnerablePackages;
        PsiFile psiFile = this.file;
        PackageService packageService = this.packageService;
        boolean $i$f$map = false;
        Iterator<Vulnerable> iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Vulnerable vulnerable = (Vulnerable)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getPkg());
        }
        collection = (List)destination$iv$iv;
        Map<Package, List<Package>> roots = packageService.calculateRoots(psiFile, (List<Package>)collection);
        List nonDeclared2 = new ArrayList();
        List withRoots = new ArrayList();
        for (Vulnerable vulnerablePackage : vulnerablePackages) {
            PsiElement psiElement;
            PackageDeclaration declaredRoot2;
            ProgressManager.checkCanceled();
            PackageDeclaration packageDeclaration = declaredRoot2 = (PackageDeclaration)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)roots.getOrDefault(vulnerablePackage.getPkg(), CollectionsKt.emptyList())), (Function1)((Function1)new Function1<Package, PackageDeclaration>(this){
                final /* synthetic */ ProblemDescriptorBuilder this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @Nullable
                public final PackageDeclaration invoke(@NotNull Package it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return (PackageDeclaration)ProblemDescriptorBuilder.access$getDeclaredDependencies$p(this.this$0).get(it);
                }
            })));
            Object object = psiElement = packageDeclaration != null ? packageDeclaration.getPsiElement() : null;
            if (psiElement == null) {
                nonDeclared2.add(vulnerablePackage.getVulnerablePackage());
                continue;
            }
            String text = Vulnerable.generateInspectionMessage$default(vulnerablePackage, "inspection.transitive", null, 2, null);
            withRoots.addAll((Collection)this.descriptor(text, null, vulnerablePackage, psiElement));
        }
        return withRoots;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ProblemDescriptor> descriptor(@NlsSafe String text, LocalQuickFix fix, Vulnerable vulnerable, PsiElement psi) {
        void $this$mapTo$iv$iv;
        TextRange declaredDependencyRange;
        LocalQuickFix[] localQuickFixArray;
        LocalQuickFix[] localQuickFixArray2;
        VulnerablePackage vulnerablePackage = vulnerable.getVulnerablePackage();
        ShowVulnerabilityInfoFix showQuickFix = new ShowVulnerabilityInfoFix(vulnerablePackage);
        LocalQuickFix localQuickFix = fix;
        if (localQuickFix != null) {
            LocalQuickFix it = localQuickFix;
            boolean bl = false;
            localQuickFixArray2 = new LocalQuickFix[]{fix, showQuickFix};
            localQuickFixArray = localQuickFixArray2;
        } else {
            ShowVulnerabilityInfoFix[] showVulnerabilityInfoFixArray = new ShowVulnerabilityInfoFix[]{showQuickFix};
            localQuickFixArray = showVulnerabilityInfoFixArray;
        }
        LocalQuickFix[] quickFixes = localQuickFixArray;
        ProblemHighlightType highlightType = this.getProblemHighlightType(vulnerable);
        PackageDeclaration packageDeclaration = this.declaredDependencies.get(vulnerablePackage.getPkg());
        Object object = declaredDependencyRange = packageDeclaration != null ? packageDeclaration.getRange() : null;
        if (declaredDependencyRange == null) {
            ProblemDescriptor problemDescriptor = this.manager.createProblemDescriptor(psi, text, true, quickFixes, highlightType);
            Intrinsics.checkNotNullExpressionValue((Object)problemDescriptor, (String)"manager.createProblemDes\u2026uickFixes, highlightType)");
            return CollectionsKt.listOf((Object)problemDescriptor);
        }
        LocalQuickFix[] $this$map$iv = quickFixes;
        boolean $i$f$map = false;
        localQuickFixArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void localQuickFix2;
            void item$iv$iv;
            void var18_18 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            LocalQuickFix[] localQuickFixArray3 = new LocalQuickFix[]{localQuickFix2};
            collection.add(this.manager.createProblemDescriptor(psi, declaredDependencyRange, text, highlightType, true, localQuickFixArray3));
        }
        return (List)destination$iv$iv;
    }

    private final ProblemHighlightType getProblemHighlightType(Vulnerable vulnerablePackage) {
        return this.headless ? vulnerablePackage.getProblemHighlightType() : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
    }

    public static final /* synthetic */ Map access$getDeclaredDependencies$p(ProblemDescriptorBuilder $this) {
        return $this.declaredDependencies;
    }
}

