/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.security.extension.gradle;

import com.intellij.buildsystem.model.DeclaredDependency;
import com.intellij.buildsystem.model.unified.UnifiedCoordinates;
import com.intellij.buildsystem.model.unified.UnifiedDependency;
import com.intellij.externalSystem.DependencyModifierService;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractExternalEntityData;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.dependencies.ProjectDependencies;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.build.CachedModuleDataFinder;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.service.project.data.ExternalProjectDataCache;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.security.PackageUtilKt;
import org.jetbrains.security.api.PackageDeclaration;
import org.jetbrains.security.extension.BuildFileProviderBase;
import org.jetbrains.security.extension.gradle.GradleProjectDependenciesModel;
import org.jetbrains.security.extension.gradle.workaround.DependencyModificator;
import org.jetbrains.security.model.ModuleModel;
import org.jetbrains.security.model.ProjectDependenciesModel;
import org.jetbrains.security.package.Package;
import org.jetbrains.security.package.PackageType;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J0\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u000f0\r2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000fH\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/security/extension/gradle/GradleBuildFileProvider;", "Lorg/jetbrains/security/extension/BuildFileProviderBase;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "findExternalProject", "Lorg/jetbrains/plugins/gradle/model/ExternalProject;", "module", "Lcom/intellij/openapi/module/Module;", "getModule", "file", "Lcom/intellij/psi/PsiFile;", "getRoots", "", "Lorg/jetbrains/security/package/Package;", "", "pkgs", "importedPackages", "moduleScript", "supports", "", "updatePackageDeclaration", "", "pkg", "version", "", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nGradleBuildFileProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleBuildFileProvider.kt\norg/jetbrains/security/extension/gradle/GradleBuildFileProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n1747#2,3:108\n1603#2,9:111\n1855#2:120\n1856#2:122\n1612#2:123\n1#3:121\n*S KotlinDebug\n*F\n+ 1 GradleBuildFileProvider.kt\norg/jetbrains/security/extension/gradle/GradleBuildFileProvider\n*L\n44#1:108,3\n82#1:111,9\n82#1:120\n82#1:122\n82#1:123\n82#1:121\n*E\n"})
public final class GradleBuildFileProvider
extends BuildFileProviderBase {
    public GradleBuildFileProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @Override
    @NotNull
    public Module getModule(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Module module = ProjectFileIndex.getInstance((Project)file2.getProject()).getModuleForFile(file2.getVirtualFile());
        if (module == null) {
            throw new IllegalStateException("".toString());
        }
        return module;
    }

    @Override
    @Nullable
    public PsiFile moduleScript(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Object object = this.findExternalProject(this.getProject(), module);
        if (object == null || (object = object.getBuildFile()) == null) {
            return null;
        }
        Object buildFile = object;
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)buildFile, (boolean)true);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile vFile = virtualFile;
        if (this.getProject().isDisposed() || !vFile.isValid()) {
            return null;
        }
        return PsiManager.getInstance((Project)this.getProject()).findFile(vFile);
    }

    @Override
    public boolean supports(@NotNull PsiFile file2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Iterable $this$any$iv = (Iterable)((GradleProjectDependenciesModel)ProjectDependenciesModel.Companion.getEP_NAME().findExtensionOrFail(GradleProjectDependenciesModel.class, (AreaInstance)this.getProject())).getModules().getValue();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ModuleModel it = (ModuleModel)element$iv;
                    boolean bl2 = false;
                    ProgressManager.checkCanceled();
                    if (!(it.getBuildFile() != null && Intrinsics.areEqual((Object)it.getBuildFile(), (Object)file2.getVirtualFile()))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public void updatePackageDeclaration(@NotNull Module module, @NotNull Package pkg, @NotNull String version) {
        block5: {
            Unit unit;
            UnifiedDependency unifiedDependency;
            Object v2;
            block4: {
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
                Intrinsics.checkNotNullParameter((Object)version, (String)"version");
                Iterable iterable = DependencyModifierService.Companion.getInstance(this.getProject()).declaredDependencies(module);
                for (Object t : iterable) {
                    DeclaredDependency it = (DeclaredDependency)t;
                    boolean bl = false;
                    Object object = PackageUtilKt.toPackageDeclaration(it);
                    boolean bl2 = object != null && (object = ((PackageDeclaration)object).getPkg()) != null ? ((Package)object).matches(pkg) : false;
                    if (!bl2) continue;
                    v2 = t;
                    break block4;
                }
                v2 = null;
            }
            DeclaredDependency declaredDependency = v2;
            if (declaredDependency == null || (unifiedDependency = declaredDependency.getUnifiedDependency()) == null) {
                throw new IllegalStateException(("THere are no " + pkg.getCoordinates() + " in " + module.getName() + " module").toString());
            }
            UnifiedDependency previous = unifiedDependency;
            UnifiedDependency updated = UnifiedDependency.copy$default((UnifiedDependency)previous, (UnifiedCoordinates)UnifiedCoordinates.copy$default((UnifiedCoordinates)previous.getCoordinates(), null, null, (String)version, (int)3, null), null, (int)2, null);
            DependencyModificator dependencyModificator = DependencyModificator.Companion.getModificator(this.getProject());
            if (dependencyModificator != null) {
                dependencyModificator.updateDependency(module, previous, updated);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block5;
            this.getLogger().info("Gradle workaround is missed");
        }
    }

    @Override
    public boolean supports(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)new ProjectSystemId("GRADLE"), (Module)module);
    }

    @Override
    @NotNull
    public Map<Package, List<Package>> getRoots(@NotNull PsiFile file2, @NotNull List<Package> pkgs2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(pkgs2, (String)"pkgs");
        CachedModuleDataFinder moduleDataFinder = CachedModuleDataFinder.getInstance((Project)this.getProject());
        Module module = ProjectFileIndex.getInstance((Project)file2.getProject()).getModuleForFile(file2.getVirtualFile());
        if (module == null) {
            return MapsKt.emptyMap();
        }
        Module moduleForFile = module;
        DataNode dataNode = moduleDataFinder.findMainModuleData(moduleForFile);
        if (dataNode == null) {
            return MapsKt.emptyMap();
        }
        DataNode mainModuleData = dataNode;
        DataNode dataNode2 = ExternalSystemApiUtil.find((DataNode)mainModuleData, (Key)ProjectKeys.DEPENDENCIES_GRAPH);
        if (dataNode2 == null) {
            return MapsKt.emptyMap();
        }
        DataNode dependenciesDataNode = dataNode2;
        Object object = dependenciesDataNode.getData();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"dependenciesDataNode.data");
        ProjectDependencies projectDependencies = (ProjectDependencies)object;
        return PackageUtilKt.rootDependencies(projectDependencies);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Package> importedPackages(@NotNull PsiFile file2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        CachedModuleDataFinder moduleDataFinder = CachedModuleDataFinder.getInstance((Project)this.getProject());
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)file2);
        if (module == null) {
            return CollectionsKt.emptyList();
        }
        Module moduleForFile = module;
        DataNode dataNode = moduleDataFinder.findMainModuleData(moduleForFile);
        if (dataNode == null) {
            return CollectionsKt.emptyList();
        }
        DataNode mainModuleData = dataNode;
        Collection collection = ExternalSystemApiUtil.findAllRecursively((DataNode)mainModuleData, (Key)ProjectKeys.LIBRARY_DEPENDENCY);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findAllRecursively(mainM\u2026tKeys.LIBRARY_DEPENDENCY)");
        Collection libraryNodes = collection;
        Iterable $this$mapNotNull$iv = libraryNodes;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Package package_;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DataNode it = (DataNode)element$iv$iv;
            boolean bl2 = false;
            AbstractExternalEntityData abstractExternalEntityData = ((LibraryDependencyData)it.getData()).getTarget();
            Intrinsics.checkNotNullExpressionValue((Object)abstractExternalEntityData, (String)"it.data.target");
            LibraryData libraryData = (LibraryData)abstractExternalEntityData;
            String namespace = libraryData.getGroupId();
            if (libraryData.getArtifactId() == null) {
                package_ = null;
            } else {
                String name;
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"libraryData.artifactId ?: return@mapNotNull null");
                if (libraryData.getVersion() == null) {
                    package_ = null;
                } else {
                    String version;
                    Intrinsics.checkNotNullExpressionValue((Object)version, (String)"libraryData.version ?: return@mapNotNull null");
                    package_ = new Package(PackageType.maven, namespace, name, version, null, null, null, 112, null);
                }
            }
            if (package_ == null) continue;
            Package it$iv$iv = package_;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final ExternalProject findExternalProject(Project project, Module module) {
        DataNode find;
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) {
            return null;
        }
        String projectId = ExternalSystemApiUtil.getExternalProjectPath((Module)module);
        if (projectId == null) {
            this.getLogger().debug("Root external project was not yet imported, project=" + project.getProjectFilePath() + ", module=" + module.getModuleFilePath());
            return null;
        }
        DataNode dataNode = ExternalSystemApiUtil.findProjectNode((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (String)projectId);
        if (dataNode == null) {
            return null;
        }
        DataNode projectData = dataNode;
        DataNode dataNode2 = find = ExternalSystemApiUtil.find((DataNode)projectData, (Key)ExternalProjectDataCache.KEY);
        return dataNode2 != null ? (ExternalProject)dataNode2.getData() : null;
    }
}

