/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.security.extension.go;

import com.goide.util.GoUtil;
import com.goide.vgo.VgoUtil;
import com.goide.vgo.mod.psi.VgoFile;
import com.goide.vgo.mod.psi.VgoModuleSpec;
import com.goide.vgo.project.VgoDependency;
import com.goide.vgo.project.VgoModule;
import com.goide.vgo.project.VgoModulesRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.extension.BuildFileProviderBase;
import org.jetbrains.security.extension.go.UtilsKt;
import org.jetbrains.security.package.Package;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J0\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\f0\n2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\fH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\f2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/security/extension/go/GoBuildFileProvider;", "Lorg/jetbrains/security/extension/BuildFileProviderBase;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getModule", "Lcom/intellij/openapi/module/Module;", "file", "Lcom/intellij/psi/PsiFile;", "getRoots", "", "Lorg/jetbrains/security/package/Package;", "", "pkgs", "importedPackages", "moduleScript", "module", "supports", "", "updatePackageDeclaration", "", "pkg", "version", "", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nGoBuildFileProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoBuildFileProvider.kt\norg/jetbrains/security/extension/go/GoBuildFileProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,45:1\n1603#2,9:46\n1855#2:55\n1856#2:57\n1612#2:58\n1603#2,9:59\n1855#2:68\n1856#2:70\n1612#2:71\n1271#2,2:72\n1285#2,4:74\n661#2,11:78\n1#3:56\n1#3:69\n*S KotlinDebug\n*F\n+ 1 GoBuildFileProvider.kt\norg/jetbrains/security/extension/go/GoBuildFileProvider\n*L\n25#1:46,9\n25#1:55\n25#1:57\n25#1:58\n36#1:59,9\n36#1:68\n36#1:70\n36#1:71\n36#1:72,2\n36#1:74,4\n41#1:78,11\n25#1:56\n36#1:69\n*E\n"})
public final class GoBuildFileProvider
extends BuildFileProviderBase {
    public GoBuildFileProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @Override
    @NotNull
    public Module getModule(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!(file2 instanceof VgoFile)) {
            throw new IllegalStateException("Not a Go module file".toString());
        }
        Module module = GoUtil.module((PsiElement)((PsiElement)file2));
        if (module == null) {
            throw new IllegalStateException("Not a Go module".toString());
        }
        return module;
    }

    @Override
    @Nullable
    public PsiFile moduleScript(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Package> importedPackages(@NotNull PsiFile file2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Module module = GoUtil.module((PsiElement)((PsiElement)file2));
        if (module == null) {
            return CollectionsKt.emptyList();
        }
        Module module2 = module;
        VgoModule vgoModule = VgoModulesRegistry.getInstance((Project)this.getProject()).findVgoModule(module2, file2.getVirtualFile());
        if (vgoModule == null) {
            return CollectionsKt.emptyList();
        }
        VgoModule vgoModule2 = vgoModule;
        Collection collection = vgoModule2.getDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"vgoModule.dependencies");
        Iterable $this$mapNotNull$iv = collection;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Package it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            VgoDependency it = (VgoDependency)element$iv$iv;
            boolean bl2 = false;
            ProgressManager.checkCanceled();
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (UtilsKt.toPackage(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public boolean supports(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return UtilsKt.isEnabled(file2);
    }

    @Override
    public boolean supports(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return UtilsKt.isEnabled(module);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<Package, List<Package>> getRoots(@NotNull PsiFile file2, @NotNull List<Package> pkgs2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(pkgs2, (String)"pkgs");
        Iterable $this$mapNotNull$iv = UtilsKt.getDependencies(file2);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            Package it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            VgoModuleSpec it = (VgoModuleSpec)element$iv$iv;
            boolean bl2 = false;
            if (UtilsKt.toPackage(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$associateWith$iv = (List)destination$iv$iv;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            object = (Package)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            List list = CollectionsKt.emptyList();
            map2.put(t, list);
        }
        return result$iv;
    }

    @Override
    public void updatePackageDeclaration(@NotNull PsiFile file2, @NotNull Package pkg, @NotNull String version) {
        Object v2;
        VgoModule vgoModule;
        Module module;
        block4: {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            module = this.getModule(file2);
            VgoModule vgoModule2 = VgoModulesRegistry.getInstance((Project)this.getProject()).findVgoModule(module, file2.getVirtualFile());
            if (vgoModule2 == null) {
                return;
            }
            vgoModule = vgoModule2;
            Collection collection = vgoModule.getDependencies();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"vgoModule.dependencies");
            Iterable $this$singleOrNull$iv = collection;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                VgoDependency it = (VgoDependency)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (!Intrinsics.areEqual((Object)UtilsKt.toPackage(it), (Object)pkg)) continue;
                if (found$iv) {
                    v2 = null;
                    break block4;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v2 = !found$iv ? null : single$iv;
        }
        VgoDependency vgoDependency = v2;
        if (vgoDependency == null) {
            return;
        }
        VgoDependency dependency = vgoDependency;
        VgoUtil.addDependencyToGoMod((String)(dependency.getImportPath() + "@" + version), (Project)module.getProject(), (VgoModule)vgoModule);
    }
}

