/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.security.extension;

import com.intellij.buildsystem.model.DeclaredDependency;
import com.intellij.externalSystem.DependencyModifierService;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.security.PackageUtilKt;
import org.jetbrains.security.api.PackageDeclaration;
import org.jetbrains.security.package.Package;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/security/extension/UnifiedDependencyNavigatable;", "Lcom/intellij/pom/Navigatable;", "module", "Lcom/intellij/openapi/module/Module;", "pkg", "Lorg/jetbrains/security/package/Package;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/module/Module;Lorg/jetbrains/security/package/Package;Lcom/intellij/openapi/vfs/VirtualFile;)V", "canNavigate", "", "canNavigateToSource", "navigate", "", "requestFocus", "intellij.packageChecker"})
public final class UnifiedDependencyNavigatable
implements Navigatable {
    @NotNull
    private final Module module;
    @NotNull
    private final Package pkg;
    @NotNull
    private final VirtualFile virtualFile;

    public UnifiedDependencyNavigatable(@NotNull Module module, @NotNull Package pkg, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        this.module = module;
        this.pkg = pkg;
        this.virtualFile = virtualFile;
    }

    public void navigate(boolean requestFocus) {
        PackageDeclaration packageDeclaration;
        Object v2;
        block5: {
            Project project = this.module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
            DependencyModifierService dependencyModifierService = DependencyModifierService.Companion.getInstance(project);
            Iterable iterable = dependencyModifierService.declaredDependencies(this.module);
            for (Object t : iterable) {
                DeclaredDependency it = (DeclaredDependency)t;
                boolean bl = false;
                PackageDeclaration declaration = PackageUtilKt.toPackageDeclaration(it);
                Object object = declaration;
                if (!(object != null && (object = ((PackageDeclaration)object).getPkg()) != null ? ((Package)object).matches(this.pkg) : false)) continue;
                v2 = t;
                break block5;
            }
            v2 = null;
        }
        DeclaredDependency declaredDependency = v2;
        PsiElement packageDeclarations = declaredDependency != null && (packageDeclaration = PackageUtilKt.toPackageDeclaration(declaredDependency)) != null ? packageDeclaration.getPsiElement() : null;
        NavigatablePsiElement navigatablePsiElement = packageDeclarations instanceof NavigatablePsiElement ? (NavigatablePsiElement)packageDeclarations : null;
        if (navigatablePsiElement != null) {
            navigatablePsiElement.navigate(requestFocus);
        } else {
            PsiElement psiElement = packageDeclarations;
            if (psiElement != null && (psiElement = psiElement.getContainingFile()) != null) {
                psiElement.navigate(requestFocus);
            } else {
                new OpenFileDescriptor(this.module.getProject(), this.virtualFile).navigateInEditor(this.module.getProject(), requestFocus);
            }
        }
    }

    public boolean canNavigate() {
        return !this.module.isDisposed();
    }

    public boolean canNavigateToSource() {
        return true;
    }
}

